/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.model.template.policy;

import java.util.concurrent.TimeUnit;
import org.wso2.apimgt.gateway.cli.constants.GeneratorConstants;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.RequestCountLimitDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ThrottleLimitDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ThrottlePolicyMapper;
import org.wso2.apimgt.gateway.cli.utils.CodegenUtils;

public class ThrottlePolicy {
    private String policyType;
    private String policyKey;
    private String name;
    private long unitTime;
    private String srcPackage;
    private String modelPackage;
    private String funcName;
    private long count;
    private String tierType;
    private boolean stopOnQuotaReach;

    public String getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getUnitTime() {
        return this.unitTime;
    }

    public void setUnitTime(long unitTime) {
        this.unitTime = unitTime;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public String getSrcPackage() {
        return this.srcPackage;
    }

    public void setSrcPackage(String srcPackage) {
        this.srcPackage = srcPackage;
    }

    public String getModelPackage() {
        return this.modelPackage;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public String getFuncName() {
        return this.funcName;
    }

    public void setFuncName(String funcName) {
        this.funcName = funcName;
    }

    public String getPolicyKey() {
        return this.policyKey;
    }

    public void setPolicyKey(String policyKey) {
        this.policyKey = policyKey;
    }

    public String getTierType() {
        return this.tierType;
    }

    public void setTierType(String tierType) {
        this.tierType = tierType;
    }

    public boolean isStopOnQuotaReach() {
        return this.stopOnQuotaReach;
    }

    public void setStopOnQuotaReach(boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
    }

    public ThrottlePolicy buildContext(ThrottlePolicyMapper policy, GeneratorConstants.PolicyType type) {
        this.name = CodegenUtils.trim(policy.getName());
        this.count = policy.getCount();
        this.unitTime = this.getTimeInMilliSeconds(policy.getUnitTime(), policy.getTimeUnit());
        this.stopOnQuotaReach = true;
        switch (type) {
            case RESOURCE: {
                this.policyType = "resource";
                this.funcName = "initResource" + this.name + "Policy";
                this.policyKey = "resourceKey";
                this.tierType = "resourceTier";
                break;
            }
            case APPLICATION: {
                this.policyType = "application";
                this.funcName = "initApplication" + this.name + "Policy";
                this.policyKey = "appKey";
                this.tierType = "appTier";
                break;
            }
            case SUBSCRIPTION: {
                this.policyType = "subscription";
                this.funcName = "initSubscription" + this.name + "Policy";
                this.policyKey = "subscriptionKey";
                this.tierType = "subscriptionTier";
                this.stopOnQuotaReach = policy.getStopOnQuotaReach();
            }
        }
        return this;
    }

    public ThrottlePolicy buildContext(ApplicationThrottlePolicyDTO applicationPolicy) {
        this.policyType = "application";
        this.name = CodegenUtils.trim(applicationPolicy.getPolicyName());
        ThrottleLimitDTO limit = applicationPolicy.getDefaultLimit();
        if (!(limit instanceof RequestCountLimitDTO)) {
            return null;
        }
        RequestCountLimitDTO requestCountLimitDTO = (RequestCountLimitDTO)limit;
        this.count = requestCountLimitDTO.getRequestCount();
        this.unitTime = this.getTimeInMilliSeconds(requestCountLimitDTO.getUnitTime(), requestCountLimitDTO.getTimeUnit());
        this.funcName = "initApplication" + this.name + "Policy";
        this.policyKey = "appKey";
        this.tierType = "appTier";
        this.stopOnQuotaReach = true;
        return this;
    }

    public ThrottlePolicy buildContext(SubscriptionThrottlePolicyDTO applicationPolicy) {
        this.policyType = "subscription";
        this.name = CodegenUtils.trim(applicationPolicy.getPolicyName());
        ThrottleLimitDTO limit = applicationPolicy.getDefaultLimit();
        if (!(limit instanceof RequestCountLimitDTO)) {
            return null;
        }
        RequestCountLimitDTO requestCountLimitDTO = (RequestCountLimitDTO)limit;
        this.count = requestCountLimitDTO.getRequestCount();
        this.unitTime = this.getTimeInMilliSeconds(requestCountLimitDTO.getUnitTime(), requestCountLimitDTO.getTimeUnit());
        this.funcName = "initSubscription" + this.name + "Policy";
        this.policyKey = "subscriptionKey";
        this.tierType = "subscriptionTier";
        this.stopOnQuotaReach = applicationPolicy.getStopOnQuotaReach();
        return this;
    }

    public ThrottlePolicy srcPackage(String srcPackage) {
        if (srcPackage != null) {
            this.srcPackage = srcPackage.replaceFirst("\\.", "/");
        }
        return this;
    }

    public ThrottlePolicy modelPackage(String modelPackage) {
        if (modelPackage != null) {
            this.modelPackage = modelPackage.replaceFirst("\\.", "/");
        }
        return this;
    }

    private long getTimeInMilliSeconds(int unitTime, String timeUnit) {
        long milliSeconds;
        if ("min".equalsIgnoreCase(timeUnit)) {
            milliSeconds = TimeUnit.MINUTES.toMillis(unitTime);
        } else if ("hour".equalsIgnoreCase(timeUnit)) {
            milliSeconds = TimeUnit.HOURS.toMillis(unitTime);
        } else if ("day".equalsIgnoreCase(timeUnit)) {
            milliSeconds = TimeUnit.DAYS.toMillis(unitTime);
        } else if ("week".equalsIgnoreCase(timeUnit)) {
            milliSeconds = 7L * TimeUnit.DAYS.toMillis(unitTime);
        } else if ("month".equalsIgnoreCase(timeUnit)) {
            milliSeconds = 30L * TimeUnit.DAYS.toMillis(unitTime);
        } else if ("year".equalsIgnoreCase(timeUnit)) {
            milliSeconds = 365L * TimeUnit.DAYS.toMillis(unitTime);
        } else {
            throw new RuntimeException("Unsupported time unit provided");
        }
        return milliSeconds;
    }
}

