/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.model.template.service;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.wso2.apimgt.gateway.cli.constants.OpenAPIConstants;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.exception.CLICompileTimeException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.model.config.APIKey;
import org.wso2.apimgt.gateway.cli.model.config.ApplicationSecurity;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.MgwEndpointConfigDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaInterceptor;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaOpenAPIObject;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaParameter;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;
import org.wso2.apimgt.gateway.cli.utils.OpenAPICodegenUtils;

public class BallerinaOperation
implements BallerinaOpenAPIObject<BallerinaOperation, Operation> {
    public static final String X_THROTTLING_TIER = "x-throttling-tier";
    public static final String X_SCOPE = "x-scope";
    public static final String X_AUTH_TYPE = "x-auth-type";
    public static final String AUTH_TYPE_NONE = "None";
    private List<String> tags;
    private String summary;
    private String description;
    private String resourceTier;
    private ExternalDocumentation externalDocs;
    private String operationId;
    private List<BallerinaParameter> parameters;
    private List<BallerinaParameter> pathParameters;
    private String scope;
    private boolean isSecured = true;
    private boolean isSecuredAssignedFromOperation = false;
    private MgwEndpointConfigDTO epConfig;
    private BallerinaInterceptor reqInterceptorContext;
    private BallerinaInterceptor resInterceptorContext;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private boolean isJavaRequestInterceptor;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private boolean isJavaResponseInterceptor;
    private boolean methodNotAllowedOperation = false;
    private boolean methodNotFoundOperation = false;
    private String requestInterceptor;
    private String responseInterceptor;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private List<APIKey> apiKeys;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private List<String> authProviders;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private boolean applicationSecurityOptional;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private boolean hasProdEpConfig = false;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private boolean hasSandEpConfig = false;
    private final List<String> allMethods = Arrays.asList("HEAD", "OPTIONS", "PATCH", "DELETE", "POST", "PUT", "GET");

    @Override
    public BallerinaOperation buildContext(Operation operation, ExtendedAPI api) throws BallerinaServiceGenException, CLICompileTimeException, CLIRuntimeException {
        if (operation == null) {
            return this.getDefaultValue();
        }
        operation.setOperationId(UUID.randomUUID().toString().replaceAll("-", ""));
        this.operationId = operation.getOperationId();
        this.tags = operation.getTags();
        this.summary = operation.getSummary();
        this.description = operation.getDescription();
        this.externalDocs = operation.getExternalDocs();
        this.parameters = new ArrayList<BallerinaParameter>();
        this.pathParameters = new ArrayList<BallerinaParameter>();
        ApplicationSecurity appSecurity = OpenAPICodegenUtils.populateApplicationSecurity(api.getName(), api.getVersion(), operation.getExtensions(), api.getMutualSSL());
        this.authProviders = OpenAPICodegenUtils.getMgwResourceSecurity(operation, appSecurity);
        this.apiKeys = OpenAPICodegenUtils.generateAPIKeysFromSecurity(operation.getSecurity(), this.authProviders.contains(OpenAPIConstants.APISecurity.apikey.name()));
        ApplicationSecurity apiAppSecurity = api.getApplicationSecurity();
        if (appSecurity != null && appSecurity.isOptional() != null) {
            this.applicationSecurityOptional = appSecurity.isOptional();
        } else if (apiAppSecurity != null && apiAppSecurity.isOptional() != null) {
            this.applicationSecurityOptional = apiAppSecurity.isOptional();
        }
        this.scope = OpenAPICodegenUtils.getMgwResourceScope(operation);
        this.setEpConfigDTO(operation);
        if (api.getEndpointConfigRepresentation().getProdEndpointList() == null && api.getEndpointConfigRepresentation().getSandboxEndpointList() == null && !this.hasProdEpConfig && !this.hasSandEpConfig) {
            throw new CLICompileTimeException("The endpoint Configuration is not provided for the operation.");
        }
        Map<String, Object> exts = operation.getExtensions();
        if (exts != null) {
            Object reqExt = exts.get("x-wso2-request-interceptor");
            Object resExt = exts.get("x-wso2-response-interceptor");
            if (reqExt != null) {
                this.reqInterceptorContext = new BallerinaInterceptor(reqExt.toString());
                this.requestInterceptor = this.reqInterceptorContext.getInvokeStatement();
                boolean bl = this.isJavaRequestInterceptor = BallerinaInterceptor.Type.JAVA == this.reqInterceptorContext.getType();
            }
            if (resExt != null) {
                this.resInterceptorContext = new BallerinaInterceptor(resExt.toString());
                this.responseInterceptor = this.resInterceptorContext.getInvokeStatement();
                this.isJavaResponseInterceptor = BallerinaInterceptor.Type.JAVA == this.resInterceptorContext.getType();
            }
            Optional<Object> scopes = Optional.ofNullable(exts.get(X_SCOPE));
            scopes.ifPresent(value -> {
                this.scope = "\"" + value.toString() + "\"";
            });
            Optional<Object> authType = Optional.ofNullable(exts.get(X_AUTH_TYPE));
            authType.ifPresent(value -> {
                if (AUTH_TYPE_NONE.equals(value)) {
                    this.isSecured = false;
                }
            });
            Optional<Object> resourceTier = Optional.ofNullable(exts.get(X_THROTTLING_TIER));
            resourceTier.ifPresent(value -> {
                this.resourceTier = value.toString();
            });
            if (this.resourceTier == null) {
                Optional<Object> extResourceTier = Optional.ofNullable(exts.get("x-wso2-throttling-tier"));
                extResourceTier.ifPresent(value -> {
                    this.resourceTier = value.toString();
                });
            }
            if (api.getApiLevelPolicy() != null && this.resourceTier != null) {
                String message = "[WARN] : Resource level policy: " + this.resourceTier + " will be neglected due to the presence of API level policy: " + api.getApiLevelPolicy() + " for the API : " + api.getName() + "\n";
                CmdUtils.appendMessagesToConsole(message);
                this.resourceTier = null;
            }
            Optional<Object> extDisableSecurity = Optional.ofNullable(exts.get("x-wso2-disable-security"));
            extDisableSecurity.ifPresent(value -> {
                try {
                    this.isSecured = (Boolean)value == false;
                    this.isSecuredAssignedFromOperation = true;
                }
                catch (ClassCastException e) {
                    throw new CLIRuntimeException("The property 'x-wso2-disable-security' should be a boolean value. But provided '" + value.toString() + "'.");
                }
            });
        }
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                if ("path".equals(parameter.getIn())) {
                    this.pathParameters.add(new BallerinaParameter().buildContext(parameter, api));
                }
                this.parameters.add(new BallerinaParameter().buildContext(parameter, api));
            }
        }
        return this;
    }

    @Override
    public BallerinaOperation buildContext(Operation operation) throws BallerinaServiceGenException, CLICompileTimeException {
        return this.buildContext(operation, (ExtendedAPI)null);
    }

    public BallerinaOperation buildContextForNotAllowed(ExtendedAPI api) throws BallerinaServiceGenException, CLICompileTimeException {
        this.methodNotAllowedOperation = true;
        this.isSecured = false;
        this.isSecuredAssignedFromOperation = true;
        Operation operation = new Operation();
        return this.buildContext(operation, api);
    }

    public BallerinaOperation buildContextForNotFound(ExtendedAPI api) throws BallerinaServiceGenException, CLICompileTimeException {
        this.methodNotFoundOperation = true;
        this.isSecured = false;
        this.isSecuredAssignedFromOperation = true;
        Operation operation = new Operation();
        return this.buildContext(operation, api);
    }

    @Override
    public BallerinaOperation getDefaultValue() {
        return new BallerinaOperation();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public List<BallerinaParameter> getParameters() {
        return this.parameters;
    }

    public List<BallerinaParameter> getPathParameters() {
        return this.pathParameters;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public List<String> getAllMethods() {
        return this.allMethods;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    public String getResourceTier() {
        return this.resourceTier;
    }

    public void setResourceTier(String resourceTier) {
        this.resourceTier = resourceTier;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (this.scope == null) {
            this.scope = scope;
        }
    }

    public boolean isSecured() {
        return this.isSecured;
    }

    public void setSecured(boolean secured) {
        if (this.isSecuredAssignedFromOperation) {
            return;
        }
        this.isSecured = secured;
    }

    public MgwEndpointConfigDTO getEpConfigDTO() {
        return this.epConfig;
    }

    private void setEpConfigDTO(Operation operation) throws CLICompileTimeException {
        this.epConfig = OpenAPICodegenUtils.getResourceEpConfigForCodegen(operation);
        if (this.epConfig.getProdEndpointList() != null) {
            this.hasProdEpConfig = true;
        }
        if (this.epConfig.getSandboxEndpointList() != null) {
            this.hasSandEpConfig = true;
        }
    }

    public String getRequestInterceptor() {
        return this.requestInterceptor;
    }

    public void setRequestInterceptor(String requestInterceptor) {
        this.requestInterceptor = requestInterceptor;
    }

    public String getResponseInterceptor() {
        return this.responseInterceptor;
    }

    public void setResponseInterceptor(String responseInterceptor) {
        this.responseInterceptor = responseInterceptor;
    }

    public BallerinaInterceptor getReqInterceptorContext() {
        return this.reqInterceptorContext;
    }

    public void setReqInterceptorContext(BallerinaInterceptor reqInterceptorContext) {
        this.reqInterceptorContext = reqInterceptorContext;
    }

    public BallerinaInterceptor getResInterceptorContext() {
        return this.resInterceptorContext;
    }

    public void setResInterceptorContext(BallerinaInterceptor resInterceptorContext) {
        this.resInterceptorContext = resInterceptorContext;
    }

    void setSecuritySchemas(List<String> authProviders) {
        if (this.authProviders.isEmpty()) {
            this.authProviders = new ArrayList<String>(authProviders);
        }
        if (!this.applicationSecurityOptional && this.authProviders.isEmpty()) {
            OpenAPICodegenUtils.addDefaultAuthProviders(this.authProviders);
        }
    }

    public boolean isMethodNotAllowedOperation() {
        return this.methodNotAllowedOperation;
    }

    public void setMethodNotAllowedOperation(boolean methodNotAllowedOperation) {
        this.methodNotAllowedOperation = methodNotAllowedOperation;
    }

    public boolean isMethodNotFoundOperation() {
        return this.methodNotFoundOperation;
    }

    public void setMethodNotFoundOperation(boolean methodNotFoundOperation) {
        this.methodNotFoundOperation = methodNotFoundOperation;
    }
}

