/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.model.template.service;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerator;
import org.wso2.apimgt.gateway.cli.constants.OpenAPIConstants;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.exception.CLICompileTimeException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.model.config.APIKey;
import org.wso2.apimgt.gateway.cli.model.config.ApplicationSecurity;
import org.wso2.apimgt.gateway.cli.model.config.CodeGen;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.ContainerConfig;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.MgwEndpointConfigDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaInterceptor;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaOpenAPIObject;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaOperation;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaPath;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;
import org.wso2.apimgt.gateway.cli.utils.CodegenUtils;
import org.wso2.apimgt.gateway.cli.utils.OpenAPICodegenUtils;

public class BallerinaService
implements BallerinaOpenAPIObject<BallerinaService, OpenAPI> {
    private String name;
    private ContainerConfig containerConfig;
    private Config config;
    private MgwEndpointConfigDTO endpointConfig;
    private String srcPackage;
    private String modelPackage;
    private String qualifiedServiceName;
    private String projectName;
    private Info info = null;
    private List<Tag> tags = null;
    private Set<Map.Entry<String, BallerinaPath>> paths = null;
    private String basepath;
    private ArrayList<String> importModules = new ArrayList();
    private HashMap<String, String> libVersions = new HashMap();
    private boolean isGrpc;
    private boolean hasEpSecurity = false;
    private boolean generateApiFaultResponses = false;
    private boolean addMethodNotFoundService = false;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private List<String> authProviders;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private List<APIKey> apiKeys;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private boolean isMutualSSL = false;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private String mutualSSLClientVerification;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private boolean applicationSecurityOptional;
    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    private ExtendedAPI api;
    private String requestInterceptor;
    private String responseInterceptor;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private boolean isJavaRequestInterceptor;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private boolean isJavaResponseInterceptor;

    @Override
    public BallerinaService buildContext(OpenAPI openAPI) {
        this.info = openAPI.getInfo();
        this.tags = openAPI.getTags();
        this.containerConfig = CmdUtils.getContainerConfig();
        this.config = CmdUtils.getConfig();
        return this;
    }

    @Override
    public BallerinaService buildContext(OpenAPI definition, ExtendedAPI api) throws BallerinaServiceGenException {
        this.name = CodegenUtils.trim(api.getName());
        this.api = api;
        this.qualifiedServiceName = CodegenUtils.trim(api.getName()) + "__" + this.replaceAllNonAlphaNumeric(api.getVersion());
        this.endpointConfig = api.getEndpointConfigRepresentation();
        this.isGrpc = api.isGrpc();
        this.setProjectName(CodeGenerator.projectName);
        this.setBasepath(api.getSpecificBasepath());
        ApplicationSecurity appSecurity = api.getApplicationSecurity();
        this.authProviders = OpenAPICodegenUtils.getAuthProviders(api.getMgwApiSecurity(), appSecurity);
        this.apiKeys = OpenAPICodegenUtils.generateAPIKeysFromSecurity(definition.getSecurity(), this.authProviders.contains(OpenAPIConstants.APISecurity.apikey.name()));
        if (api.getMutualSSL() != null) {
            this.isMutualSSL = true;
            this.mutualSSLClientVerification = api.getMutualSSL();
        }
        if (appSecurity != null && appSecurity.isOptional() != null) {
            this.applicationSecurityOptional = appSecurity.isOptional();
        }
        this.addAPILevelPolicy(definition);
        this.setHasEpSecurity(this.endpointConfig);
        this.setPaths(definition);
        if (!this.applicationSecurityOptional && this.authProviders.isEmpty()) {
            OpenAPICodegenUtils.addDefaultAuthProviders(this.authProviders);
        }
        this.resolveInterceptors(definition.getExtensions());
        this.setResponseCache(definition.getExtensions());
        return this.buildContext(definition);
    }

    @Override
    public BallerinaService getDefaultValue() {
        return null;
    }

    public BallerinaService srcPackage(String srcPackage) {
        if (srcPackage != null) {
            this.srcPackage = srcPackage.replaceFirst("\\.", "/");
        }
        return this;
    }

    public BallerinaService modelPackage(String modelPackage) {
        if (modelPackage != null) {
            this.modelPackage = modelPackage.replaceFirst("\\.", "/");
        }
        return this;
    }

    public String getSrcPackage() {
        return this.srcPackage;
    }

    public String getModelPackage() {
        return this.modelPackage;
    }

    public Info getInfo() {
        return this.info;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public HashMap<String, String> getLibVersions() {
        return this.libVersions;
    }

    public Set<Map.Entry<String, BallerinaPath>> getPaths() {
        return this.paths;
    }

    private void setPaths(OpenAPI openAPI) throws BallerinaServiceGenException {
        CodeGen codeGenConfig = CmdUtils.getConfig().getCodeGen();
        this.generateApiFaultResponses = codeGenConfig != null ? codeGenConfig.getApiFaultResponses() : false;
        if (openAPI.getPaths() == null || this.api == null) {
            return;
        }
        if (this.generateApiFaultResponses) {
            this.addMethodNotFoundPath(openAPI);
        }
        this.paths = new LinkedHashSet<Map.Entry<String, BallerinaPath>>();
        Paths pathList = openAPI.getPaths();
        for (Map.Entry path : pathList.entrySet()) {
            BallerinaPath balPath = null;
            try {
                balPath = ((String)path.getKey()).equals("/*") && this.addMethodNotFoundService ? new BallerinaPath().buildContextForNotFound(this.api) : new BallerinaPath().buildContext((PathItem)path.getValue(), this.api, this.generateApiFaultResponses);
            }
            catch (CLICompileTimeException e) {
                throw new CLIRuntimeException("Error while parsing information under path:" + (String)path.getKey() + "in the API \"" + this.api.getName() + ":" + this.api.getVersion() + "\".\n\t-" + e.getTerminalMsg(), e);
            }
            balPath.getOperations().forEach(op -> {
                BallerinaOperation operation = (BallerinaOperation)op.getValue();
                String randomUUID = UUID.randomUUID().toString().replaceAll("-", "");
                String operationId = ((BallerinaOperation)op.getValue()).isMethodNotFoundOperation() || ((BallerinaOperation)op.getValue()).isMethodNotAllowedOperation() ? (String)op.getKey() + "_InvalidOperation_" + randomUUID : (String)op.getKey() + randomUUID;
                operation.setOperationId(operationId);
                this.setHasEpSecurity(operation.getEpConfigDTO());
                this.updateOperationInterceptors(operation);
                operation.setSecuritySchemas(this.authProviders);
                Optional<Object> disableSecurity = Optional.ofNullable(openAPI.getExtensions().get("x-wso2-disable-security"));
                disableSecurity.ifPresent(value -> {
                    try {
                        boolean secured = (Boolean)value == false;
                        operation.setSecured(secured);
                    }
                    catch (ClassCastException e) {
                        throw new CLIRuntimeException("The property 'x-wso2-disable-security' should be a boolean value. But provided '" + value.toString() + "'.");
                    }
                });
                operation.setScope(this.api.getMgwApiScope());
            });
            this.paths.add(new AbstractMap.SimpleEntry(path.getKey(), balPath));
        }
    }

    private void addImport(String importStmt) {
        if (!this.importModules.contains(importStmt) && importStmt != null) {
            this.importModules.add(importStmt);
        }
    }

    private void addAPILevelPolicy(OpenAPI openAPI) {
        Optional<Object> apiThrottlePolicy = Optional.ofNullable(openAPI.getExtensions().get("x-wso2-throttling-tier"));
        if (!apiThrottlePolicy.isPresent()) {
            apiThrottlePolicy = Optional.ofNullable(openAPI.getExtensions().get("x-throttling-tier"));
        }
        apiThrottlePolicy.ifPresent(value -> this.api.setApiLevelPolicy(value.toString()));
    }

    private void resolveInterceptors(Map<String, Object> exts) throws BallerinaServiceGenException {
        Object reqExt = exts.get("x-wso2-request-interceptor");
        Object resExt = exts.get("x-wso2-response-interceptor");
        if (reqExt != null) {
            BallerinaInterceptor reqInterceptor = new BallerinaInterceptor(reqExt.toString());
            if (BallerinaInterceptor.Type.CENTRAL == reqInterceptor.getType()) {
                if (reqInterceptor.getVersion() != null) {
                    this.addLibVersion(reqInterceptor.getFqn(), reqInterceptor.getVersion());
                }
                this.addImport(reqInterceptor.getImportStatement());
            }
            this.isJavaRequestInterceptor = BallerinaInterceptor.Type.JAVA == reqInterceptor.getType();
            this.requestInterceptor = reqInterceptor.getInvokeStatement();
        }
        if (resExt != null) {
            BallerinaInterceptor resInterceptor = new BallerinaInterceptor(resExt.toString());
            if (BallerinaInterceptor.Type.CENTRAL == resInterceptor.getType()) {
                if (resInterceptor.getVersion() != null) {
                    this.addLibVersion(resInterceptor.getFqn(), resInterceptor.getVersion());
                }
                this.addImport(resInterceptor.getImportStatement());
            }
            this.isJavaResponseInterceptor = BallerinaInterceptor.Type.JAVA == resInterceptor.getType();
            this.responseInterceptor = resInterceptor.getInvokeStatement();
        }
    }

    private void updateOperationInterceptors(BallerinaOperation operation) {
        BallerinaInterceptor reqInterceptor = operation.getReqInterceptorContext();
        BallerinaInterceptor resInterceptor = operation.getResInterceptorContext();
        if (reqInterceptor != null && BallerinaInterceptor.Type.CENTRAL == reqInterceptor.getType()) {
            if (reqInterceptor.getVersion() != null) {
                this.addLibVersion(reqInterceptor.getFqn(), reqInterceptor.getVersion());
            }
            this.addImport(reqInterceptor.getImportStatement());
        }
        if (resInterceptor != null && BallerinaInterceptor.Type.CENTRAL == resInterceptor.getType()) {
            if (resInterceptor.getVersion() != null) {
                this.addLibVersion(resInterceptor.getFqn(), resInterceptor.getVersion());
            }
            this.addImport(resInterceptor.getImportStatement());
        }
    }

    private void addLibVersion(String libName, String libVersion) {
        if (!this.libVersions.containsKey(libName) && libVersion != null) {
            this.libVersions.put(libName, libVersion);
        }
    }

    private String replaceAllNonAlphaNumeric(String value) {
        return value.replaceAll("[^a-zA-Z0-9]+", "_");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MgwEndpointConfigDTO getEndpointConfig() {
        return this.endpointConfig;
    }

    public void setEndpointConfig(MgwEndpointConfigDTO endpointConfig) {
        this.endpointConfig = endpointConfig;
    }

    public ExtendedAPI getApi() {
        return this.api;
    }

    public void setApi(ExtendedAPI api) {
        this.api = api;
    }

    public String getQualifiedServiceName() {
        return this.qualifiedServiceName;
    }

    public void setQualifiedServiceName(String qualifiedServiceName) {
        this.qualifiedServiceName = qualifiedServiceName;
    }

    public ContainerConfig getContainerConfig() {
        return this.containerConfig;
    }

    public void setContainerConfig(ContainerConfig containerConfig) {
        this.containerConfig = containerConfig;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String getBasepath() {
        return this.basepath;
    }

    public void setBasepath(String basepath) {
        this.basepath = basepath;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setHasEpSecurity(MgwEndpointConfigDTO endpointConfig) {
        if (this.hasEpSecurity || endpointConfig == null) {
            return;
        }
        if (endpointConfig.getProdEndpointList() != null && endpointConfig.getProdEndpointList().getSecurityConfig() != null || endpointConfig.getSandboxEndpointList() != null && endpointConfig.getSandboxEndpointList().getSecurityConfig() != null) {
            this.hasEpSecurity = true;
        }
    }

    public void setResponseCache(Map<String, Object> exts) {
        Object responseCacheObject;
        if (exts != null && (responseCacheObject = exts.get("x-wso2-response-cache")) != null) {
            Map cacheObjectMap = (Map)responseCacheObject;
            boolean enabled = (Boolean)cacheObjectMap.get("enabled");
            if (enabled) {
                this.api.setResponseCaching("Enabled");
                if (cacheObjectMap.containsKey("cacheTimeoutInSeconds")) {
                    int cacheTimeout = (Integer)cacheObjectMap.get("cacheTimeoutInSeconds");
                    this.api.setCacheTimeout(cacheTimeout * 1000);
                }
            } else {
                this.api.setResponseCaching("Disabled");
            }
        }
    }

    public boolean isGenerateApiFaultResponses() {
        return this.generateApiFaultResponses;
    }

    public void setGenerateApiFaultResponses(boolean generateApiFaultResponses) {
        this.generateApiFaultResponses = generateApiFaultResponses;
    }

    public boolean isAddMethodNotFoundService() {
        return this.addMethodNotFoundService;
    }

    public void setAddMethodNotFoundService(boolean addMethodNotFoundService) {
        this.addMethodNotFoundService = addMethodNotFoundService;
    }

    public void addMethodNotFoundPath(OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        if (!paths.containsKey("/*")) {
            paths.addPathItem("/*", new PathItem());
            this.addMethodNotFoundService = true;
        }
        openAPI.setPaths(paths);
    }

    public String getRequestInterceptor() {
        return this.requestInterceptor;
    }

    public void setRequestInterceptor(String requestInterceptor) {
        this.requestInterceptor = requestInterceptor;
    }

    public String getResponseInterceptor() {
        return this.responseInterceptor;
    }

    public void setResponseInterceptor(String responseInterceptor) {
        this.responseInterceptor = responseInterceptor;
    }
}

