/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.protobuf;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.model.route.EndpointListRouteDTO;

public class ProtoOpenAPI {
    private static final Logger logger = LoggerFactory.getLogger(ProtoOpenAPI.class);
    private static final String OAUTH2_SCHEME = "grpc-oauth2-scheme";
    private static final String BASIC_SCHEME = "grpc-basic-scheme";
    private static final String APIKEY_SCHEME = "grpc-apikey-scheme";
    private boolean isBasicAuthEnabled = false;
    private boolean isOauth2Enabled = false;
    private boolean isAPIKeyEnabled = false;
    private boolean isSecurityDisabled = false;
    private boolean endpointsAvailable = false;
    private OpenAPI openAPI = new OpenAPI();

    ProtoOpenAPI() {
        this.openAPI.setComponents(new Components());
    }

    void addOpenAPIInfo(String name) {
        Info info = new Info();
        info.setTitle(name);
        info.setVersion("1.0.0");
        this.openAPI.setInfo(info);
        this.openAPI.addExtension("x-wso2-basePath", "/" + name);
    }

    void addOpenAPIPath(String path, String[] scopes, String throttlingTier) {
        PathItem pathItem = new PathItem();
        Operation operation = new Operation();
        operation.setOperationId(UUID.randomUUID().toString());
        if (StringUtils.isNotEmpty((CharSequence)throttlingTier)) {
            operation.addExtension("x-wso2-throttling-tier", throttlingTier);
        }
        if (this.isBasicAuthEnabled) {
            this.addBasicAuthSecurityRequirement(operation);
        }
        if (this.isAPIKeyEnabled) {
            this.addAPIKeySecurityRequirement(operation);
        }
        if (this.isOauth2Enabled) {
            this.addOauth2SecurityRequirement(operation, scopes);
        }
        pathItem.setPost(operation);
        if (this.openAPI.getPaths() == null) {
            this.openAPI.setPaths(new Paths());
        }
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setDescription("gRPC response");
        ApiResponses apiResponses = new ApiResponses();
        apiResponses.addApiResponse("200", apiResponse);
        operation.setResponses(apiResponses);
        this.openAPI.getPaths().addPathItem("/" + path, pathItem);
    }

    void addAPIProdEpExtension(EndpointListRouteDTO endpointListRouteDTO) {
        if (endpointListRouteDTO == null) {
            return;
        }
        this.openAPI.addExtension("x-wso2-production-endpoints", endpointListRouteDTO);
        this.endpointsAvailable = true;
    }

    void addAPISandEpExtension(EndpointListRouteDTO endpointListRouteDTO) {
        if (endpointListRouteDTO == null) {
            return;
        }
        this.openAPI.addExtension("x-wso2-sandbox-endpoints", endpointListRouteDTO);
        this.endpointsAvailable = true;
    }

    private void addOauth2SecurityScheme() {
        OAuthFlow flowObj = new OAuthFlow();
        flowObj.setAuthorizationUrl("http://dummmyVal.com");
        flowObj.setScopes(new Scopes());
        SecurityScheme scheme = new SecurityScheme();
        scheme.setType(SecurityScheme.Type.OAUTH2);
        scheme.setFlows(new OAuthFlows().implicit(flowObj));
        this.openAPI.getComponents().addSecuritySchemes(OAUTH2_SCHEME, scheme);
        this.isOauth2Enabled = true;
    }

    private void addBasicSecurityScheme() {
        SecurityScheme scheme = new SecurityScheme();
        scheme.setType(SecurityScheme.Type.HTTP);
        scheme.setScheme("basic");
        this.openAPI.getComponents().addSecuritySchemes(BASIC_SCHEME, scheme);
        this.isBasicAuthEnabled = true;
    }

    private void addAPIKeySecurityScheme() {
        SecurityScheme scheme = new SecurityScheme();
        scheme.setType(SecurityScheme.Type.APIKEY);
        scheme.setName("api_key");
        scheme.setIn(SecurityScheme.In.HEADER);
        this.openAPI.getComponents().addSecuritySchemes(APIKEY_SCHEME, scheme);
        this.isAPIKeyEnabled = true;
    }

    private void addScopeToSchema(String scope) {
        if (StringUtils.isEmpty((CharSequence)scope)) {
            return;
        }
        SecurityScheme scheme = this.openAPI.getComponents().getSecuritySchemes().get(OAUTH2_SCHEME);
        if (!scheme.getFlows().getImplicit().getScopes().containsKey(scope)) {
            scheme.getFlows().getImplicit().setScopes(new Scopes().addString(scope, ""));
        }
    }

    private void addOauth2SecurityRequirement(Operation operation, String[] scopes) {
        if (!this.isOauth2Enabled && scopes != null && scopes.length > 0 && !scopes[0].isEmpty()) {
            throw new CLIRuntimeException("Scopes cannot be added if \"oauth2\" is not provided as security type.");
        }
        SecurityRequirement oauth2Req = new SecurityRequirement();
        if (scopes != null) {
            for (String scope : scopes) {
                this.addScopeToSchema(scope);
            }
            oauth2Req.addList(OAUTH2_SCHEME, Arrays.asList(scopes));
        } else {
            oauth2Req.addList(OAUTH2_SCHEME);
        }
        if (operation == null) {
            this.openAPI.addSecurityItem(oauth2Req);
        } else {
            operation.addSecurityItem(oauth2Req);
        }
    }

    private void addBasicAuthSecurityRequirement(Operation operation) {
        if (!this.isBasicAuthEnabled) {
            return;
        }
        if (this.openAPI.getComponents().getSecuritySchemes().get(BASIC_SCHEME) != null) {
            SecurityRequirement basicAuthReq = new SecurityRequirement();
            basicAuthReq.addList(BASIC_SCHEME);
            if (operation == null) {
                this.openAPI.addSecurityItem(basicAuthReq);
            } else {
                operation.addSecurityItem(basicAuthReq);
            }
        }
    }

    private void addAPIKeySecurityRequirement(Operation operation) {
        if (!this.isAPIKeyEnabled) {
            return;
        }
        if (this.openAPI.getComponents().getSecuritySchemes().get(APIKEY_SCHEME) != null) {
            SecurityRequirement apikeyReq = new SecurityRequirement();
            apikeyReq.addList(APIKEY_SCHEME);
            if (operation == null) {
                this.openAPI.addSecurityItem(apikeyReq);
            } else {
                operation.addSecurityItem(apikeyReq);
            }
        }
    }

    void addAPIOauth2SecurityRequirement() {
        this.addOauth2SecurityScheme();
        this.addOauth2SecurityRequirement(null, null);
    }

    void addAPIBasicSecurityRequirement() {
        this.addBasicSecurityScheme();
        this.addBasicAuthSecurityRequirement(null);
    }

    void addAPIKeySecurityRequirement() {
        this.addAPIKeySecurityScheme();
        this.addAPIKeySecurityRequirement(null);
    }

    void disableAPISecurity() {
        this.openAPI.addExtension("x-wso2-disable-security", true);
        this.isSecurityDisabled = true;
    }

    private void checkSecurityTypeIncompatibility(String service) {
        if ((this.isOauth2Enabled || this.isBasicAuthEnabled || this.isAPIKeyEnabled) && this.isSecurityDisabled) {
            throw new CLIRuntimeException("\"None\" security type is incompatible with other security types. service : \"" + service + "\".");
        }
    }

    void setAPIThrottlingTier(String throttlingTier) {
        if (StringUtils.isEmpty((CharSequence)throttlingTier)) {
            return;
        }
        this.openAPI.addExtension("x-wso2-throttling-tier", throttlingTier);
    }

    private void checkEndpointAvailability(String service) {
        if (!this.endpointsAvailable) {
            throw new CLIRuntimeException("No endpoints provided in the service : \"" + service + "\".");
        }
    }

    OpenAPI getOpenAPI(String service) {
        this.checkEndpointAvailability(service);
        this.checkSecurityTypeIncompatibility(service);
        logger.debug("Corresponding openAPI is successfully generated. \n" + this.openAPI.toString());
        return this.openAPI;
    }
}

