/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.protobuf;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLICompileTimeException;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.model.route.EndpointListRouteDTO;
import org.wso2.apimgt.gateway.cli.protobuf.ExtensionHolder;
import org.wso2.apimgt.gateway.cli.protobuf.ProtoOpenAPI;
import org.wso2.apimgt.gateway.cli.protobuf.ProtocCommandBuilder;

public class ProtobufParser {
    private static final Logger logger = LoggerFactory.getLogger(ProtobufParser.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DescriptorProtos.FileDescriptorProto generateRootFileDescriptor(String protoPath, String descriptorPath) {
        String command = new ProtocCommandBuilder(protoPath, ProtobufParser.resolveProtoFolderPath(protoPath), descriptorPath).build();
        ProtobufParser.generateDescriptor(command);
        File initialFile = new File(descriptorPath);
        try (FileInputStream targetStream = new FileInputStream(initialFile);){
            ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();
            ExtensionHolder.registerAllExtensions(extensionRegistry);
            DescriptorProtos.FileDescriptorSet set = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)targetStream, (ExtensionRegistryLite)extensionRegistry);
            logger.debug("Descriptor file is parsed successfully. file:", (Object)descriptorPath);
            if (set.getFileList().size() <= 0) return null;
            DescriptorProtos.FileDescriptorProto fileDescriptorProto = set.getFile(0);
            return fileDescriptorProto;
        }
        catch (IOException e) {
            throw new CLIInternalException("Error reading generated descriptor file '" + descriptorPath + "'.", e);
        }
    }

    private static void generateDescriptor(String command) {
        Process process;
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (isWindows) {
            builder.command("cmd.exe", "/c", command);
        } else {
            builder.command("sh", "-c", command);
        }
        builder.directory(new File(System.getProperty("user.home")));
        try {
            process = builder.start();
        }
        catch (IOException e) {
            throw new CLIInternalException("Error in executing protoc command '" + builder.command() + "'.", e);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new CLIRuntimeException("Process is not completed. Process is interrupted while running the protoc executor.", e);
        }
        if (process.exitValue() != 0) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    try {
                        String err;
                        StringBuilder errMsg = new StringBuilder();
                        while ((err = bufferedReader.readLine()) != null) {
                            errMsg.append(System.lineSeparator()).append(err);
                        }
                        throw new CLIRuntimeException(errMsg.toString());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (bufferedReader != null) {
                        if (throwable != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            bufferedReader.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new CLIInternalException("Invalid command syntax.", e);
            }
        }
        logger.debug("Descriptor file is generation command : \"" + command + "\" is executed successfully.");
    }

    private static String resolveProtoFolderPath(String protoPath) {
        int idx = protoPath.lastIndexOf(File.separator);
        String protoFolderPath = "";
        if (idx > 0) {
            protoFolderPath = protoPath.substring(0, idx);
        }
        return protoFolderPath;
    }

    private static ArrayList<OpenAPI> generateOpenAPIFromProto(DescriptorProtos.FileDescriptorProto descriptor, String protoPath) {
        if (descriptor == null) {
            throw new CLIInternalException("descriptor is not available");
        }
        if (descriptor.getServiceCount() == 0) {
            return null;
        }
        ArrayList<OpenAPI> openAPIS = new ArrayList<OpenAPI>();
        descriptor.getServiceList().forEach(service -> {
            ProtoOpenAPI protoOpenAPI = new ProtoOpenAPI();
            if (StringUtils.isEmpty((CharSequence)descriptor.getPackage())) {
                protoOpenAPI.addOpenAPIInfo(service.getName());
            } else {
                protoOpenAPI.addOpenAPIInfo(descriptor.getPackage() + "." + service.getName());
            }
            protoOpenAPI.addAPIProdEpExtension(ProtobufParser.generateEpList((ExtensionHolder.Endpoints)service.getOptions().getExtension(ExtensionHolder.productionEndpoints), service.getName()));
            protoOpenAPI.addAPISandEpExtension(ProtobufParser.generateEpList((ExtensionHolder.Endpoints)service.getOptions().getExtension(ExtensionHolder.sandboxEndpoints), service.getName()));
            List securityList = (List)service.getOptions().getExtension(ExtensionHolder.security);
            if (securityList.size() == 0) {
                protoOpenAPI.disableAPISecurity();
            } else {
                if (securityList.contains((Object)ExtensionHolder.Security.NONE)) {
                    protoOpenAPI.disableAPISecurity();
                }
                if (securityList.contains((Object)ExtensionHolder.Security.BASIC)) {
                    protoOpenAPI.addAPIBasicSecurityRequirement();
                }
                if (securityList.contains((Object)ExtensionHolder.Security.OAUTH2) || securityList.contains((Object)ExtensionHolder.Security.JWT)) {
                    protoOpenAPI.addAPIOauth2SecurityRequirement();
                }
                if (securityList.contains((Object)ExtensionHolder.Security.APIKEY)) {
                    protoOpenAPI.addAPIKeySecurityRequirement();
                }
            }
            String throttlingTier = (String)service.getOptions().getExtension(ExtensionHolder.throttlingTier);
            protoOpenAPI.setAPIThrottlingTier(throttlingTier);
            service.getMethodList().forEach(method -> {
                String methodScopesString = (String)method.getOptions().getExtension(ExtensionHolder.methodScopes);
                String methodThrottlingTier = (String)method.getOptions().getExtension(ExtensionHolder.methodThrottlingTier);
                String[] methodScopes = null;
                if (!methodScopesString.isEmpty()) {
                    methodScopes = methodScopesString.split(",");
                }
                protoOpenAPI.addOpenAPIPath(method.getName(), methodScopes, methodThrottlingTier);
            });
            openAPIS.add(protoOpenAPI.getOpenAPI(service.getName()));
        });
        return openAPIS;
    }

    public ArrayList<OpenAPI> generateOpenAPI(String protoPath, String descriptorPath) {
        DescriptorProtos.FileDescriptorProto descriptor = ProtobufParser.generateRootFileDescriptor(protoPath, descriptorPath);
        return ProtobufParser.generateOpenAPIFromProto(descriptor, protoPath);
    }

    private static EndpointListRouteDTO generateEpList(ExtensionHolder.Endpoints protoEps, String service) {
        EndpointListRouteDTO epList = new EndpointListRouteDTO();
        protoEps.getUrlList().forEach(epList::addEndpoint);
        try {
            epList.validateEndpoints();
        }
        catch (CLICompileTimeException e) {
            throw new CLIRuntimeException("The provided endpoint string for the gRPC \"" + service + "\" is invalid.\n\t-" + e.getTerminalMsg(), e);
        }
        if (epList.getEndpoints() == null) {
            return null;
        }
        if (epList.getEndpoints().size() > 1) {
            throw new CLIRuntimeException("Multiple endpoints are not supported .service :" + service + ".");
        }
        return epList;
    }
}

