/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.protobuf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.protobuf.OSDetector;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;

public class ProtocCommandBuilder {
    private static final String EXE_PATH_PLACEHOLDER = "{{exe_file_path}}";
    private static final String PROTO_PATH_PLACEHOLDER = "{{proto_file_path}}";
    private static final String PROTO_FOLDER_PLACEHOLDER = "{{proto_folder_path}}";
    private static final String DESC_PATH_PLACEHOLDER = "{{desc_file_path}}";
    private static final String COMMAND_PLACEHOLDER = "{{exe_file_path}} --proto_path={{proto_folder_path}} {{proto_file_path}} --descriptor_set_out={{desc_file_path}}";
    public static final String PROTOC_PLUGIN_EXE_URL_SUFFIX = "https://repo1.maven.org/maven2/com/google/protobuf/protoc/";
    private String protocVersion = "3.9.1";
    public static final String PROTOC_PLUGIN_EXE_PREFIX = ".exe";
    private String exePath = ProtocCommandBuilder.getProtocExePath();
    private String protoPath;
    private String protoFolderPath;
    private String descriptorSetOutPath;
    private static final Logger logger = LoggerFactory.getLogger(ProtocCommandBuilder.class);
    private static final PrintStream OUT = System.out;

    ProtocCommandBuilder(String protoPath, String protofolderPath, String descriptorSetOutPath) {
        this.protoPath = protoPath;
        this.descriptorSetOutPath = descriptorSetOutPath;
        this.protoFolderPath = protofolderPath;
    }

    public String build() {
        try {
            this.downloadProtocexe();
        }
        catch (IOException e) {
            throw new CLIInternalException("Error while downloading the protoc executable : protoc-" + OSDetector.getDetectedClassifier() + PROTOC_PLUGIN_EXE_PREFIX);
        }
        String finalCommand = COMMAND_PLACEHOLDER.replace(EXE_PATH_PLACEHOLDER, this.exePath).replace(PROTO_PATH_PLACEHOLDER, this.protoPath).replace(DESC_PATH_PLACEHOLDER, this.descriptorSetOutPath).replace(PROTO_FOLDER_PLACEHOLDER, this.protoFolderPath);
        logger.debug("Protobuf compilation command : ", (Object)finalCommand);
        return finalCommand;
    }

    private void downloadProtocexe() throws IOException {
        String protocFilename = ProtocCommandBuilder.getProtocFilename();
        String protocDirPath = CmdUtils.getProtocDirPath();
        File protocExeFile = new File(protocDirPath, protocFilename);
        String protocExePath = protocExeFile.getAbsolutePath();
        if (!protocExeFile.exists()) {
            logger.info("Downloading protoc executor file - " + protocFilename);
            String protocDownloadurl = PROTOC_PLUGIN_EXE_URL_SUFFIX + this.protocVersion + "/protoc-" + this.protocVersion + "-" + OSDetector.getDetectedClassifier() + PROTOC_PLUGIN_EXE_PREFIX;
            File tempDownloadFile = new File(protocDirPath, "protoc-" + OSDetector.getDetectedClassifier() + ".exe.download");
            try {
                ProtocCommandBuilder.downloadFile(new URL(protocDownloadurl), tempDownloadFile);
                Files.move(tempDownloadFile.toPath(), protocExeFile.toPath(), new CopyOption[0]);
                ProtocCommandBuilder.grantPermission(protocExeFile);
            }
            catch (CLIInternalException e) {
                Files.deleteIfExists(Paths.get(protocExePath, new String[0]));
                throw e;
            }
            logger.debug("Download process is successfully completed. Executor file path - " + protocExeFile.getPath());
        } else {
            ProtocCommandBuilder.grantPermission(protocExeFile);
            logger.info("Continue with existing protoc executor file at " + protocExeFile.getPath());
        }
    }

    public static void downloadFile(URL url, File file) {
        try (InputStream in = url.openStream();
             FileOutputStream fos = new FileOutputStream(file);){
            int length;
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((length = in.read(buffer)) > -1) {
                fos.write(buffer, 0, length);
                if (++count != 1000) continue;
                OUT.print('.');
                count = 0;
            }
        }
        catch (IOException e) {
            String msg = "Error while downloading the file: " + file.getName() + ". " + e.getMessage();
            throw new CLIInternalException(msg);
        }
    }

    public static void grantPermission(File file) {
        boolean isExecutable = file.setExecutable(true);
        boolean isReadable = file.setReadable(true);
        boolean isWritable = file.setWritable(true);
        if (!(isExecutable && isReadable && isWritable)) {
            String msg = "Error while providing execute permission to protoc executor file: " + file.getName();
            throw new CLIInternalException(msg);
        }
        logger.debug("Successfully granted permission for protoc exe file");
    }

    private static String getProtocExePath() {
        return CmdUtils.getProtocDirPath() + File.separator + ProtocCommandBuilder.getProtocFilename();
    }

    private static String getProtocFilename() {
        return "protoc-" + OSDetector.getDetectedClassifier() + PROTOC_PLUGIN_EXE_PREFIX;
    }
}

