/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cipher.AESCipherTool;
import org.wso2.apimgt.gateway.cli.cipher.AESCipherToolException;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerationContext;
import org.wso2.apimgt.gateway.cli.config.TOMLConfigParser;
import org.wso2.apimgt.gateway.cli.constants.CliConstants;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.exception.CliLauncherException;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;
import org.wso2.apimgt.gateway.cli.hashing.HashUtils;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.ContainerConfig;
import org.wso2.apimgt.gateway.cli.model.rest.APICorsConfigurationDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.utils.CodegenUtils;
import org.wso2.apimgt.gateway.cli.utils.OpenAPICodegenUtils;

public final class CmdUtils {
    private static final Logger logger = LoggerFactory.getLogger(CmdUtils.class);
    private static Config config;
    private static ContainerConfig containerConfig;
    private static CodeGenerationContext codeGenerationContext;
    private static boolean verboseLogsEnabled;
    private static final String openAPISpec2 = "2";
    private static final PrintStream OUT;
    private static final PrintStream ERR;
    private static String consoleMessages;
    private static String callHomeMessage;

    private CmdUtils() {
    }

    public static Config getConfig() {
        return config;
    }

    public static void setConfig(Config configFromFile) {
        config = configFromFile;
    }

    public static CodeGenerationContext getCodeGenerationContext() {
        return codeGenerationContext;
    }

    public static void setCodeGenerationContext(CodeGenerationContext codeGenerationContext) {
        CmdUtils.codeGenerationContext = codeGenerationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String path, boolean inResource) throws IOException {
        InputStream is;
        if (inResource) {
            path = CmdUtils.getUnixPath(path);
            is = ClassLoader.getSystemResourceAsStream(path);
        } else {
            is = new FileInputStream(new File(path));
        }
        InputStreamReader inputStreamREader = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            inputStreamREader = new InputStreamReader(is, StandardCharsets.UTF_8);
            br = new BufferedReader(inputStreamREader);
            String content = br.readLine();
            if (content == null) {
                String string = sb.toString();
                return string;
            }
            sb.append(content);
            while ((content = br.readLine()) != null) {
                sb.append('\n').append(content);
            }
        }
        finally {
            if (inputStreamREader != null) {
                try {
                    inputStreamREader.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public static CliLauncherException createUsageException(String errorMsg) {
        CliLauncherException launcherException = new CliLauncherException();
        launcherException.addMessage("micro-gw: " + errorMsg);
        launcherException.addMessage("Run 'micro-gw help <command>' for usage.");
        return launcherException;
    }

    public static String encrypt(String value, String secret) {
        try {
            AESCipherTool cipherTool = new AESCipherTool(secret);
            return cipherTool.encrypt(value);
        }
        catch (AESCipherToolException e) {
            throw CmdUtils.createUsageException("failed to encrypt client secret");
        }
    }

    public static String decrypt(String value, String secret) {
        try {
            AESCipherTool cipherTool = new AESCipherTool(secret);
            return cipherTool.decrypt(value);
        }
        catch (AESCipherToolException e) {
            throw CmdUtils.createUsageException("failed to decrypt client secret");
        }
    }

    public static String getUserDir() {
        String currentDirProp = System.getProperty("current.dir");
        if (currentDirProp != null) {
            return currentDirProp;
        }
        return System.getProperty("user.dir");
    }

    public static String getCLIHome() {
        return System.getProperty("cli.home");
    }

    public static String getCacertsLocation() {
        return System.getProperty("cacerts.location");
    }

    public static String getCacertsPassword() {
        String cacertsPassword = "";
        String password = System.getenv("CACERTS_PASS");
        cacertsPassword = password != null ? password : "changeit";
        return cacertsPassword;
    }

    public static String getCLILibPath() {
        return CmdUtils.getCLIHome() + File.separator + "lib";
    }

    public static String getResourceFolderLocation() {
        return System.getProperty("cli.home") + File.separator + "resources";
    }

    public static String getResourcesGrpcDirLocation() {
        return CmdUtils.getResourceFolderLocation() + File.separator + "grpc";
    }

    public static String getLoggingPropertiesFileLocation() {
        return System.getProperty("cli.home") + File.separator + "conf" + File.separator + "logging.properties";
    }

    public static String getDefinitionsLocation() {
        return CmdUtils.getResourceFolderLocation() + File.separator + "definitions";
    }

    public static String getFiltersFolderLocation() {
        return CmdUtils.getResourceFolderLocation() + File.separator + "filters";
    }

    private static String getProjectTempFolderLocation(String projectName) {
        return CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "temp";
    }

    private static void setApiDefinition(String projectName, String apiDefinition, String headers, String values, boolean insecure) throws IOException {
        String filePath;
        String apiDefinitionsDir = CmdUtils.getProjectAPIFilesDirectoryPath(projectName);
        if (CmdUtils.isURL(apiDefinition)) {
            ArrayList<String> headersList = new ArrayList<String>();
            ArrayList<String> valuesList = new ArrayList<String>();
            if (!StringUtils.isBlank((CharSequence)headers) && !StringUtils.isBlank((CharSequence)values)) {
                headersList = new ArrayList<String>(Arrays.asList(headers.split(",")));
                valuesList = new ArrayList<String>(Arrays.asList(values.split(",")));
                if (headersList.size() > 0 && headersList.size() != valuesList.size()) {
                    throw new CLIRuntimeException("Provided number of header and number of values is different");
                }
                logger.debug("Request headers : " + headers + " values : " + values + "are provided.");
            }
            filePath = CmdUtils.downloadFile(apiDefinition, apiDefinitionsDir, headersList, valuesList, insecure);
        } else {
            File apiDefinitionFile = new File(apiDefinition);
            if (!apiDefinitionFile.exists()) {
                throw CmdUtils.createUsageException("Error while getting the open API definition. Probably the file path '" + apiDefinition + "' is invalid.");
            }
            filePath = apiDefinitionsDir + File.separator + Paths.get(apiDefinition, new String[0]).getFileName();
            Files.copy(Paths.get(apiDefinition, new String[0]), Paths.get(filePath, new String[0]), new CopyOption[0]);
            logger.debug("Api definition is successfully copied to :" + filePath);
        }
        if (!filePath.endsWith(".json") && !filePath.endsWith(".yaml")) {
            logger.debug("API definition file name has no .json or .yaml extension");
            if (CmdUtils.addExtension(filePath)) {
                logger.debug("API definition renamed.");
            }
        }
    }

    private static boolean isURL(String url) {
        Pattern pattern = Pattern.compile("^(http|https)://(.)+", 2);
        Matcher matcher = pattern.matcher(url);
        return matcher.matches();
    }

    private static boolean isJson(String content) {
        try {
            new JsonParser().parse(content);
        }
        catch (JsonParseException e) {
            return false;
        }
        return true;
    }

    private static boolean isYaml(String content) {
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            yamlReader.readValue(content, Object.class);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static boolean addExtension(String filePath) {
        File file = new File(filePath);
        try {
            String content = CmdUtils.readFileAsString(filePath, false);
            if (CmdUtils.isJson(content)) {
                File newFile = new File(filePath + ".json");
                logger.debug("File identified as a .json file.");
                return file.renameTo(newFile);
            }
            if (CmdUtils.isYaml(content)) {
                File newFile = new File(filePath + ".yaml");
                logger.debug("File identified as a .yaml file.");
                return file.renameTo(newFile);
            }
            logger.debug("Failed to identify format");
            return false;
        }
        catch (IOException e) {
            throw new CLIRuntimeException("Error while reading file: " + filePath);
        }
    }

    public static void createProjectStructure(String projectName, String apiDefinition, String headers, String values, boolean insecure) throws IOException {
        File projectDir = CmdUtils.createDirectory(CmdUtils.getUserDir() + File.separator + projectName, false);
        String interceptorsPath = projectDir + File.separator + "interceptors";
        CmdUtils.createDirectory(interceptorsPath, false);
        CmdUtils.createFile(interceptorsPath, ".keep", true);
        String externalLibPath = projectDir + File.separator + "lib";
        CmdUtils.createDirectory(externalLibPath, false);
        CmdUtils.createFile(externalLibPath, ".keep", true);
        String extensionsPath = projectDir + File.separator + "extensions";
        CmdUtils.createDirectory(extensionsPath, false);
        String confDirPath = projectDir + File.separator + "conf";
        CmdUtils.createDirectory(confDirPath, false);
        String definitionsPath = projectDir + File.separator + "api_definitions";
        CmdUtils.createDirectory(definitionsPath, false);
        CmdUtils.createFile(definitionsPath, ".keep", true);
        if (!StringUtils.isEmpty((CharSequence)apiDefinition)) {
            CmdUtils.setApiDefinition(projectName, apiDefinition, headers, values, insecure);
        }
        String grpcDefinitionsPath = projectDir + File.separator + "grpc_definitions";
        CmdUtils.createDirectory(grpcDefinitionsPath, false);
        CmdUtils.createFile(projectDir.getPath(), "policies.yaml", true);
        String policyResPath = CmdUtils.getDefinitionsLocation() + File.separator + "policies.yaml";
        File policyResFile = new File(policyResPath);
        File policesFile = new File(projectDir + File.separator + "policies.yaml");
        String extensionResPath = CmdUtils.getFiltersFolderLocation() + File.separator + "extension_filter.bal";
        File extensionResFile = new File(extensionResPath);
        File extensionFile = new File(extensionsPath + File.separator + "extension_filter.bal");
        String tokenRevocationResPath = CmdUtils.getFiltersFolderLocation() + File.separator + "token_revocation_extension.bal";
        File tokenRevocationResFile = new File(tokenRevocationResPath);
        File tokenRevocationFile = new File(extensionsPath + File.separator + "token_revocation_extension.bal");
        String startUpExtensionResourcePath = CmdUtils.getFiltersFolderLocation() + File.separator + "startup_extension.bal";
        File startUpExtensionResFile = new File(startUpExtensionResourcePath);
        File startUpExtensionFile = new File(extensionsPath + File.separator + "startup_extension.bal");
        if (!Files.exists(extensionResFile.toPath(), new LinkOption[0])) {
            throw new CLIRuntimeException("Extension filter not found in CLI_HOME");
        }
        FileUtils.copyFile(extensionResFile, extensionFile);
        if (!Files.exists(tokenRevocationResFile.toPath(), new LinkOption[0])) {
            throw new CLIRuntimeException("Token revocation extension not Found in CLI_HOME");
        }
        FileUtils.copyFile(tokenRevocationResFile, tokenRevocationFile);
        if (!Files.exists(startUpExtensionResFile.toPath(), new LinkOption[0])) {
            throw new CLIRuntimeException("Start up extension not Found in CLI_HOME");
        }
        FileUtils.copyFile(startUpExtensionResFile, startUpExtensionFile);
        if (!Files.exists(policyResFile.toPath(), new LinkOption[0])) {
            throw new CLIRuntimeException("Policy definition not found in CLI_HOME");
        }
        FileUtils.copyFile(policyResFile, policesFile);
    }

    public static void saveSwaggerDefinition(String projectName, String apiDefinition, String apiId, String extension) {
        if (apiDefinition.isEmpty()) {
            throw new CLIInternalException("No swagger definition is provided to generate API");
        }
        try {
            Path genPath = Paths.get(CmdUtils.getProjectGenDirectoryPath(projectName), new String[0]);
            Path apiDefPath = Paths.get(CmdUtils.getProjectGenAPIDefinitionPath(projectName), new String[0]);
            if (Files.notExists(genPath, new LinkOption[0])) {
                Files.createDirectory(genPath, new FileAttribute[0]);
                Files.createDirectory(apiDefPath, new FileAttribute[0]);
            }
            CmdUtils.writeContent(apiDefinition, new File(CmdUtils.getProjectGenSwaggerPath(projectName, apiId, extension)));
        }
        catch (IOException e) {
            throw new CLIInternalException("Error while copying the swagger to the project directory");
        }
    }

    private static void saveSwaggerDefinitionForSingleAPI(String projectName, ExtendedAPI api, boolean isExpand) {
        String swaggerString = OpenAPICodegenUtils.generateSwaggerString(api, isExpand);
        String apiId = HashUtils.generateAPIId(api.getName(), api.getVersion());
        String extension = openAPISpec2.equals(OpenAPICodegenUtils.findSwaggerVersion(api.getApiDefinition(), false)) ? "swagger.json" : "openAPI.yaml";
        CmdUtils.saveSwaggerDefinition(projectName, swaggerString, apiId, extension);
    }

    public static void saveSwaggerDefinitionForMultipleAPIs(String projectName, List<ExtendedAPI> apis, boolean isExpand) {
        for (ExtendedAPI api : apis) {
            CmdUtils.saveSwaggerDefinitionForSingleAPI(projectName, api, isExpand);
            OUT.println("ID for API with name " + api.getName() + " : " + HashUtils.generateAPIId(api.getName(), api.getVersion()));
        }
    }

    public static String loadStoredResourceHashes(String projectName) throws IOException {
        String resourceHashFileLocation = CmdUtils.getResourceHashHolderFileLocation(projectName);
        String content = null;
        if (new File(resourceHashFileLocation).exists()) {
            content = CmdUtils.readFileAsString(resourceHashFileLocation, false);
        }
        return content;
    }

    public static void storeResourceHashesFileContent(String content, String projectName) throws IOException {
        String tempDirPath = CmdUtils.getProjectTempFolderLocation(projectName);
        CmdUtils.createDirectory(tempDirPath, false);
        String resourceHashesFileLocation = CmdUtils.getResourceHashHolderFileLocation(projectName);
        File pathFile = new File(resourceHashesFileLocation);
        if (!pathFile.exists()) {
            boolean created = pathFile.createNewFile();
            if (created) {
                logger.trace("Hashed file: {} created. ", (Object)resourceHashesFileLocation);
            } else {
                logger.error("Failed to create hash file: {} ", (Object)resourceHashesFileLocation);
                throw new CLIInternalException("Error occurred while setting up the workspace structure");
            }
        }
        CmdUtils.writeContent(content, pathFile);
    }

    private static String getResourceHashHolderFileLocation(String projectName) {
        return CmdUtils.getProjectTempFolderLocation(projectName) + File.separator + "hashes.json";
    }

    public static String getMainConfigLocation() {
        return CmdUtils.getCLIHome() + File.separator + "conf" + File.separator + "toolkit-config.toml";
    }

    private static String getProjectConfigDirPath(String projectName) {
        return CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "conf";
    }

    public static String getDeploymentConfigLocation(String projectName) {
        return CmdUtils.getProjectConfigDirPath(projectName) + File.separator + "deployment-config.toml";
    }

    public static String getProjectDirectoryPath(String projectName) {
        return CmdUtils.getUserDir() + File.separator + projectName;
    }

    public static String getProjectGenDirectoryPath(String projectName) {
        return CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "gen";
    }

    public static String getProjectTargetGenDirectoryPath(String projectName) {
        return CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "target" + File.separator + "gen";
    }

    public static String getProjectTargetGenGrpcSrcDirectory(String projectName) {
        return CmdUtils.getProjectTargetGenDirectoryPath(projectName) + File.separator + "gRPCSrc";
    }

    public static String getProjectTargetGenGrpcSrcOpenAPIsDirectory(String projectName) {
        return CmdUtils.getProjectTargetGenGrpcSrcDirectory(projectName) + File.separator + "openAPIs";
    }

    public static String getProjectTargetGenGrpcSrcDescDirectory(String projectName) {
        return CmdUtils.getProjectTargetGenGrpcSrcDirectory(projectName) + File.separator + "desc";
    }

    public static String getProjectTargetModulePath(String projectName) {
        return CmdUtils.getProjectTargetGenDirectoryPath(projectName) + File.separator + "src" + File.separator + projectName;
    }

    public static String getProjectGenSrcDirectoryPath(String projectName) {
        return CmdUtils.getProjectTargetGenDirectoryPath(projectName) + File.separator + "src";
    }

    public static String getProjectExtensionsDirectoryPath(String projectName) {
        return CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "extensions";
    }

    public static String getProjectInterceptorsPath(String projectName) {
        return CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "interceptors";
    }

    public static String getProjectTargetInterceptorsPath(String projectName) {
        return CmdUtils.getProjectTargetModulePath(projectName) + File.separator + "interceptors";
    }

    public static String getProjectGenSwaggerPath(String projectName, String apiId, String extensionType) {
        return CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "gen" + File.separator + "api_definitions" + File.separator + apiId + extensionType;
    }

    public static String getProjectGenSwaggerPath(String projectName, String apiId) {
        return CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "gen" + File.separator + "api_definitions" + File.separator + apiId + "swagger.json";
    }

    public static String getProjectGenAPIDefinitionPath(String projectName) {
        return CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "gen" + File.separator + "api_definitions";
    }

    public static String getAPIDefinitionPath(String projectName) {
        return CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "api_definitions";
    }

    public static String getGrpcDefinitionsDirPath(String projectName) {
        return CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "grpc_definitions";
    }

    public static String getProjectGrpcDirectoryPath() {
        return CmdUtils.getUserDir() + File.separator + "grpc_service" + File.separator + "client";
    }

    public static String getProjectGrpcSoloDirectoryPath() {
        return CmdUtils.getUserDir() + File.separator + "grpc_service";
    }

    public static void copyFolder(String source, String destination) throws IOException {
        File sourceFolder = new File(source);
        File destinationFolder = new File(destination);
        CmdUtils.copyFolder(sourceFolder, destinationFolder);
    }

    public static void copyAndReplaceFolder(String source, String destination) throws IOException {
        File sourceFolder = new File(source);
        File destinationFolder = new File(destination);
        if (destinationFolder.exists()) {
            FileUtils.deleteDirectory(destinationFolder);
        }
        CmdUtils.copyFolder(sourceFolder, destinationFolder);
    }

    public static void copyFilesToSources(String sourcePath, String destinationPath) throws IOException {
        Files.copy(Paths.get(sourcePath, new String[0]), Paths.get(destinationPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    private static boolean copyFolder(File sourceFolder, File destinationFolder) throws IOException {
        if (sourceFolder == null || destinationFolder == null || !sourceFolder.exists()) {
            return false;
        }
        if (sourceFolder.isDirectory()) {
            String[] files;
            if (!destinationFolder.exists()) {
                boolean created = destinationFolder.mkdir();
                if (created) {
                    logger.trace("Directory: {} created. ", (Object)destinationFolder.getAbsolutePath());
                } else {
                    logger.error("Failed to create directory: {} ", (Object)destinationFolder.getAbsolutePath());
                    throw new CLIInternalException("Error occurred while setting up the workspace structure");
                }
            }
            if ((files = sourceFolder.list()) != null) {
                for (String file : files) {
                    File srcFile = new File(sourceFolder, file);
                    File destFile = new File(destinationFolder, file);
                    CmdUtils.copyFolder(srcFile, destFile);
                }
            }
        } else {
            Files.copy(sourceFolder.toPath(), destinationFolder.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            boolean success = destinationFolder.setWritable(true);
            if (!success) {
                logger.debug("Setting write permission failed for {}", (Object)destinationFolder.getAbsolutePath());
            }
        }
        return true;
    }

    public static File createDirectory(String path, boolean overwrite) throws IOException {
        File dir = new File(path);
        if (overwrite && dir.exists() && dir.isDirectory()) {
            FileUtils.deleteDirectory(dir);
        }
        if (!dir.exists() && !dir.isDirectory()) {
            boolean created = dir.mkdir();
            if (created) {
                logger.trace("Directory: {} created. ", (Object)path);
            } else {
                throw new CLIInternalException("Failed to create directory: " + path);
            }
        }
        return dir;
    }

    public static File createFile(String path, String fileName, boolean overwrite) throws IOException {
        boolean isDeleted;
        String filePath = path + File.separator + fileName;
        File file = new File(filePath);
        if (overwrite && file.exists() && file.isFile() && !(isDeleted = file.delete())) {
            throw new CLIInternalException("Failed to overwrite file: " + filePath);
        }
        if (!file.exists() && !file.isFile()) {
            boolean isCreated = file.createNewFile();
            if (isCreated) {
                logger.trace("File: {} created.", (Object)filePath);
            } else {
                throw new CLIInternalException("Failed to create file: " + filePath);
            }
        }
        return file;
    }

    public static void writeContent(String content, File file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            writer.write(content);
            ((Writer)writer).flush();
        }
    }

    public static void createDeploymentConfig(String projectName, String deploymentConfPath) throws IOException {
        String depConfig = CmdUtils.getProjectConfigDirPath(projectName) + File.separator + "deployment-config.toml";
        File file = new File(depConfig);
        if (deploymentConfPath == null) {
            if (!file.exists()) {
                boolean created = file.createNewFile();
                if (!created) {
                    throw new CLIInternalException("Failed to create the deployment configuration file: " + depConfig);
                }
                logger.debug("Deployment configuration file: {} created.", (Object)depConfig);
                String defaultConfig = CmdUtils.readFileAsString("default-deployment-config.toml", true);
                CmdUtils.writeContent(defaultConfig, file);
            }
        } else {
            File inputDepConfFile = new File(deploymentConfPath);
            if (inputDepConfFile.exists()) {
                String inputConfigContent = CmdUtils.readFileAsString(deploymentConfPath, false);
                try {
                    TOMLConfigParser.parse(deploymentConfPath, ContainerConfig.class);
                }
                catch (IllegalStateException | ConfigParserException e) {
                    throw new CLIRuntimeException("Error while reading deployment configuration file: " + deploymentConfPath + ". The content is invalid.", e);
                }
                CmdUtils.writeContent(inputConfigContent, file);
            } else {
                throw new CLIRuntimeException("Error while reading deployment configuration file. Probably the file path '" + deploymentConfPath + "' is invalid.");
            }
        }
    }

    private static String downloadFile(String source, String destination, ArrayList<String> headers, ArrayList<String> values, boolean insecure) throws IOException {
        String saveFilePath;
        block15: {
            if (insecure) {
                CmdUtils.useInsecureSSL();
            }
            HttpURLConnection urlConn = null;
            FileOutputStream outputStream = null;
            try {
                int responseCode;
                URL url = new URL(source);
                urlConn = (HttpURLConnection)url.openConnection();
                urlConn.setRequestMethod("GET");
                if (headers.size() > 0) {
                    for (int i = 0; i < headers.size(); ++i) {
                        urlConn.setRequestProperty(headers.get(i), values.get(i));
                    }
                }
                if ((responseCode = urlConn.getResponseCode()) == 200) {
                    int bytesRead;
                    String fileName = "";
                    String disposition = urlConn.getHeaderField("Content-Disposition");
                    if (disposition != null) {
                        int index = disposition.indexOf("filename=");
                        if (index > 0) {
                            fileName = disposition.substring(index + 10, disposition.length() - 1);
                        }
                    } else {
                        fileName = source.substring(source.lastIndexOf("/") + 1);
                    }
                    InputStream inputStream = urlConn.getInputStream();
                    saveFilePath = destination + File.separator + fileName;
                    outputStream = new FileOutputStream(saveFilePath);
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                    inputStream.close();
                    break block15;
                }
                throw new CLIInternalException("Error occurred while downloading file. Status code: " + responseCode);
            }
            catch (IOException e) {
                throw new CLIRuntimeException("Error while downloading file from " + source + ": " + e.getMessage());
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (urlConn != null) {
                    urlConn.disconnect();
                }
            }
        }
        return saveFilePath;
    }

    public static ContainerConfig getContainerConfig() {
        return containerConfig;
    }

    public static void setContainerConfig(ContainerConfig containerConfig) {
        CmdUtils.overrideContainerConfigs(containerConfig);
        CmdUtils.containerConfig = containerConfig;
    }

    private static void overrideContainerConfigs(ContainerConfig containerConfig) {
        if (containerConfig != null && containerConfig.getKubernetes() != null && containerConfig.getKubernetes().getSecureKubernetesIngress() != null) {
            containerConfig.getKubernetes().getSecureKubernetesIngress().setKeyStorePassword(CodegenUtils.resolveValue(containerConfig.getKubernetes().getSecureKubernetesIngress().getKeyStorePassword()));
        }
    }

    public static void saveConfig(Config config, String configPath) {
        try {
            TOMLConfigParser.write(configPath, config);
        }
        catch (ConfigParserException e) {
            ERR.println("Error occurred while parsing configuration, when persisting.");
        }
    }

    public static APICorsConfigurationDTO getDefaultCorsConfig() {
        APICorsConfigurationDTO corsConfigurationDTO = new APICorsConfigurationDTO();
        corsConfigurationDTO.setCorsConfigurationEnabled(true);
        corsConfigurationDTO.setAccessControlAllowOrigins(CliConstants.ACCESS_CONTROL_ALLOW_ORIGINS);
        corsConfigurationDTO.setAccessControlAllowMethods(CliConstants.ACCESS_CONTROL_ALLOW_METHODS);
        corsConfigurationDTO.setAccessControlAllowHeaders(CliConstants.ACCESS_CONTROL_ALLOW_HEADERS);
        corsConfigurationDTO.setAccessControlAllowCredentials(false);
        corsConfigurationDTO.setAccessControlExposeHeaders(CliConstants.ACCESS_CONTROL_EXPOSE_HEADERS);
        return corsConfigurationDTO;
    }

    public static String getUnixPath(String path) {
        return path.replace(File.separator, "/");
    }

    public static void deleteProject(String projectPath) {
        File file = new File(projectPath);
        try {
            FileUtils.deleteDirectory(file);
        }
        catch (IOException e) {
            logger.error("Failed to delete project : {} ", (Object)projectPath, (Object)e);
        }
    }

    public static String promptForTextInput(PrintStream outStream, String msg) {
        outStream.println(msg);
        return System.console().readLine();
    }

    public static String getProjectAPIFilesDirectoryPath(String projectName) {
        return CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "api_definitions";
    }

    public static String getProjectSwaggerFilePath(String projectName, String apiId) {
        return CmdUtils.getProjectAPIFilesDirectoryPath(projectName) + File.separator + apiId + File.separator + "swagger.json";
    }

    public static String getProtocDirPath() {
        return CmdUtils.getResourceFolderLocation() + File.separator + "grpc";
    }

    public static String getProtoDescriptorPath(String projectName, String protoFileName) {
        String fileName = protoFileName.substring(0, protoFileName.length() - 6);
        return CmdUtils.getProjectTargetGenGrpcSrcDescDirectory(projectName) + File.separator + fileName + ".desc";
    }

    public static void printVerbose(String msg) {
        if (verboseLogsEnabled) {
            OUT.println("micro-gw: [verbose] " + msg);
        }
    }

    private static Boolean setVerboseEnabled() {
        String value = System.getProperty("VERBOSE_ENABLED");
        return "T".equals(value) || value.equalsIgnoreCase("true");
    }

    public static void useInsecureSSL() {
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            String message = "Error while setting in secure ssl options";
            logger.error(message, (Throwable)e);
        }
    }

    public static String getMicroGWConfResourceLocation() {
        return CmdUtils.getCLIHome() + File.separator + "resources" + File.separator + "conf";
    }

    public static List<String> getExternalJarDependencies(String projectName) {
        ArrayList<String> jars = new ArrayList<String>();
        String extJarDir = CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "lib";
        File[] jarFiles = new File(extJarDir).listFiles();
        if (jarFiles != null) {
            for (File file : jarFiles) {
                if (!file.getName().endsWith(".jar")) continue;
                jars.add(file.getAbsolutePath());
            }
        }
        return jars;
    }

    public static String format(String message) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return message;
        }
        return "\u001b[0;1m" + message + "\u001b[0m";
    }

    public static void appendMessagesToConsole(String msg) {
        consoleMessages = consoleMessages + msg;
    }

    public static void printMessagesToConsole() {
        if (!"".equals(consoleMessages)) {
            OUT.println(consoleMessages);
        }
    }

    public static void setCallHomeMessage(String message) {
        callHomeMessage = message;
    }

    public static void printCallHomeMessage() {
        if (!"".equals(callHomeMessage)) {
            OUT.println(callHomeMessage);
        }
    }

    static {
        verboseLogsEnabled = CmdUtils.setVerboseEnabled();
        OUT = System.out;
        ERR = System.err;
        consoleMessages = "";
        callHomeMessage = "";
    }
}

