/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.wso2.apimgt.gateway.cli.exception.CLICompileTimeException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.MgwEndpointConfigDTO;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.MgwEndpointDTO;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.MgwEndpointListDTO;
import org.wso2.apimgt.gateway.cli.model.rest.APIEndpointSecurityDTO;
import org.wso2.apimgt.gateway.cli.model.rest.EndpointUrlTypeEnum;
import org.wso2.apimgt.gateway.cli.model.route.EndpointListRouteDTO;
import org.wso2.apimgt.gateway.cli.model.route.EndpointType;
import org.wso2.apimgt.gateway.cli.model.route.RouteEndpointConfig;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;

public final class RouteUtils {
    private static final ObjectMapper OBJECT_MAPPER_JSON = new ObjectMapper();

    public static RouteEndpointConfig parseEndpointConfig(String epConfigJson, APIEndpointSecurityDTO epSecurity) throws MalformedURLException, CLICompileTimeException {
        JsonNode prodEndpointNode;
        JsonNode rootNode;
        RouteEndpointConfig endpointConfig = new RouteEndpointConfig();
        EndpointListRouteDTO prodEndpointConfig = new EndpointListRouteDTO();
        EndpointListRouteDTO sandEndpointConfig = new EndpointListRouteDTO();
        prodEndpointConfig.setSecurityConfig(epSecurity);
        sandEndpointConfig.setSecurityConfig(epSecurity);
        try {
            rootNode = OBJECT_MAPPER_JSON.readTree(epConfigJson);
        }
        catch (IOException e) {
            throw new CLIRuntimeException("Error while parsing the endpointConfig JSON string");
        }
        JsonNode endpointTypeNode = rootNode.get("endpoint_type");
        String endpointType = endpointTypeNode.asText();
        if ("http".equalsIgnoreCase(endpointType) || "failover".equalsIgnoreCase(endpointType)) {
            JsonNode sandEndpointNode;
            prodEndpointNode = rootNode.get("production_endpoints");
            if (prodEndpointNode != null) {
                prodEndpointConfig.addEndpoint(prodEndpointNode.get("url").asText());
            }
            if ((sandEndpointNode = rootNode.get("sandbox_endpoints")) != null) {
                sandEndpointConfig.addEndpoint(sandEndpointNode.get("url").asText());
            }
            if ("failover".equalsIgnoreCase(endpointType)) {
                JsonNode sandFailoverEndpointNode;
                prodEndpointConfig.setType(EndpointType.failover);
                sandEndpointConfig.setType(EndpointType.failover);
                JsonNode prodFailoverEndpointNode = rootNode.withArray("production_failovers");
                if (prodFailoverEndpointNode != null) {
                    for (JsonNode node : prodFailoverEndpointNode) {
                        prodEndpointConfig.addEndpoint(node.get("url").asText());
                    }
                }
                if ((sandFailoverEndpointNode = rootNode.withArray("sandbox_failovers")) != null) {
                    for (JsonNode node : sandFailoverEndpointNode) {
                        sandEndpointConfig.addEndpoint(node.get("url").asText());
                    }
                }
            } else {
                prodEndpointConfig.setType(EndpointType.http);
                sandEndpointConfig.setType(EndpointType.http);
            }
        } else if ("load_balance".equalsIgnoreCase(endpointType)) {
            JsonNode prodEndpoints = rootNode.withArray("production_endpoints");
            JsonNode sandboxEndpoints = rootNode.withArray("sandbox_endpoints");
            prodEndpointConfig.setType(EndpointType.load_balance);
            sandEndpointConfig.setType(EndpointType.load_balance);
            if (prodEndpoints != null) {
                for (JsonNode node : prodEndpoints) {
                    prodEndpointConfig.addEndpoint(node.get("url").asText());
                }
            }
            if (sandboxEndpoints != null) {
                for (JsonNode node : sandboxEndpoints) {
                    sandEndpointConfig.addEndpoint(node.get("url").asText());
                }
            }
        } else if ("address".equalsIgnoreCase(endpointType)) {
            prodEndpointNode = rootNode.get("production_endpoints");
            JsonNode sandEndpointNode = rootNode.get("sandbox_endpoints");
            prodEndpointConfig.setType(EndpointType.address);
            sandEndpointConfig.setType(EndpointType.address);
            if (prodEndpointNode != null) {
                prodEndpointConfig.addEndpoint(prodEndpointNode.get("url").asText());
            }
            if (sandEndpointNode != null) {
                sandEndpointConfig.addEndpoint(sandEndpointNode.get("url").asText());
            }
        }
        try {
            prodEndpointConfig.validateEndpoints();
        }
        catch (CLICompileTimeException e) {
            throw new CLICompileTimeException("The provided production endpoint is invalid.\n\t-" + e.getTerminalMsg(), e);
        }
        try {
            sandEndpointConfig.validateEndpoints();
        }
        catch (CLICompileTimeException e) {
            throw new CLICompileTimeException("The provided production endpoint is invalid.\n\t-" + e.getTerminalMsg(), e);
        }
        if (prodEndpointConfig.getEndpoints() != null && prodEndpointConfig.getEndpoints().size() > 0) {
            endpointConfig.setProdEndpointList(prodEndpointConfig);
        }
        if (sandEndpointConfig.getEndpoints() != null && sandEndpointConfig.getEndpoints().size() > 0) {
            endpointConfig.setSandboxEndpointList(sandEndpointConfig);
        }
        return endpointConfig;
    }

    static MgwEndpointConfigDTO convertToMgwServiceMap(EndpointListRouteDTO prodEpListDTO, EndpointListRouteDTO sandEpListDTO) {
        MgwEndpointConfigDTO endpointConfigDTO = new MgwEndpointConfigDTO();
        MgwEndpointListDTO prod = null;
        MgwEndpointListDTO sandbox = null;
        if (prodEpListDTO != null) {
            prod = new MgwEndpointListDTO();
            prod.setEndpointUrlType(EndpointUrlTypeEnum.PROD);
            RouteUtils.setEndpointType(prodEpListDTO, prod);
            RouteUtils.setEndpointUrls(prodEpListDTO, prod);
            prod.setSecurityConfig(prodEpListDTO.getSecurityConfig());
            prod.setName(prodEpListDTO.getName());
            prod.setAdvanceEndpointConfig(prodEpListDTO.getAdvanceEndpointConfig());
        }
        if (sandEpListDTO != null) {
            sandbox = new MgwEndpointListDTO();
            sandbox.setEndpointUrlType(EndpointUrlTypeEnum.SAND);
            RouteUtils.setEndpointType(sandEpListDTO, sandbox);
            RouteUtils.setEndpointUrls(sandEpListDTO, sandbox);
            sandbox.setSecurityConfig(sandEpListDTO.getSecurityConfig());
            sandbox.setName(sandEpListDTO.getName());
            sandbox.setAdvanceEndpointConfig(sandEpListDTO.getAdvanceEndpointConfig());
        }
        endpointConfigDTO.setProdEndpointList(prod);
        endpointConfigDTO.setSandboxEndpointList(sandbox);
        return endpointConfigDTO;
    }

    private static void setEndpointType(EndpointListRouteDTO sourceObject, MgwEndpointListDTO destObject) {
        int endpointListSize = sourceObject.getEndpoints().size();
        EndpointType endpointType = sourceObject.getType();
        if (endpointListSize > 1) {
            if (endpointType == null) {
                destObject.setType(EndpointType.load_balance);
                return;
            }
            switch (endpointType) {
                case http: {
                    CmdUtils.printVerbose("'" + (Object)((Object)EndpointType.http) + "' is not effective with many urls. Only the first url will be used.");
                    destObject.setType(endpointType);
                    break;
                }
                case failover: {
                    destObject.setType(endpointType);
                    break;
                }
                default: {
                    destObject.setType(EndpointType.load_balance);
                    break;
                }
            }
        } else {
            if (endpointType == null) {
                destObject.setType(EndpointType.http);
                return;
            }
            destObject.setType(EndpointType.http);
            if (!endpointType.equals((Object)EndpointType.http)) {
                CmdUtils.printVerbose((Object)((Object)endpointType) + " is changed to " + (Object)((Object)EndpointType.http) + " as only one endpoint is available.");
            }
        }
    }

    private static void setEndpointUrls(EndpointListRouteDTO sourceObject, MgwEndpointListDTO destObject) {
        ArrayList<MgwEndpointDTO> mgwEpList = new ArrayList<MgwEndpointDTO>();
        for (String ep : sourceObject.getEndpoints()) {
            mgwEpList.add(new MgwEndpointDTO(ep));
        }
        for (MgwEndpointDTO mgwEndpointDTO : mgwEpList) {
            if (!mgwEndpointDTO.isEtcdEnabled()) continue;
            destObject.setEndpointListEtcdEnabled(true);
            break;
        }
        destObject.setEndpoints(mgwEpList);
    }
}

