/*
 *  Copyright (c) 2018, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 *  WSO2 Inc. licenses this file to you under the Apache License,
 *  Version 2.0 (the "License"); you may not use this file except
 *  in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.wso2.apimgt.gateway.cli.model.config;

import java.util.ArrayList;
import java.util.List;

/**
 * Configuration holder for ballerina CopyFile annotation.
 * This configuration has to be enabled to add CopyFiles
 * annotation to be populated into generated ballerina service.
 */
public class CopyFileConfig {

    private boolean enable = false;
    private List<CopyFile> files = new ArrayList<>();

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public List<CopyFile> getFiles() {
        return files;
    }

    public void setFiles(List<CopyFile> files) {
        this.files = files;
    }
}
