/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.packerina.cmd.CommandUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.LauncherCmd;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerationContext;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerator;
import org.wso2.apimgt.gateway.cli.codegen.ThrottlePolicyGenerator;
import org.wso2.apimgt.gateway.cli.config.TOMLConfigParser;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.ContainerConfig;
import org.wso2.apimgt.gateway.cli.model.config.DockerConfig;
import org.wso2.apimgt.gateway.cli.model.config.Filter;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;
import org.wso2.apimgt.gateway.cli.utils.ToolkitLibExtractionUtils;
import org.wso2.callhome.CallHomeExecutor;
import org.wso2.callhome.utils.CallHomeInfo;
import org.wso2.callhome.utils.MessageFormatter;
import org.wso2.callhome.utils.Util;

@Parameters(commandNames={"build"}, commandDescription="build a project")
public class BuildCmd
implements LauncherCmd {
    private static final Logger logger = LoggerFactory.getLogger(BuildCmd.class);
    private static PrintStream outStream = System.out;
    @Parameter(description="project", required=true)
    private String projectName;
    @Parameter(names={"-d", "--deployment-config"}, description="deployment-config file for docker/k8s")
    private String deploymentConfigPath;
    @Parameter(names={"--help", "-h", "?"}, description="print command help", help=true)
    private boolean helpFlag;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(names={"--docker"})
    private boolean isDocker;
    @Parameter(names={"--docker-image"})
    private String dockerImage;
    @Parameter(names={"--docker-base-image"})
    private String dockerBaseImage;
    private CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = this.getCommandUsageInfo("build");
            outStream.println(commandUsageInfo);
            return;
        }
        this.runCallHomeSeparateThread();
        String projectName = this.projectName.replaceAll("[/\\\\]", "");
        File projectLocation = new File(CmdUtils.getProjectDirectoryPath(projectName));
        try {
            String projectCanonicalPath = projectLocation.getCanonicalPath();
            String projectAbsolutePath = projectLocation.getAbsolutePath();
            if (!projectLocation.exists()) {
                throw new CLIRuntimeException("Project " + projectName + " does not exist.");
            }
            ToolkitLibExtractionUtils.extractPlatformAndRuntime();
            String importedAPIDefLocation = CmdUtils.getProjectGenAPIDefinitionPath(projectName);
            String addedAPIDefLocation = CmdUtils.getProjectAPIFilesDirectoryPath(projectName);
            String grpcProtoLocation = CmdUtils.getGrpcDefinitionsDirPath(projectName);
            boolean isImportedAPIsAvailable = this.isOpenAPIsAvailable(importedAPIDefLocation);
            boolean isAddedAPIsAvailable = this.isOpenAPIsAvailable(addedAPIDefLocation);
            boolean isProtoFilesAvailable = this.isProtosAvailable(grpcProtoLocation);
            if (!(isImportedAPIsAvailable || isAddedAPIsAvailable || isProtoFilesAvailable)) {
                throw new CLIRuntimeException("Nothing to build. API definitions/ Grpc Service definitions does not exist.");
            }
            if (!projectAbsolutePath.equalsIgnoreCase(projectCanonicalPath)) {
                throw new CLIRuntimeException("Current directory: '" + CmdUtils.getUserDir() + "' should have a project with name: '" + projectName + "'. Execute the build command from the directory where the project is initialized");
            }
            String toolkitConfigPath = CmdUtils.getMainConfigLocation();
            this.init(projectName, toolkitConfigPath, this.deploymentConfigPath);
            outStream.print("Generating sources...");
            String genPoliciesPath = CmdUtils.getProjectTargetModulePath(projectName) + File.separator + "policies";
            CmdUtils.createDirectory(genPoliciesPath, false);
            ThrottlePolicyGenerator policyGenerator = new ThrottlePolicyGenerator();
            policyGenerator.generate(genPoliciesPath, projectName);
            String resourcesPath = CmdUtils.getProjectTargetModulePath(projectName) + File.separator + "resources";
            CmdUtils.createDirectory(resourcesPath, false);
            CmdUtils.copyAndReplaceFolder(CmdUtils.getProjectInterceptorsPath(projectName), CmdUtils.getProjectTargetInterceptorsPath(projectName));
            new CodeGenerator().generate(projectName, true);
            this.replaceYAMLFilesToJson(resourcesPath);
            outStream.print(CmdUtils.format("[DONE]\n"));
            this.latch.await(10L, TimeUnit.SECONDS);
        }
        catch (IOException | InterruptedException e) {
            throw new CLIInternalException("Error occurred while generating source code for the open API definitions.", e);
        }
    }

    private String convertYamlToJson(String yaml) throws IOException {
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object obj = yamlReader.readValue(yaml, Object.class);
        ObjectMapper jsonWriter = new ObjectMapper();
        return jsonWriter.writeValueAsString(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceYAMLFilesToJson(String resPath) throws IOException {
        String val = null;
        FileInputStream fileInputStream = null;
        OutputStreamWriter writer = null;
        File dir = new File(resPath);
        File[] directoryListing = dir.listFiles();
        if (directoryListing != null) {
            try {
                for (File child : directoryListing) {
                    String ch = child.toString();
                    if (!ch.endsWith(".yaml")) continue;
                    String fileName = child.getName().replace(".yaml", ".json");
                    fileInputStream = new FileInputStream(child);
                    byte[] value = new byte[(int)child.length()];
                    fileInputStream.read(value);
                    fileInputStream.close();
                    String fileContent = new String(value, StandardCharsets.UTF_8);
                    val = this.convertYamlToJson(fileContent);
                    writer = new FileWriter(resPath + "/" + fileName);
                    writer.write(val);
                    writer.close();
                    child.delete();
                }
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    private boolean isOpenAPIsAvailable(String fileLocation) {
        File file = new File(fileLocation);
        FilenameFilter filter = (f, name) -> name.endsWith(".yaml") || name.endsWith(".json");
        String[] fileNames = file.list(filter);
        return fileNames != null && fileNames.length > 0;
    }

    private boolean isProtosAvailable(String fileLocation) {
        File file = new File(fileLocation);
        if (!file.exists()) {
            return false;
        }
        FilenameFilter protoFilter = (f, name) -> name.endsWith(".proto");
        String[] fileNames = file.list(protoFilter);
        if (fileNames != null && fileNames.length > 0) {
            return true;
        }
        FileFilter dirFilter = File::isDirectory;
        File[] subDirectories = file.listFiles(dirFilter);
        if (subDirectories == null) {
            return false;
        }
        int n = 0;
        File[] fileArray = subDirectories;
        int n2 = fileArray.length;
        if (n < n2) {
            File dir = fileArray[n];
            return this.isProtosAvailable(dir.getAbsolutePath());
        }
        return false;
    }

    @Override
    public String getName() {
        return "build";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }

    private void init(String projectName, String configPath, String deploymentConfig) {
        try {
            Path deploymentConfigFile;
            Path configurationFile = Paths.get(configPath, new String[0]);
            if (!Files.exists(configurationFile, new LinkOption[0])) {
                logger.error("Configuration: {} Not found.", (Object)configPath);
                throw new CLIInternalException("Error occurred while loading configurations.");
            }
            Config config = TOMLConfigParser.parse(configPath, Config.class);
            CmdUtils.setConfig(config);
            if (deploymentConfig != null && Files.exists(deploymentConfigFile = Paths.get(deploymentConfig, new String[0]), new LinkOption[0])) {
                CmdUtils.createDeploymentConfig(projectName, deploymentConfig);
            }
            String deploymentConfigPath = CmdUtils.getDeploymentConfigLocation(projectName);
            ContainerConfig containerConfig = TOMLConfigParser.parse(deploymentConfigPath, ContainerConfig.class);
            this.sortFilterBasedOnPosition(containerConfig);
            this.createDockerImageFromCLI(projectName, containerConfig);
            CmdUtils.setContainerConfig(containerConfig);
            CodeGenerationContext codeGenerationContext = new CodeGenerationContext();
            codeGenerationContext.setProjectName(projectName);
            CmdUtils.setCodeGenerationContext(codeGenerationContext);
            this.initTarget(projectName);
        }
        catch (ConfigParserException e) {
            logger.error("Error occurred while parsing the configurations {}", (Object)configPath, (Object)e);
            throw new CLIInternalException("Error occurred while loading configurations.");
        }
        catch (IOException e) {
            throw new CLIInternalException("Error occurred while reading the deployment configuration", e);
        }
    }

    private void createDockerImageFromCLI(String projectName, ContainerConfig containerConfig) {
        if (this.isDocker || !StringUtils.isEmpty((CharSequence)this.dockerImage) || !StringUtils.isEmpty((CharSequence)this.dockerBaseImage)) {
            PrintStream outStream = System.out;
            if (StringUtils.isEmpty((CharSequence)this.dockerImage)) {
                this.dockerImage = CmdUtils.promptForTextInput(outStream, "Enter docker image name: [" + projectName + ":" + "v1" + "]").trim();
            }
            if (StringUtils.isEmpty((CharSequence)this.dockerBaseImage)) {
                this.dockerBaseImage = CmdUtils.promptForTextInput(outStream, "Enter docker baseImage [wso2/wso2micro-gw:latest]: ").trim();
            }
            if (StringUtils.isBlank((CharSequence)this.dockerImage)) {
                this.dockerImage = projectName + ":" + "v1";
            }
            if (StringUtils.isBlank((CharSequence)this.dockerBaseImage)) {
                this.dockerBaseImage = "wso2/wso2micro-gw:latest";
            }
            String[] dockerNameAndTag = this.dockerImage.split(":");
            String dockerName = dockerNameAndTag[0];
            String dockerTag = dockerNameAndTag[1];
            DockerConfig dockerConfig = containerConfig.getDocker().getDockerConfig();
            dockerConfig.setEnable(true);
            dockerConfig.setName(dockerName);
            dockerConfig.setTag(dockerTag);
            dockerConfig.setBaseImage(this.dockerBaseImage);
        }
    }

    private void initTarget(String projectName) throws IOException {
        String projectDir = CmdUtils.getProjectDirectoryPath(projectName);
        String targetDirPath = projectDir + File.separator + "target";
        CmdUtils.createDirectory(targetDirPath, true);
        String targetGenDir = targetDirPath + File.separator + "gen";
        CmdUtils.createDirectory(targetGenDir, true);
        CmdUtils.createDirectory(CmdUtils.getProjectTargetGenGrpcSrcDirectory(projectName), true);
        CmdUtils.createDirectory(CmdUtils.getProjectTargetGenGrpcSrcOpenAPIsDirectory(projectName), true);
        CmdUtils.createDirectory(CmdUtils.getProjectTargetGenGrpcSrcDescDirectory(projectName), true);
        CommandUtil.initProject((Path)Paths.get(targetGenDir, new String[0]));
        String projectModuleDir = CmdUtils.getProjectTargetModulePath(projectName);
        CmdUtils.createDirectory(projectModuleDir, true);
    }

    private void invokeCallHome() {
        try {
            String productHome = CmdUtils.getCLIHome();
            String trustStoreLocation = CmdUtils.getCacertsLocation();
            String trustStorePassword = CmdUtils.getCacertsPassword();
            CallHomeInfo callhomeinfo = Util.createCallHomeInfo((String)productHome, (String)trustStoreLocation, (String)trustStorePassword);
            CallHomeExecutor.execute((CallHomeInfo)callhomeinfo);
            String callHomeResponse = CallHomeExecutor.getMessage();
            String formattedMessage = MessageFormatter.formatMessage((String)callHomeResponse, (int)180);
            CmdUtils.setCallHomeMessage(formattedMessage);
            this.latch.countDown();
        }
        catch (Exception e) {
            logger.error("Error while initialising call home functionality", (Throwable)e);
            this.latch.countDown();
        }
    }

    private void runCallHomeSeparateThread() {
        Thread callHomeThread = new Thread(() -> this.invokeCallHome());
        callHomeThread.setName("callHomeThread");
        callHomeThread.start();
    }

    private void sortFilterBasedOnPosition(ContainerConfig containerConfig) {
        if (containerConfig.getFilters() != null) {
            Comparator<Filter> compareByPosition = Comparator.comparing(Filter::getPosition);
            Collections.sort(containerConfig.getFilters(), compareByPosition);
        }
    }
}

