/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.LauncherCmd;
import org.wso2.apimgt.gateway.cli.config.TOMLConfigParser;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.exception.CliLauncherException;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.Token;
import org.wso2.apimgt.gateway.cli.model.config.TokenBuilder;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.oauth.OAuthServiceImpl;
import org.wso2.apimgt.gateway.cli.rest.RESTAPIServiceImpl;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;
import org.wso2.apimgt.gateway.cli.utils.ToolkitLibExtractionUtils;

@Parameters(commandNames={"import"}, commandDescription="pull APIs from API Publisher")
public class ImportCmd
implements LauncherCmd {
    private static final Logger logger = LoggerFactory.getLogger(ImportCmd.class);
    private static PrintStream outStream = System.out;
    @Parameter(description="project", required=true)
    private String projectName;
    @Parameter(names={"-u", "--username"}, description="API Publisher username")
    private String username;
    @Parameter(names={"-p", "--password"}, description="API Publisher password")
    private String password;
    @Parameter(names={"-l", "--label"}, description="gateway label")
    private String label;
    @Parameter(names={"-s", "--server-url"}, description="API Publisher url")
    private String baseURL;
    @Parameter(names={"-t", "--truststore"}, description="truststore for https connection")
    private String trustStoreLocation;
    @Parameter(names={"-w", "--truststore-pass"}, description="truststore password")
    private String trustStorePassword;
    @Parameter(names={"-c", "--config"}, hidden=true)
    private String toolkitConfigPath;
    @Parameter(names={"-a", "--api-name"}, description="name of the API")
    private String apiName;
    @Parameter(names={"-v", "--version"}, description="version of the API")
    private String version;
    @Parameter(names={"-k", "--insecure"}, description="skip ssl validation", arity=0)
    private boolean isInsecure;
    @Parameter(names={"--help", "-h", "?"}, description="print command help", help=true)
    private boolean helpFlag;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    private String publisherEndpoint;
    private String adminEndpoint;
    private String registrationEndpoint;
    private String tokenEndpoint;
    private String clientSecret;
    private boolean isOverwriteRequired;
    private String restVersion;
    private String dcrVersion;

    @Override
    public void execute() {
        File trustStoreFile;
        String configuredTrustStorePass;
        String encryptedPass;
        if (this.helpFlag) {
            String commandUsageInfo = this.getCommandUsageInfo("import");
            outStream.println(commandUsageInfo);
            return;
        }
        File projectLocation = new File(CmdUtils.getProjectDirectoryPath(this.projectName));
        if (!projectLocation.exists()) {
            throw CmdUtils.createUsageException("Project " + this.projectName + " does not exist. Please use 'micro-gw init " + this.projectName + "' to initialize the project.");
        }
        ToolkitLibExtractionUtils.extractPlatformAndRuntime();
        if (StringUtils.isEmpty((CharSequence)this.toolkitConfigPath)) {
            this.toolkitConfigPath = CmdUtils.getMainConfigLocation();
        }
        ImportCmd.init(this.toolkitConfigPath);
        Config config = CmdUtils.getConfig();
        this.isOverwriteRequired = false;
        this.validateAPIGetRequestParams(this.label, this.apiName, this.version);
        String configuredUser = config.getToken().getUsername();
        if (StringUtils.isEmpty((CharSequence)configuredUser)) {
            if (StringUtils.isEmpty((CharSequence)this.username)) {
                this.isOverwriteRequired = true;
                this.username = CmdUtils.promptForTextInput(outStream, "Enter Username: ");
                if (this.username.trim().isEmpty()) {
                    throw CmdUtils.createUsageException("Micro gateway init failed: empty username.");
                }
            }
        } else {
            this.username = configuredUser;
        }
        if (StringUtils.isEmpty((CharSequence)this.password) && (this.password = this.promptForPasswordInput("Enter Password for " + this.username + ": ")).trim().isEmpty() && StringUtils.isEmpty((CharSequence)this.password)) {
            this.password = this.promptForPasswordInput("Password can't be empty; enter password for " + this.username + ": ");
            if (this.password.trim().isEmpty()) {
                throw CmdUtils.createUsageException("Micro gateway init failed: empty password.");
            }
        }
        Token configToken = config.getToken();
        TokenBuilder configTokenValues = this.setEndpoints(configToken);
        String configuredTrustStore = config.getToken().getTrustStoreLocation();
        if (StringUtils.isEmpty((CharSequence)configuredTrustStore)) {
            if (StringUtils.isEmpty((CharSequence)this.trustStoreLocation)) {
                this.isOverwriteRequired = true;
                String tsPrompt = "Enter Trust store location: [lib/platform/bre/security/ballerinaTruststore.p12]";
                String trustStorePath = CmdUtils.promptForTextInput(outStream, tsPrompt);
                if (trustStorePath.trim().isEmpty()) {
                    this.trustStoreLocation = "lib/platform/bre/security/ballerinaTruststore.p12";
                }
            }
        } else {
            this.trustStoreLocation = configuredTrustStore;
        }
        if (StringUtils.isEmpty((CharSequence)(encryptedPass = config.getToken().getTrustStorePassword()))) {
            configuredTrustStorePass = null;
        } else {
            try {
                configuredTrustStorePass = CmdUtils.decrypt(encryptedPass, this.password);
            }
            catch (CliLauncherException e) {
                configuredTrustStorePass = null;
            }
        }
        if (StringUtils.isEmpty(configuredTrustStorePass)) {
            if (StringUtils.isEmpty((CharSequence)this.trustStorePassword)) {
                this.isOverwriteRequired = true;
                this.trustStorePassword = this.promptForPasswordInput("Enter Trust store password: [ use default? ]");
                if (this.trustStorePassword.trim().isEmpty()) {
                    this.trustStorePassword = "ballerina";
                }
            }
        } else {
            this.trustStorePassword = configuredTrustStorePass;
        }
        if (!(trustStoreFile = new File(this.trustStoreLocation)).isAbsolute()) {
            this.trustStoreLocation = CmdUtils.getUnixPath(CmdUtils.getCLIHome() + File.separator + this.trustStoreLocation);
        }
        if (!(trustStoreFile = new File(this.trustStoreLocation)).exists()) {
            logger.error("Provided trust store location {} does not exist.", (Object)this.trustStoreLocation);
            throw new CLIRuntimeException("Provided trust store location does not exist.");
        }
        System.setProperty("javax.net.ssl.keyStoreType", "pkcs12");
        System.setProperty("javax.net.ssl.trustStoreType", "pkcs12");
        System.setProperty("javax.net.ssl.trustStore", this.trustStoreLocation);
        System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
        OAuthServiceImpl manager = new OAuthServiceImpl();
        String clientID = config.getToken().getClientId();
        String encryptedSecret = config.getToken().getClientSecret();
        if (!StringUtils.isEmpty((CharSequence)clientID.trim()) && !StringUtils.isEmpty((CharSequence)encryptedSecret.trim())) {
            try {
                this.clientSecret = CmdUtils.decrypt(encryptedSecret, this.password);
            }
            catch (CliLauncherException e) {
                this.clientSecret = null;
            }
        }
        if (StringUtils.isEmpty((CharSequence)clientID) || StringUtils.isEmpty((CharSequence)this.clientSecret)) {
            String[] clientInfo = manager.generateClientIdAndSecret(this.registrationEndpoint, this.username, this.password.toCharArray(), this.isInsecure);
            clientID = clientInfo[0];
            this.clientSecret = clientInfo[1];
        }
        String accessToken = manager.generateAccessToken(this.tokenEndpoint, this.username, this.password.toCharArray(), clientID, this.clientSecret, this.isInsecure);
        List<Object> apis = new ArrayList();
        RESTAPIServiceImpl service = new RESTAPIServiceImpl(this.publisherEndpoint, this.adminEndpoint, this.restVersion, this.isInsecure);
        if (this.label != null) {
            apis = service.getAPIs(this.label, accessToken);
        } else {
            ExtendedAPI api = service.getAPI(this.apiName, this.version, accessToken);
            if (api != null) {
                apis.add(api);
            }
        }
        if (apis.isEmpty()) {
            String errorMsg = this.label != null ? "No APIs found for the given label: " + this.label : "No Published APIs matched for name:" + this.apiName + ", version:" + this.version;
            throw new CLIRuntimeException(errorMsg);
        }
        try {
            CmdUtils.saveSwaggerDefinitionForMultipleAPIs(this.projectName, apis, !this.restVersion.startsWith("v1."));
        }
        catch (Exception e) {
            throw new CLIInternalException("Exception occurred during codeGeneration process", e);
        }
        if (this.isOverwriteRequired) {
            Config newConfig = new Config();
            newConfig.setClient(config.getClient());
            String encryptedCS = CmdUtils.encrypt(this.clientSecret, this.password);
            String encryptedTrustStorePass = CmdUtils.encrypt(this.trustStorePassword, this.password);
            Token token = configTokenValues.setUsername(this.username).setClientId(clientID).setClientSecret(encryptedCS).setTrustStoreLocation(this.trustStoreLocation).setTrustStorePassword(encryptedTrustStorePass).build();
            newConfig.setToken(token);
            newConfig.setCorsConfiguration(config.getCorsConfiguration());
            CmdUtils.saveConfig(newConfig, this.toolkitConfigPath);
        }
        outStream.println("\n(Use \"micro-gw build " + this.projectName + "\" to build the project)");
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }

    private String promptForTextInput(String msg) {
        outStream.println(msg);
        return System.console().readLine();
    }

    private static void init(String configPath) {
        try {
            Path configurationFile = Paths.get(configPath, new String[0]);
            if (!Files.exists(configurationFile, new LinkOption[0])) {
                logger.error("Configuration: {} Not found.", (Object)configPath);
                throw new CLIInternalException("Error occurred while loading configurations.");
            }
            Config config = TOMLConfigParser.parse(configPath, Config.class);
            CmdUtils.setConfig(config);
        }
        catch (ConfigParserException e) {
            logger.error("Error occurred while parsing the configurations {}", (Object)configPath, (Object)e);
            throw new CLIInternalException("Error occurred while loading configurations.");
        }
    }

    private void validateAPIGetRequestParams(String label, String apiName, String version) {
        if (StringUtils.isEmpty((CharSequence)label) && (StringUtils.isEmpty((CharSequence)apiName) || StringUtils.isEmpty((CharSequence)version)) || StringUtils.isNotEmpty((CharSequence)label) && (StringUtils.isNotEmpty((CharSequence)apiName) || StringUtils.isNotEmpty((CharSequence)version)) || StringUtils.isEmpty((CharSequence)apiName) && StringUtils.isNotEmpty((CharSequence)version) || StringUtils.isNotEmpty((CharSequence)apiName) && StringUtils.isEmpty((CharSequence)version)) {
            throw CmdUtils.createUsageException("Missing \"-l <label>\" or \"-a <api-name> -v <version>\" parameters");
        }
    }

    private TokenBuilder setEndpoints(Token token) {
        boolean isRestVersionNeeded;
        TokenBuilder configTokenValues = new TokenBuilder();
        this.restVersion = token.getRestVersion();
        this.dcrVersion = token.getDcrVersion();
        this.publisherEndpoint = token.getPublisherEndpoint();
        this.adminEndpoint = token.getAdminEndpoint();
        this.registrationEndpoint = token.getRegistrationEndpoint();
        this.tokenEndpoint = token.getTokenEndpoint();
        configTokenValues.setPublisherEndpoint(this.publisherEndpoint);
        configTokenValues.setAdminEndpoint(this.adminEndpoint);
        configTokenValues.setRegistrationEndpoint(this.registrationEndpoint);
        configTokenValues.setTokenEndpoint(this.tokenEndpoint);
        configTokenValues.setRestVersion(this.restVersion);
        configTokenValues.setDCRVersion(this.dcrVersion);
        configTokenValues.setBaseURL(token.getBaseURL());
        boolean isEndPointsNeeded = StringUtils.isEmpty((CharSequence)this.publisherEndpoint) || StringUtils.isEmpty((CharSequence)this.adminEndpoint) || StringUtils.isEmpty((CharSequence)this.registrationEndpoint) || StringUtils.isEmpty((CharSequence)this.tokenEndpoint);
        boolean isBaseURLNeeded = this.publisherEndpoint.contains("{baseURL}") || this.adminEndpoint.contains("{baseURL}") || this.registrationEndpoint.contains("{baseURL}") || this.tokenEndpoint.contains("{baseURL}") || isEndPointsNeeded;
        boolean bl = isRestVersionNeeded = this.publisherEndpoint.contains("{restVersion}") || this.adminEndpoint.contains("{restVersion}") || this.registrationEndpoint.contains("{dcrVersion}") || isEndPointsNeeded;
        if (isEndPointsNeeded) {
            if (StringUtils.isEmpty((CharSequence)this.publisherEndpoint)) {
                this.publisherEndpoint = "{baseURL}/api/am/publisher/{restVersion}";
            }
            if (StringUtils.isEmpty((CharSequence)this.adminEndpoint)) {
                this.adminEndpoint = "{baseURL}/api/am/admin/{restVersion}";
            }
            if (StringUtils.isEmpty((CharSequence)this.registrationEndpoint)) {
                this.registrationEndpoint = "{baseURL}/client-registration/{dcrVersion}/register";
            }
            if (StringUtils.isEmpty((CharSequence)this.tokenEndpoint)) {
                this.tokenEndpoint = "{baseURL}/oauth2/token";
            }
        }
        if (isBaseURLNeeded) {
            if (StringUtils.isEmpty((CharSequence)this.baseURL)) {
                String userInputURL;
                this.baseURL = token.getBaseURL();
                if (StringUtils.isEmpty((CharSequence)this.baseURL)) {
                    this.baseURL = "https://localhost:9443";
                }
                if (!(userInputURL = this.getBaseURLFromCmd(this.baseURL)).isEmpty()) {
                    this.baseURL = userInputURL;
                    this.isOverwriteRequired = true;
                }
            }
            configTokenValues.setBaseURL(this.baseURL);
        }
        if (isRestVersionNeeded) {
            if (StringUtils.isEmpty((CharSequence)this.restVersion)) {
                this.restVersion = "v1.2";
            }
            if (StringUtils.isEmpty((CharSequence)this.dcrVersion)) {
                this.dcrVersion = "v0.17";
            }
            this.informRestVersionToUser(this.restVersion, this.dcrVersion);
            configTokenValues.setRestVersion(this.restVersion);
            configTokenValues.setDCRVersion(this.dcrVersion);
        }
        if (isBaseURLNeeded || isRestVersionNeeded) {
            this.publisherEndpoint = this.publisherEndpoint.replace("{baseURL}", this.baseURL).replace("{restVersion}", this.restVersion);
            this.adminEndpoint = this.adminEndpoint.replace("{baseURL}", this.baseURL).replace("{restVersion}", this.restVersion);
            this.registrationEndpoint = this.registrationEndpoint.replace("{baseURL}", this.baseURL).replace("{dcrVersion}", this.dcrVersion);
            this.tokenEndpoint = this.tokenEndpoint.replace("{baseURL}", this.baseURL).replace("{restVersion}", this.restVersion);
        }
        this.validateURL(this.publisherEndpoint);
        this.validateURL(this.adminEndpoint);
        this.validateURL(this.registrationEndpoint);
        this.validateURL(this.tokenEndpoint);
        return configTokenValues;
    }

    private void validateURL(String urlString) {
        try {
            new URL(urlString);
        }
        catch (MalformedURLException e) {
            logger.error("Malformed URL provided {}", (Object)urlString);
            throw new CLIInternalException("Error occurred while setting up URL configurations.");
        }
    }

    private void informRestVersionToUser(String restVersion, String dcrVersion) {
        outStream.println("You are using REST version - " + restVersion + " and dynamic client registration version - " + dcrVersion + " of API Manager. \n (If you want to change this, go to <MGW-TK_HOME>/conf/toolkit-config.toml)");
    }

    private String getBaseURLFromCmd(String defaultBaseURL) {
        String userInputURL = this.promptForTextInput("Enter APIM base URL [" + defaultBaseURL + "]: ").trim();
        return userInputURL;
    }

    private String promptForPasswordInput(String msg) {
        outStream.println(msg);
        return new String(System.console().readPassword());
    }
}

