/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.ParameterException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.BuildCmd;
import org.wso2.apimgt.gateway.cli.cmd.HelpCmd;
import org.wso2.apimgt.gateway.cli.cmd.ImportCmd;
import org.wso2.apimgt.gateway.cli.cmd.InitCmd;
import org.wso2.apimgt.gateway.cli.cmd.LauncherCmd;
import org.wso2.apimgt.gateway.cli.cmd.ResetCmd;
import org.wso2.apimgt.gateway.cli.cmd.VersionCmd;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.exception.CliLauncherException;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;

public class Main {
    private static final String INTERNAL_ERROR_MESSAGE = "Internal error occurred while executing command.";
    private static final String MICRO_GW = "micro-gw: ";
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static PrintStream err = System.err;
    private static PrintStream out = System.out;

    public static void main(String ... args) {
        Optional<LauncherCmd> invokedCmd = Optional.empty();
        try {
            invokedCmd = Main.getInvokedCmd(args);
            invokedCmd.ifPresent(LauncherCmd::execute);
            CmdUtils.printMessagesToConsole();
            CmdUtils.printCallHomeMessage();
            Runtime.getRuntime().exit(0);
        }
        catch (CliLauncherException e) {
            err.println(e.getMessages());
            Throwable cause = e.getCause();
            if (cause instanceof ParameterException) {
                ParameterException paramEx = (ParameterException)cause;
                paramEx.usage();
            }
            logger.error("micro-gw: Error occurred while executing command.", (Throwable)e);
            Runtime.getRuntime().exit(1);
        }
        catch (CLIInternalException e) {
            Main.showBuildError(invokedCmd);
            err.println("micro-gw: Internal error occurred while executing command. - " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            Runtime.getRuntime().exit(1);
        }
        catch (CLIRuntimeException e) {
            Main.showBuildError(invokedCmd);
            err.println(MICRO_GW + e.getTerminalMsg());
            logger.error(e.getMessage(), (Throwable)e);
            Runtime.getRuntime().exit(e.getExitCode());
        }
        catch (Exception e) {
            Main.showBuildError(invokedCmd);
            err.println("micro-gw: Internal error occurred while executing command.");
            logger.error(INTERNAL_ERROR_MESSAGE, (Throwable)e);
            Runtime.getRuntime().exit(1);
        }
    }

    private static Optional<LauncherCmd> getInvokedCmd(String ... args) {
        try {
            HelpCmd helpCmd = new HelpCmd();
            InitCmd initCmd = new InitCmd();
            BuildCmd buildCmd = new BuildCmd();
            ResetCmd resetCmd = new ResetCmd();
            ImportCmd importCmd = new ImportCmd();
            VersionCmd versionCmd = new VersionCmd();
            JCommander cmdParser = JCommander.newBuilder().addCommand("help", (Object)helpCmd, new String[0]).addCommand("init", (Object)initCmd, new String[0]).addCommand("build", (Object)buildCmd, new String[0]).addCommand("reset", (Object)resetCmd, new String[0]).addCommand("import", (Object)importCmd, new String[0]).addCommand("version", (Object)versionCmd, new String[0]).build();
            cmdParser.setProgramName("micro-gw");
            helpCmd.setParentCmdParser(cmdParser);
            initCmd.setParentCmdParser(cmdParser);
            buildCmd.setParentCmdParser(cmdParser);
            resetCmd.setParentCmdParser(cmdParser);
            importCmd.setParentCmdParser(cmdParser);
            versionCmd.setParentCmdParser(cmdParser);
            cmdParser.parse(args);
            String parsedCmdName = cmdParser.getParsedCommand();
            if (parsedCmdName == null) {
                ParameterException paramEx = new ParameterException("Command not specified");
                paramEx.setJCommander(cmdParser);
                throw paramEx;
            }
            Map commanderMap = cmdParser.getCommands();
            return Optional.of((LauncherCmd)((JCommander)commanderMap.get(parsedCmdName)).getObjects().get(0));
        }
        catch (MissingCommandException e) {
            String errorMsg = "Unknown command '" + e.getUnknownCommand() + "'";
            throw CmdUtils.createUsageException(errorMsg);
        }
        catch (ParameterException e) {
            String msg = e.getMessage();
            CliLauncherException cliEx = new CliLauncherException((RuntimeException)((Object)e));
            if (msg == null) {
                cliEx.addMessage("Internal error occurred");
            } else {
                cliEx.addMessage(msg);
            }
            throw cliEx;
        }
    }

    private static void showBuildError(Optional<LauncherCmd> invokedCmd) {
        invokedCmd.ifPresent(value -> {
            if ("build".equalsIgnoreCase(value.getName())) {
                out.print(CmdUtils.format("[ERROR]\n"));
            }
        });
    }
}

