/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.wso2.apimgt.gateway.cli.cmd.LauncherCmd;
import org.wso2.apimgt.gateway.cli.config.TOMLConfigParser;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.Token;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;

@Parameters(commandNames={"reset"}, commandDescription="reset configurations")
public class ResetCmd
implements LauncherCmd {
    private static PrintStream outStream = System.err;
    @Parameter(names={"-c", "--config"}, description="external config file path")
    private String configPath;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;

    @Override
    public void execute() {
        Path configurationFile;
        if (StringUtils.isEmpty((CharSequence)this.configPath)) {
            this.configPath = CmdUtils.getMainConfigLocation();
        }
        if (!Files.exists(configurationFile = Paths.get(this.configPath, new String[0]), new LinkOption[0])) {
            outStream.println("Config: " + this.configPath + " Not found.");
            Runtime.getRuntime().exit(1);
        }
        try {
            Config newConfig = TOMLConfigParser.parse(this.configPath, Config.class);
            Token token = newConfig.getToken();
            token.setClientId("");
            token.setClientSecret("");
            token.setUsername("");
            CmdUtils.saveConfig(newConfig, this.configPath);
        }
        catch (ConfigParserException e) {
            throw new CLIInternalException("Error occurred while parsing the configuration : " + this.configPath, e);
        }
    }

    @Override
    public String getName() {
        return "reset";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }
}

