/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.wso2.apimgt.gateway.cli.cmd.LauncherCmd;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;

@Parameters(commandNames={"version"}, commandDescription="find the micro-gw toolkit version")
public class VersionCmd
implements LauncherCmd {
    private static PrintStream outStream = System.err;

    @Override
    public void execute() {
        String fileLocation = CmdUtils.getResourceFolderLocation() + File.separator + "version.txt";
        String version = VersionCmd.getversion(fileLocation);
        outStream.println(version);
    }

    @Override
    public String getName() {
        return "version";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }

    public static String getversion(String filePath) {
        String toolkitVersion;
        try {
            toolkitVersion = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        }
        catch (IOException e) {
            throw new CLIInternalException("Error occurred while finding the version.txt file", e);
        }
        return toolkitVersion;
    }
}

