/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.hashing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.HashingException;
import org.wso2.apimgt.gateway.cli.hashing.Hash;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;

public class HashUtils {
    private static final Logger logger = LoggerFactory.getLogger(HashUtils.class);

    public static boolean detectChanges(List<ExtendedAPI> apis, List<SubscriptionThrottlePolicyDTO> subscriptionPolicies, List<ApplicationThrottlePolicyDTO> appPolicies, String projectName) throws HashingException {
        boolean hasChanges = true;
        HashMap<String, String> allHashesMap = new HashMap<String, String>();
        Map<String, String> apiHashesMap = HashUtils.getMapOfHashes(apis);
        Map<String, String> appPolicyHashesMap = HashUtils.getMapOfHashes(appPolicies);
        Map<String, String> subsPolicyHashesMap = HashUtils.getMapOfHashes(subscriptionPolicies);
        logger.debug("API calculated hashes {}", apiHashesMap);
        logger.debug("App policy calculated hashes {}", appPolicyHashesMap);
        logger.debug("Subscription policy calculated hashes {}", subsPolicyHashesMap);
        allHashesMap.putAll(apiHashesMap);
        allHashesMap.putAll(appPolicyHashesMap);
        allHashesMap.putAll(subsPolicyHashesMap);
        try {
            Map<String, String> storedHashes = HashUtils.loadStoredResourceHashes(projectName);
            if (HashUtils.equalMaps(storedHashes, allHashesMap)) {
                logger.debug("No changes detected after calculating hashes.");
                hasChanges = false;
            } else {
                logger.debug("Storing calculated resource hashes.");
                HashUtils.storeResourceHashes(allHashesMap, projectName);
                logger.debug("Storing calculated resource hashes success.");
            }
        }
        catch (IOException e) {
            throw new HashingException("Error while resource change detection", e);
        }
        return hasChanges;
    }

    private static Map<String, String> loadStoredResourceHashes(String projectName) throws IOException {
        String content = CmdUtils.loadStoredResourceHashes(projectName);
        Map<String, String> hashes = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            ObjectMapper objectMapper = new ObjectMapper();
            hashes = (Map)objectMapper.readValue(content, Map.class);
        }
        return hashes;
    }

    private static void storeResourceHashes(Map<String, String> hashesMap, String projectName) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String stringifiedHashes = mapper.writeValueAsString(hashesMap);
        CmdUtils.storeResourceHashesFileContent(stringifiedHashes, projectName);
    }

    private static Map<String, String> getMapOfHashes(List objects) throws HashingException {
        HashMap<String, String> hashes = new HashMap<String, String>();
        if (objects != null) {
            for (Object obj : objects) {
                String hash = HashUtils.getAnnotatedHash(obj);
                if (obj instanceof ExtendedAPI) {
                    hashes.put(((ExtendedAPI)obj).getId(), hash);
                    continue;
                }
                if (obj instanceof ThrottlePolicyDTO) {
                    hashes.put(((ThrottlePolicyDTO)obj).getPolicyId(), hash);
                    continue;
                }
                logger.warn("Incompatible type for generating hash: " + obj + ", class: " + obj.getClass());
            }
        }
        return hashes;
    }

    private static String getAnnotatedHash(Object obj) throws HashingException {
        ObjectMapper mapper = new ObjectMapper();
        TreeSet<String> sortedSet = new TreeSet<String>();
        for (Method method : obj.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Hash.class)) continue;
            try {
                Object value = method.invoke(obj, new Object[0]);
                String stringifiedField = mapper.writeValueAsString(value);
                sortedSet.add(method.getName() + "::" + stringifiedField);
            }
            catch (JsonProcessingException | IllegalAccessException | InvocationTargetException e) {
                throw new HashingException("Error while generating hash for " + obj, e);
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String entry : sortedSet) {
            builder.append(entry);
            builder.append("::");
        }
        String val = builder.toString();
        return HashUtils.getMD5Hex(val);
    }

    private static boolean equalMaps(Map<String, String> map1, Map<String, String> map2) {
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.keySet().size() != map2.keySet().size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : map1.entrySet()) {
            if (entry.getValue() != null && entry.getValue().equals(map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static String getMD5Hex(String inputString) throws HashingException {
        byte[] digest;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(inputString.getBytes(StandardCharsets.UTF_8));
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new HashingException("Error getting md5 hash of " + inputString, e);
        }
        return HashUtils.convertByteToHex(digest);
    }

    private static String convertByteToHex(byte[] byteData) {
        StringBuilder sb = new StringBuilder();
        for (byte aByteData : byteData) {
            sb.append(Integer.toString((aByteData & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static String generateAPIId(String apiName, String version) {
        String concatString = apiName + ":" + version;
        try {
            return "api_" + HashUtils.getMD5Hex(concatString);
        }
        catch (HashingException e) {
            throw new CLIInternalException("Error while generating md5 hash for API");
        }
    }

    public static String generateResourceId(String apiName, String version, String resource, String method) {
        String concatString = apiName + ":" + version + ":" + resource + ":" + method;
        try {
            return HashUtils.getMD5Hex(concatString);
        }
        catch (HashingException e) {
            throw new CLIInternalException("Error while generating md5 hash for API resource");
        }
    }
}

