/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.LogManager;
import java.util.regex.Matcher;
import org.wso2.apimgt.gateway.cli.constants.CliConstants;

public class CLILogManager
extends LogManager {
    @Override
    public void readConfiguration(InputStream ins) throws IOException, SecurityException {
        Properties properties = new Properties();
        properties.load(ins);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String val = this.substituteVariables((String)v);
            properties.setProperty((String)k, val);
        }));
        super.readConfiguration(this.propertiesToInputStream(properties));
    }

    private String substituteVariables(String value) {
        Matcher matcher = CliConstants.SYS_PROP_PATTERN.matcher(value);
        boolean found = matcher.find();
        if (!found) {
            return value;
        }
        StringBuffer buffer = new StringBuffer();
        do {
            String sysPropertyKey;
            String sysPropertyValue;
            if ((sysPropertyValue = this.getSystemVariableValue(sysPropertyKey = matcher.group(1))) == null || sysPropertyValue.isEmpty()) continue;
            sysPropertyValue = sysPropertyValue.replace("\\", "\\\\");
            matcher.appendReplacement(buffer, sysPropertyValue);
        } while (matcher.find());
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String getSystemVariableValue(String variableName) {
        String value = System.getProperty(variableName) != null ? System.getProperty(variableName) : (System.getenv(variableName) != null ? System.getenv(variableName) : variableName);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream propertiesToInputStream(Properties properties) throws IOException {
        try (ByteArrayOutputStream outputStream = null;){
            outputStream = new ByteArrayOutputStream();
            properties.store(outputStream, "Java util logging configuration properties");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return byteArrayInputStream;
        }
    }
}

