/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.model.template.policy;

import java.util.ArrayList;
import java.util.List;
import org.wso2.apimgt.gateway.cli.constants.GeneratorConstants;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ThrottlePolicyMapper;
import org.wso2.apimgt.gateway.cli.utils.CodegenUtils;

public class ThrottlePolicyInitializer {
    private List<String> policyInitNames = new ArrayList<String>();
    private List<String> policyNames = new ArrayList<String>();
    private List<ThrottlePolicyMapper> policyList = new ArrayList<ThrottlePolicyMapper>();

    public List<String> getPolicyInitNames() {
        return this.policyInitNames;
    }

    public void setPolicyInitNames(List<String> policyInitNames) {
        this.policyInitNames = policyInitNames;
    }

    public ThrottlePolicyInitializer buildAppContext(List<ApplicationThrottlePolicyDTO> applicationPolicies) {
        for (ApplicationThrottlePolicyDTO policyDTO : applicationPolicies) {
            String escapedPolicyName = CodegenUtils.trim(policyDTO.getPolicyName());
            this.policyInitNames.add("initApplication" + escapedPolicyName + "Policy");
            this.policyNames.add(escapedPolicyName);
        }
        return this;
    }

    public ThrottlePolicyInitializer buildSubsContext(List<SubscriptionThrottlePolicyDTO> subscriptionPolicies) {
        for (SubscriptionThrottlePolicyDTO policyDTO : subscriptionPolicies) {
            String escapedPolicyName = CodegenUtils.trim(policyDTO.getPolicyName());
            this.policyInitNames.add("initSubscription" + escapedPolicyName + "Policy");
            this.policyNames.add(escapedPolicyName);
        }
        return this;
    }

    public ThrottlePolicyInitializer buildPolicyContext(List<ThrottlePolicyMapper> policies, GeneratorConstants.PolicyType type) {
        for (ThrottlePolicyMapper policyDTO : policies) {
            String escapedPolicyName = CodegenUtils.trim(policyDTO.getName());
            String policyName = policyDTO.getName();
            switch (type) {
                case RESOURCE: {
                    this.policyInitNames.add("initResource" + escapedPolicyName + "Policy");
                    policyDTO.setName("res_" + policyName);
                    break;
                }
                case APPLICATION: {
                    this.policyInitNames.add("initApplication" + escapedPolicyName + "Policy");
                    policyDTO.setName("app_" + policyName);
                    break;
                }
                case SUBSCRIPTION: {
                    this.policyInitNames.add("initSubscription" + escapedPolicyName + "Policy");
                    policyDTO.setName("sub_" + policyName);
                }
            }
            this.policyNames.add(escapedPolicyName);
            this.policyList.add(policyDTO);
        }
        return this;
    }
}

