/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.model.template.service;

import java.util.HashMap;
import org.wso2.apimgt.gateway.cli.constants.OpenAPIConstants;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;

public class BallerinaInterceptor {
    private String org;
    private String module;
    private String version = null;
    private String name;
    private String id;
    private String invokeStatement;
    private String importStatement;
    private String fqn;
    private Type type;
    private static HashMap<String, String> pickedIdentifiers = new HashMap();

    public BallerinaInterceptor(String extension) throws BallerinaServiceGenException {
        if (extension.contains("/") && extension.contains(":")) {
            String[] parts = extension.split("/");
            String[] funcParts = parts[parts.length - 1].split(":");
            if (parts.length == 2) {
                this.module = funcParts[0];
            } else if (parts.length == 3) {
                this.module = parts[1];
                this.version = funcParts[0];
            }
            this.name = funcParts[1];
            this.org = parts[0];
            this.fqn = this.org + "/" + this.module;
            this.id = this.pickModuleIdentifier(this.fqn);
            if (this.id == null) {
                throw new BallerinaServiceGenException("Couldn't pick an unique identifier for module " + this.fqn);
            }
            this.invokeStatement = this.id + ":" + this.name;
            this.importStatement = this.fqn + ' ' + "as" + ' ' + this.id;
            this.type = Type.CENTRAL;
        } else if (extension.startsWith("java:")) {
            this.invokeStatement = this.name = extension;
            this.type = Type.JAVA;
        } else {
            this.invokeStatement = this.name = extension;
            this.type = Type.LOCAL;
        }
    }

    private String pickModuleIdentifier(String module) {
        if (pickedIdentifiers.containsKey(module)) {
            return pickedIdentifiers.get(module);
        }
        for (String id : OpenAPIConstants.MODULE_IDENTIFIER_LIST) {
            if (pickedIdentifiers.containsValue(id)) continue;
            pickedIdentifiers.put(module, id);
            return id;
        }
        return null;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getInvokeStatement() {
        return this.invokeStatement;
    }

    public void setInvokeStatement(String invokeStatement) {
        this.invokeStatement = invokeStatement;
    }

    public String getFqn() {
        return this.fqn;
    }

    public void setFqn(String fqn) {
        this.fqn = fqn;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getImportStatement() {
        return this.importStatement;
    }

    public void setImportStatement(String importStatement) {
        this.importStatement = importStatement;
    }

    public static enum Type {
        JAVA,
        LOCAL,
        CENTRAL;

    }
}

