/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.model.template.service;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.servers.Server;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.exception.CLICompileTimeException;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaOpenAPIObject;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaOperation;

public class BallerinaPath
implements BallerinaOpenAPIObject<BallerinaPath, PathItem> {
    private Set<Map.Entry<String, BallerinaOperation>> operations = new LinkedHashSet<Map.Entry<String, BallerinaOperation>>();
    private boolean generateApiFaultResponses = false;
    private boolean addMethodNotFoundService = false;
    private ArrayList<String> allowedOperations = new ArrayList();
    private String strAllowedOperations;

    @Override
    public BallerinaPath buildContext(PathItem item, ExtendedAPI api) throws BallerinaServiceGenException, CLICompileTimeException {
        AbstractMap.SimpleEntry<String, BallerinaOperation> entry;
        BallerinaOperation operation;
        if (item.getGet() != null) {
            this.setServersToOperationLevel(item.getGet(), item.getServers());
            try {
                operation = new BallerinaOperation().buildContext(item.getGet(), api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under GET resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("get", operation);
            this.operations.add(entry);
            this.allowedOperations.add("GET");
        } else if (this.generateApiFaultResponses) {
            try {
                operation = new BallerinaOperation().buildContextForNotAllowed(api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under GET resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("get", operation);
            this.operations.add(entry);
        }
        if (item.getPut() != null) {
            this.setServersToOperationLevel(item.getPut(), item.getServers());
            try {
                operation = new BallerinaOperation().buildContext(item.getPut(), api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under PUT resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("put", operation);
            this.operations.add(entry);
            this.allowedOperations.add("PUT");
        } else if (this.generateApiFaultResponses) {
            try {
                operation = new BallerinaOperation().buildContextForNotAllowed(api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under PUT resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("put", operation);
            this.operations.add(entry);
        }
        if (item.getPost() != null) {
            this.setServersToOperationLevel(item.getPost(), item.getServers());
            try {
                operation = new BallerinaOperation().buildContext(item.getPost(), api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under POST resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("post", operation);
            this.operations.add(entry);
            this.allowedOperations.add("POST");
        } else if (this.generateApiFaultResponses) {
            try {
                operation = new BallerinaOperation().buildContextForNotAllowed(api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under POST resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("post", operation);
            this.operations.add(entry);
        }
        if (item.getDelete() != null) {
            this.setServersToOperationLevel(item.getDelete(), item.getServers());
            try {
                operation = new BallerinaOperation().buildContext(item.getDelete(), api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under DELETE resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("delete", operation);
            this.operations.add(entry);
            this.allowedOperations.add("DELETE");
        } else if (this.generateApiFaultResponses) {
            try {
                operation = new BallerinaOperation().buildContextForNotAllowed(api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under DELETE resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("delete", operation);
            this.operations.add(entry);
        }
        if (item.getOptions() != null) {
            this.setServersToOperationLevel(item.getOptions(), item.getServers());
            try {
                operation = new BallerinaOperation().buildContext(item.getOptions(), api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under OPTIONS resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("options", operation);
            this.operations.add(entry);
            this.allowedOperations.add("OPTIONS");
        }
        if (item.getHead() != null) {
            this.setServersToOperationLevel(item.getHead(), item.getServers());
            try {
                operation = new BallerinaOperation().buildContext(item.getHead(), api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under HEAD resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("head", operation);
            this.operations.add(entry);
            this.allowedOperations.add("HEAD");
        } else if (this.generateApiFaultResponses) {
            try {
                operation = new BallerinaOperation().buildContextForNotAllowed(api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under HEAD resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("head", operation);
            this.operations.add(entry);
        }
        if (item.getPatch() != null) {
            this.setServersToOperationLevel(item.getPatch(), item.getServers());
            try {
                operation = new BallerinaOperation().buildContext(item.getPatch(), api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under PATCH resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("patch", operation);
            this.operations.add(entry);
            this.allowedOperations.add("PATCH");
        } else if (this.generateApiFaultResponses) {
            try {
                operation = new BallerinaOperation().buildContextForNotAllowed(api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under PATCH resource.\n\t-" + e.getTerminalMsg(), e);
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>("patch", operation);
            this.operations.add(entry);
        }
        String strAllowedOperationsArray = Arrays.toString(this.allowedOperations.toArray());
        this.strAllowedOperations = strAllowedOperationsArray.substring(1, strAllowedOperationsArray.length() - 1);
        return this;
    }

    @Override
    public BallerinaPath buildContext(PathItem item) throws BallerinaServiceGenException, CLICompileTimeException {
        return this.buildContext(item, (ExtendedAPI)null);
    }

    public BallerinaPath buildContext(PathItem item, ExtendedAPI api, Boolean generateApiFaultResponses) throws BallerinaServiceGenException, CLICompileTimeException {
        this.generateApiFaultResponses = generateApiFaultResponses;
        return this.buildContext(item, api);
    }

    public BallerinaPath buildContextForNotFound(ExtendedAPI api) throws BallerinaServiceGenException, CLICompileTimeException {
        String[] supportedOperations;
        for (String supportedOp : supportedOperations = new String[]{"get", "post", "put", "delete", "patch", "head"}) {
            BallerinaOperation operation;
            try {
                operation = new BallerinaOperation().buildContextForNotFound(api);
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("Error while parsing the information under resource.\n\t-" + e.getTerminalMsg(), e);
            }
            AbstractMap.SimpleEntry<String, BallerinaOperation> entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>(supportedOp, operation);
            this.operations.add(entry);
        }
        return this;
    }

    @Override
    public BallerinaPath getDefaultValue() {
        return null;
    }

    public Set<Map.Entry<String, BallerinaOperation>> getOperations() {
        return this.operations;
    }

    private void setServersToOperationLevel(Operation operation, List<Server> pathLevelServers) {
        if (operation.getServers() == null && pathLevelServers != null) {
            operation.setServers(pathLevelServers);
        }
    }

    public boolean isGenerateApiFaultResponses() {
        return this.generateApiFaultResponses;
    }

    public void setGenerateApiFaultResponses(boolean generateApiFaultResponses) {
        this.generateApiFaultResponses = generateApiFaultResponses;
    }

    public boolean isAddMethodNotFoundService() {
        return this.addMethodNotFoundService;
    }

    public void setAddMethodNotFoundService(boolean addMethodNotFoundService) {
        this.addMethodNotFoundService = addMethodNotFoundService;
    }
}

