/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.model.template.GenSrcFile;

public final class CodegenUtils {
    private static final Logger logger = LoggerFactory.getLogger(CodegenUtils.class);
    public static final String ENV = "$env{";

    private CodegenUtils() {
    }

    public static void writeFile(Path filePath, String content) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(filePath.toString(), "UTF-8");
            writer.print(content);
        }
    }

    public static Template compileTemplate(String defaultTemplateDir, String templateName) throws IOException {
        String templatesDirPath = System.getProperty("templates.dir.path", defaultTemplateDir);
        ClassPathTemplateLoader cpTemplateLoader = new ClassPathTemplateLoader(templatesDirPath);
        FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(templatesDirPath);
        cpTemplateLoader.setSuffix(".mustache");
        fileTemplateLoader.setSuffix(".mustache");
        Handlebars handlebars = new Handlebars().with(cpTemplateLoader, fileTemplateLoader);
        handlebars.setStringParams(true);
        handlebars.registerHelpers((Class)StringHelpers.class);
        handlebars.registerHelper("equals", (object, options) -> {
            Object param0 = options.param(0, null);
            if (param0 == null) {
                throw new IllegalArgumentException("found 'null', expected 'string'");
            }
            if (object != null && object.toString().equals(param0.toString())) {
                return options.fn(options.context);
            }
            return options.inverse();
        });
        return handlebars.compile(templateName);
    }

    public static void writeGeneratedSources(List<GenSrcFile> sources, Path srcPath, boolean overwrite) throws IOException {
        for (GenSrcFile file : sources) {
            Path filePath = srcPath.resolve(file.getFileName());
            if (Files.notExists(filePath, new LinkOption[0])) {
                CodegenUtils.writeFile(filePath, file.getContent());
                continue;
            }
            if (!overwrite) continue;
            Files.delete(filePath);
            CodegenUtils.writeFile(filePath, file.getContent());
        }
    }

    public static String trim(String key) {
        if (key == null) {
            return null;
        }
        key = key.replaceAll("(\\{)|(})|(/)", "_");
        key = key.replaceAll("(-)", "_hyphen_");
        key = key.replaceAll("(\\.)", "_dot_");
        if ((key = key.replaceAll("(\\s)", "_space_")).contains("*")) {
            key = key.replaceAll("\\*", UUID.randomUUID().toString().replaceAll("-", "_"));
        }
        return key;
    }

    public static String resolveValue(String variable) {
        if (variable != null && variable.contains(ENV)) {
            String envVariable = (variable = variable.replace(" ", "")).substring(variable.lastIndexOf(ENV) + 5, variable.lastIndexOf("}"));
            String value = System.getenv(envVariable);
            if (value != null) {
                return value;
            }
            logger.warn("Environment variable for keystore password : \"" + envVariable + "\" is not set. Setting the value provided, starting with \"" + ENV + "\"");
        }
        return variable;
    }

    public static String replaceSpecialChars(String originalStr) {
        return originalStr.replace("-", "_hyphen_");
    }

    public static String removeSpecialCharsInPathParameters(String originalPath) {
        String[] pathSeparators;
        String modifiedPath = originalPath;
        for (String item : pathSeparators = originalPath.split("/")) {
            String modifiedItem;
            if (item.startsWith("{") && item.endsWith("}")) {
                modifiedItem = CodegenUtils.replaceSpecialChars(item);
                modifiedPath = modifiedPath.replace(item, modifiedItem);
                continue;
            }
            if (item.indexOf("{") <= 0 || item.indexOf("}") <= 0) continue;
            modifiedItem = item.substring(item.indexOf("{"), item.indexOf("}") + 1);
            modifiedPath = modifiedPath.replace(item, modifiedItem);
        }
        return modifiedPath;
    }
}

