/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import io.swagger.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.constants.OpenAPIConstants;
import org.wso2.apimgt.gateway.cli.exception.CLICompileTimeException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.hashing.HashUtils;
import org.wso2.apimgt.gateway.cli.model.config.APIKey;
import org.wso2.apimgt.gateway.cli.model.config.ApplicationSecurity;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.MgwEndpointConfigDTO;
import org.wso2.apimgt.gateway.cli.model.rest.APICorsConfigurationDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.route.EndpointListRouteDTO;
import org.wso2.apimgt.gateway.cli.model.route.RouteEndpointConfig;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;
import org.wso2.apimgt.gateway.cli.utils.RouteUtils;

public class OpenAPICodegenUtils {
    private static final Logger logger = LoggerFactory.getLogger(OpenAPICodegenUtils.class);
    private static PrintStream outStream = System.out;
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final String openAPISpec2 = "2";
    private static final String openAPISpec3 = "3";
    private static final Map<String, String> basePathMap = new HashMap<String, String>();
    private static Map<String, String> requestInterceptorMap = new HashMap<String, String>();
    private static Map<String, String> responseInterceptorMap = new HashMap<String, String>();
    private static Map<String, String> apiNameVersionMap = new HashMap<String, String>();
    private static List<Map<Object, Object>> endPointReferenceExtensions;
    private static List<String> oauthSecuritySchemaList;
    private static List<String> basicSecuritySchemaList;
    private static Map apiKeySecuritySchemaMap;

    private static JsonNode generateJsonNode(String apiDefinition, boolean isFilePath) {
        try {
            if (isFilePath) {
                return objectMapper.readTree(new File(apiDefinition));
            }
            return objectMapper.readTree(apiDefinition);
        }
        catch (IOException e) {
            throw new CLIRuntimeException("Api Definition cannot be parsed.");
        }
    }

    public static String findSwaggerVersion(String apiDefinition, boolean isFilePath) {
        JsonNode rootNode = OpenAPICodegenUtils.generateJsonNode(apiDefinition, isFilePath);
        if (rootNode.has("swagger") && rootNode.get("swagger").asText().trim().startsWith(openAPISpec2)) {
            return openAPISpec2;
        }
        if (rootNode.has("openapi") && rootNode.get("openapi").asText().trim().startsWith(openAPISpec3)) {
            return openAPISpec3;
        }
        throw new CLIRuntimeException("Error while reading the open API version from file, Check the open API format");
    }

    static String generateSwaggerString(ExtendedAPI api, boolean isExpand) {
        String swaggerVersion = OpenAPICodegenUtils.findSwaggerVersion(api.getApiDefinition(), false);
        RouteEndpointConfig mgwEndpointConfigDTO = null;
        if (isExpand) {
            try {
                mgwEndpointConfigDTO = OpenAPICodegenUtils.getEndpointObjectFromAPI(api);
            }
            catch (MalformedURLException e) {
                throw new CLIRuntimeException("The provided endpoints in the imported API \"" + api.getName() + " : " + api.getVersion() + "\" are invalid.");
            }
            catch (CLICompileTimeException e) {
                throw new CLIRuntimeException("The provided endpoints in the imported API \"" + api.getName() + " : " + api.getVersion() + "\" are invalid.\n\t-" + e.getTerminalMsg(), e);
            }
        }
        switch (swaggerVersion) {
            case "2": {
                Swagger swagger = new SwaggerParser().parse(api.getApiDefinition());
                swagger.getInfo().setTitle(api.getName());
                if (isExpand) {
                    swagger.setVendorExtensions(OpenAPICodegenUtils.getExtensionMap(api, mgwEndpointConfigDTO));
                }
                return Json.pretty(swagger);
            }
            case "3": {
                SwaggerParseResult swaggerParseResult = new OpenAPIV3Parser().readContents(api.getApiDefinition());
                OpenAPI openAPI = swaggerParseResult.getOpenAPI();
                openAPI.getInfo().setTitle(api.getName());
                if (isExpand) {
                    openAPI.extensions(OpenAPICodegenUtils.getExtensionMap(api, mgwEndpointConfigDTO));
                }
                return Yaml.pretty(openAPI);
            }
        }
        throw new CLIRuntimeException("Error: Swagger version is not identified");
    }

    public static String getOpenAPIAsJson(OpenAPI openAPI, String openAPIContent, Path openAPIPath) {
        Json.mapper().registerModule((Module)new JavaTimeModule());
        String jsonOpenAPI = Json.pretty(openAPI);
        Path fileName = openAPIPath.getFileName();
        if (fileName == null) {
            throw new CLIRuntimeException("Error: Couldn't resolve OpenAPI file name.");
        }
        String openAPIVersion = fileName.toString().endsWith("json") ? OpenAPICodegenUtils.findSwaggerVersion(openAPIContent, false) : OpenAPICodegenUtils.findSwaggerVersion(jsonOpenAPI, false);
        switch (openAPIVersion) {
            case "2": {
                Swagger swagger = new SwaggerParser().parse(openAPIContent);
                return Json.pretty(swagger);
            }
            case "3": {
                return jsonOpenAPI;
            }
        }
        throw new CLIRuntimeException("Error: Swagger version is not identified");
    }

    public static String convertYamlToJson(String yaml) throws IOException {
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object obj = yamlReader.readValue(yaml, Object.class);
        ObjectMapper jsonWriter = new ObjectMapper();
        return jsonWriter.writeValueAsString(obj);
    }

    private static Map<String, Object> getExtensionMap(ExtendedAPI api, RouteEndpointConfig mgwEndpointConfigDTO) {
        HashMap<String, Object> extensionsMap = new HashMap<String, Object>();
        String basePath = api.getContext() + "/" + api.getVersion();
        extensionsMap.put("x-wso2-basePath", basePath);
        if (mgwEndpointConfigDTO.getProdEndpointList() != null) {
            extensionsMap.put("x-wso2-production-endpoints", mgwEndpointConfigDTO.getProdEndpointList());
        }
        if (mgwEndpointConfigDTO.getSandboxEndpointList() != null) {
            extensionsMap.put("x-wso2-sandbox-endpoints", mgwEndpointConfigDTO.getSandboxEndpointList());
        }
        if (api.getCorsConfiguration() != null) {
            extensionsMap.put("x-wso2-cors", api.getCorsConfiguration());
        }
        if (api.getAuthorizationHeader() != null) {
            extensionsMap.put("x-wso2-auth-header", api.getAuthorizationHeader());
        }
        if (api.getProvider() != null) {
            extensionsMap.put("x-wso2-owner", api.getProvider());
        }
        return extensionsMap;
    }

    private static RouteEndpointConfig getEndpointObjectFromAPI(ExtendedAPI api) throws MalformedURLException, CLICompileTimeException {
        return RouteUtils.parseEndpointConfig(api.getEndpointConfig(), api.getEndpointSecurity());
    }

    public static ExtendedAPI generateAPIFromOpenAPIDef(OpenAPI openAPI, String openAPIContent) throws IOException {
        ExtendedAPI api = OpenAPICodegenUtils.generateAPIFromOpenAPI(openAPI);
        api.setApiDefinition(openAPIContent);
        return api;
    }

    public static ExtendedAPI generateGrpcAPIFromOpenAPI(OpenAPI openAPI) {
        ExtendedAPI api = OpenAPICodegenUtils.generateAPIFromOpenAPI(openAPI);
        api.setGrpc(true);
        return api;
    }

    private static ExtendedAPI generateAPIFromOpenAPI(OpenAPI openAPI) {
        String apiId = HashUtils.generateAPIId(openAPI.getInfo().getTitle(), openAPI.getInfo().getVersion());
        ExtendedAPI api = new ExtendedAPI();
        api.setId(apiId);
        api.setName(openAPI.getInfo().getTitle());
        api.setVersion(openAPI.getInfo().getVersion());
        OpenAPICodegenUtils.populateTransportSecurity(api, openAPI);
        return api;
    }

    private static void populateTransportSecurity(ExtendedAPI api, OpenAPI openAPI) throws CLIRuntimeException {
        List<String> transports = new ArrayList<String>();
        String mutualSSL = null;
        Map<String, Object> apiDefExtensions = openAPI.getExtensions();
        if (apiDefExtensions.containsKey("x-wso2-mutual-ssl")) {
            if (logger.isDebugEnabled()) {
                logger.debug("x-wso2-mutual-ssl extension found in the API Definition");
            }
            mutualSSL = OpenAPICodegenUtils.validateMutualSSL(apiDefExtensions.get("x-wso2-mutual-ssl"), openAPI);
            api.setMutualSSL(mutualSSL);
        }
        if (apiDefExtensions.containsKey("x-wso2-transports")) {
            if (logger.isDebugEnabled()) {
                logger.debug("x-wso2-transports extension found in the API Definition");
            }
            transports = OpenAPICodegenUtils.validateTransports(apiDefExtensions.get("x-wso2-transports"), mutualSSL, openAPI);
        }
        if (transports.isEmpty()) {
            transports = Arrays.asList("http", "https");
        }
        api.setTransport(transports);
    }

    private static List<String> validateTransports(Object transportExtension, String mutualSSL, OpenAPI openAPI) throws CLIRuntimeException {
        List transports;
        try {
            transports = (List)transportExtension;
        }
        catch (ClassCastException exception) {
            throw new CLIRuntimeException("The API '" + openAPI.getInfo().getTitle() + "' version '" + openAPI.getInfo().getVersion() + "' contains " + "x-wso2-transports" + " extension but failed to match to the required format.");
        }
        for (String transport : transports) {
            if ("http".equalsIgnoreCase(transport) || "https".equalsIgnoreCase(transport)) continue;
            throw new CLIRuntimeException("The API '" + openAPI.getInfo().getTitle() + "' version '" + openAPI.getInfo().getVersion() + "' contains " + "x-wso2-transports" + " extension but only http and https are allowed as transports");
        }
        if ("mandatory".equalsIgnoreCase(mutualSSL) && !transports.contains("https")) {
            transports.add("https");
        }
        return transports;
    }

    private static String validateMutualSSL(Object mutualSSLExtension, OpenAPI openAPI) throws CLIRuntimeException {
        String mutualSSL;
        try {
            mutualSSL = (String)mutualSSLExtension;
        }
        catch (ClassCastException exception) {
            throw new CLIRuntimeException("The API '" + openAPI.getInfo().getTitle() + "' version '" + openAPI.getInfo().getVersion() + "' contains " + "x-wso2-mutual-ssl" + " extension but failed to match to the required format.");
        }
        if (!"mandatory".equalsIgnoreCase(mutualSSL) && !"optional".equalsIgnoreCase(mutualSSL)) {
            throw new CLIRuntimeException("The API '" + openAPI.getInfo().getTitle() + "' version '" + openAPI.getInfo().getVersion() + "' contains " + "x-wso2-mutual-ssl" + " but only optional and mandatory are allowed for mutual SSL");
        }
        return mutualSSL;
    }

    public static void setAdditionalConfigsDevFirst(ExtendedAPI api, OpenAPI openAPI, String openAPIFilePath) {
        Map<String, Object> extensions = openAPI.getExtensions();
        EndpointListRouteDTO prodEndpointListDTO = null;
        try {
            prodEndpointListDTO = OpenAPICodegenUtils.extractEndpointFromOpenAPI(extensions != null ? extensions.get("x-wso2-production-endpoints") : null, openAPI.getServers());
        }
        catch (CLICompileTimeException e) {
            throw new CLIRuntimeException("Error while parsing the openAPI defintion for the API \"" + openAPI.getInfo().getTitle() + " : " + openAPI.getInfo().getVersion() + "\".\n\t-" + e.getTerminalMsg(), e);
        }
        if (prodEndpointListDTO != null && prodEndpointListDTO.getName() == null) {
            prodEndpointListDTO.setName(api.getId());
        }
        EndpointListRouteDTO sandEndpointListDTO = null;
        try {
            sandEndpointListDTO = OpenAPICodegenUtils.extractEndpointFromOpenAPI(extensions != null ? extensions.get("x-wso2-sandbox-endpoints") : null, null);
        }
        catch (CLICompileTimeException e) {
            throw new CLIRuntimeException("Error while parsing the openAPI defintion for the API \"" + openAPI.getInfo().getTitle() + " : " + openAPI.getInfo().getVersion() + "\".\n\t-" + e.getTerminalMsg(), e);
        }
        if (sandEndpointListDTO != null && sandEndpointListDTO.getName() == null) {
            sandEndpointListDTO.setName(api.getId());
        }
        MgwEndpointConfigDTO mgwEndpointConfigDTO = RouteUtils.convertToMgwServiceMap(prodEndpointListDTO, sandEndpointListDTO);
        api.setEndpointConfigRepresentation(mgwEndpointConfigDTO);
        OpenAPICodegenUtils.setMgwAPISecurityAndScopes(api, openAPI);
        api.setSpecificBasepath(OpenAPICodegenUtils.resolveTemplateBasePath(extensions, openAPI.getInfo().getVersion()));
        if (extensions.containsKey("x-wso2-owner")) {
            api.setProvider(extensions.get("x-wso2-owner").toString());
        }
        try {
            Object authHeader;
            if (extensions.get("x-wso2-cors") != null) {
                api.setCorsConfiguration((APICorsConfigurationDTO)objectMapper.convertValue(extensions.get("x-wso2-cors"), APICorsConfigurationDTO.class));
                api.getCorsConfiguration().setCorsConfigurationEnabled(true);
            }
            if ((authHeader = extensions.get("x-wso2-auth-header")) != null) {
                api.setAuthorizationHeader(authHeader.toString());
            }
        }
        catch (IllegalArgumentException e) {
            throw new CLIRuntimeException("'x-wso2-cors' property is not properly set for the openAPI definition file. \n" + openAPIFilePath);
        }
    }

    public static MgwEndpointConfigDTO getResourceEpConfigForCodegen(Operation operation) throws CLICompileTimeException {
        EndpointListRouteDTO sandEndpointListDTO;
        Map<String, Object> extensions = operation.getExtensions();
        EndpointListRouteDTO prodEndpointListDTO = OpenAPICodegenUtils.extractEndpointFromOpenAPI(extensions != null ? operation.getExtensions().get("x-wso2-production-endpoints") : null, operation.getServers());
        if (prodEndpointListDTO != null && prodEndpointListDTO.getName() == null) {
            prodEndpointListDTO.setName(operation.getOperationId());
            prodEndpointListDTO.validateEndpoints();
        }
        if ((sandEndpointListDTO = OpenAPICodegenUtils.extractEndpointFromOpenAPI(extensions != null ? operation.getExtensions().get("x-wso2-sandbox-endpoints") : null, null)) != null && sandEndpointListDTO.getName() == null) {
            sandEndpointListDTO.setName(operation.getOperationId());
            sandEndpointListDTO.validateEndpoints();
        }
        return RouteUtils.convertToMgwServiceMap(prodEndpointListDTO, sandEndpointListDTO);
    }

    private static EndpointListRouteDTO extractEndpointFromOpenAPI(Object endpointExtensionObject, List<Server> servers) throws CLICompileTimeException {
        EndpointListRouteDTO endpointListRouteDTO = null;
        if (endpointExtensionObject != null) {
            String endpointExtensionObjectValue = endpointExtensionObject.toString();
            if (endpointExtensionObjectValue.contains("#/x-wso2-endpoints/")) {
                String referencePath = endpointExtensionObjectValue.split("#/x-wso2-endpoints/")[1];
                for (Map<Object, Object> value : endPointReferenceExtensions) {
                    if (!value.containsKey(referencePath)) continue;
                    try {
                        endpointListRouteDTO = (EndpointListRouteDTO)objectMapper.convertValue(value.get(referencePath), EndpointListRouteDTO.class);
                        endpointListRouteDTO.setName(referencePath);
                        try {
                            endpointListRouteDTO.validateEndpoints();
                        }
                        catch (CLICompileTimeException e) {
                            throw new CLICompileTimeException("The provided endpoint using the reference " + referencePath + " is invalid.\n\t-" + e.getTerminalMsg(), e);
                        }
                        return endpointListRouteDTO;
                    }
                    catch (IllegalArgumentException e) {
                        throw new CLICompileTimeException("Error while parsing the referenced endpoint object " + endpointExtensionObjectValue + ". The endpoint \"" + referencePath + "\" defined under " + "x-wso2-endpoints" + " is incompatible : " + value.get(referencePath).toString(), e);
                    }
                }
                throw new CLICompileTimeException("The referenced endpoint value : \"" + endpointExtensionObjectValue + "\" is not defined under the open API extension " + "x-wso2-endpoints");
            }
            try {
                endpointListRouteDTO = (EndpointListRouteDTO)objectMapper.convertValue(endpointExtensionObject, EndpointListRouteDTO.class);
            }
            catch (IllegalArgumentException e) {
                throw new CLICompileTimeException("Error while parsing the endpoint object. The x-wso2-production-endpoints or x-wso2-sandbox-endpoints format is incompatible : " + endpointExtensionObjectValue, e);
            }
            try {
                endpointListRouteDTO.validateEndpoints();
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("The provided endpoint using the extension x-wso2-production-endpoints or x-wso2-sandbox-endpoints is invalid.\n\t-" + e.getTerminalMsg(), e);
            }
        }
        if (servers != null) {
            endpointListRouteDTO = new EndpointListRouteDTO();
            for (Server server : servers) {
                if (server.getUrl().equals("/") && servers.size() == 1) {
                    return null;
                }
                endpointListRouteDTO.addEndpoint(OpenAPICodegenUtils.replaceOpenAPIServerTemplate(server));
            }
            try {
                endpointListRouteDTO.validateEndpoints();
            }
            catch (CLICompileTimeException e) {
                throw new CLICompileTimeException("The provided endpoint using the \"servers\" object, is invalid.\n\t-" + e.getTerminalMsg(), e);
            }
        }
        return endpointListRouteDTO;
    }

    private static void validateBasePath(OpenAPI openAPI, String openApiFilePath, String openAPIVersion) {
        Server server;
        List<Server> servers = openAPI.getServers();
        Map<String, Object> openAPIExtensions = openAPI.getExtensions();
        String basePath = null;
        if (openAPIExtensions != null && openAPIExtensions.get("x-wso2-basePath") != null) {
            basePath = (String)openAPIExtensions.get("x-wso2-basePath");
        } else if (servers != null && (server = servers.get(0)).getUrl() != null) {
            String url = OpenAPICodegenUtils.replaceOpenAPIServerTemplate(server);
            try {
                basePath = new URI(url).getPath();
            }
            catch (URISyntaxException e) {
                String message = openAPISpec2.equals(openAPIVersion) ? "Scheme, host, base path combination of openAPI '" + openApiFilePath + "' resolves to : " + url + ", which is a malformed url" : "Server url: " + url + " of openAPI '" + openApiFilePath + "' is a malformed url";
                throw new CLIRuntimeException(message);
            }
        }
        if (basePath == null || basePath.isEmpty()) {
            basePath = "/";
            String message = openAPISpec2.equals(openAPIVersion) ? "basePath not found in the open API '" + openApiFilePath + "'. Hence defaults to '/'" : "servers url in the open API '" + openApiFilePath + "' does not adhere to pattern '<scheme>://<host>/<basePath>/'. Hence the base path defaults to '/'";
            outStream.println("WARN: " + message);
        } else {
            String string = basePath = basePath.startsWith("/") ? basePath : "/" + basePath;
            if (basePathMap.containsKey(basePath)) {
                throw new CLIRuntimeException("The derived value for the base path '" + basePath + "'  is duplicated in the following openAPI definitions.\n" + basePathMap.get(basePath) + "\n" + openApiFilePath);
            }
        }
        basePathMap.put(basePath, openApiFilePath);
        openAPI.addExtension("x-wso2-basePath", basePath);
    }

    public static void setInterceptors(String projectName) throws IOException {
        String interceptorsDirectoryPath = CmdUtils.getProjectInterceptorsPath(projectName);
        Files.walk(Paths.get(interceptorsDirectoryPath, new String[0]), new FileVisitOption[0]).filter(path -> {
            Path fileName = path.getFileName();
            return fileName != null && fileName.toString().endsWith(".bal");
        }).forEach(path -> {
            String balSrcCode = null;
            try {
                balSrcCode = CmdUtils.readFileAsString(path.toString(), false);
            }
            catch (IOException e) {
                logger.error("Error occurred while reading interceptors", (Throwable)e);
            }
            OpenAPICodegenUtils.findInterceptors(balSrcCode, path.toString(), true, requestInterceptorMap);
            OpenAPICodegenUtils.findInterceptors(balSrcCode, path.toString(), false, responseInterceptorMap);
        });
    }

    private static void findInterceptors(String balSrcCode, String interceptorFilePath, boolean isRequestInterceptor, Map<String, String> interceptorMap) {
        String matchedString;
        String functionParameter = isRequestInterceptor ? "http:Request" : "http:Response";
        String functionRegex = "function\\s+\\w+\\s*\\(\\s*http:Caller\\s+\\w+\\s*,\\s*" + functionParameter + "\\s+\\w+\\s*\\)";
        String commentFunctionRegex = "//( |\\S)*" + functionRegex;
        Pattern p = Pattern.compile(functionRegex);
        Matcher m = p.matcher(balSrcCode);
        ArrayList<String> functionStringArray = new ArrayList<String>();
        while (m.find()) {
            matchedString = m.group();
            functionStringArray.add(matchedString);
        }
        p = Pattern.compile(commentFunctionRegex);
        m = p.matcher(balSrcCode);
        while (m.find()) {
            matchedString = m.group();
            functionStringArray.stream().filter(matchedString::endsWith).findFirst().ifPresent(functionStringArray::remove);
        }
        functionStringArray.forEach(f -> {
            String functionName = f.replace("(", " ").split(" ")[1];
            if (interceptorMap.containsKey(functionName)) {
                throw new CLIRuntimeException("The function '" + functionName + "' is declared twice in the following files. Please remove one of the.\n" + (String)interceptorMap.get(functionName) + "\n" + interceptorFilePath);
            }
            interceptorMap.put(functionName, interceptorFilePath);
        });
    }

    private static String replaceOpenAPIServerTemplate(Server server) {
        String url = server.getUrl();
        Pattern serverTemplate = Pattern.compile("\\{.*?}");
        Matcher matcher = serverTemplate.matcher(url);
        while (matcher.find()) {
            if (server.getVariables() != null && server.getVariables().containsKey(matcher.group(0).substring(1, matcher.group(0).length() - 1))) {
                String defaultValue = ((ServerVariable)server.getVariables().get(matcher.group(0).substring(1, matcher.group(0).length() - 1))).getDefault();
                url = url.replaceAll("\\" + matcher.group(0), defaultValue);
                continue;
            }
            outStream.println("WARN: Open API server url templating is used for the url : " + url + ". But default values is not provided for the variable '" + matcher.group(0) + "'. Hence correct url will not be resolved during the runtime unless url is overridden during the runtime");
        }
        return url;
    }

    private static void validateInterceptorAvailability(String interceptorName, boolean isRequestInterceptor, String openAPIFilePath, String path, String operation) {
        if (interceptorName == null) {
            return;
        }
        Map<String, String> interceptorMap = isRequestInterceptor ? requestInterceptorMap : responseInterceptorMap;
        if (!interceptorName.startsWith("java:") && !interceptorMap.containsKey(interceptorName)) {
            String errorMsg = "The interceptor '" + interceptorName + "' mentioned in openAPI definition:'" + openAPIFilePath + "' ";
            if (path != null && operation != null) {
                errorMsg = errorMsg + "under path:'" + path + "' operation:'" + operation + "' ";
            }
            errorMsg = errorMsg + "is not available in any function in the interceptors directory.";
            throw new CLIRuntimeException(errorMsg);
        }
    }

    private static void validateResourceExtensionsForSinglePath(OpenAPI openAPI, String openAPIFilePath) {
        openAPI.getPaths().entrySet().forEach(entry -> {
            OpenAPICodegenUtils.validateSingleResourceExtensions(((PathItem)entry.getValue()).getGet(), (String)entry.getKey(), "get", openAPIFilePath);
            OpenAPICodegenUtils.validateSingleResourceExtensions(((PathItem)entry.getValue()).getPost(), (String)entry.getKey(), "post", openAPIFilePath);
            OpenAPICodegenUtils.validateSingleResourceExtensions(((PathItem)entry.getValue()).getPut(), (String)entry.getKey(), "put", openAPIFilePath);
            OpenAPICodegenUtils.validateSingleResourceExtensions(((PathItem)entry.getValue()).getPatch(), (String)entry.getKey(), "patch", openAPIFilePath);
            OpenAPICodegenUtils.validateSingleResourceExtensions(((PathItem)entry.getValue()).getHead(), (String)entry.getKey(), "head", openAPIFilePath);
            OpenAPICodegenUtils.validateSingleResourceExtensions(((PathItem)entry.getValue()).getDelete(), (String)entry.getKey(), "delete", openAPIFilePath);
            OpenAPICodegenUtils.validateSingleResourceExtensions(((PathItem)entry.getValue()).getOptions(), (String)entry.getKey(), "options", openAPIFilePath);
            OpenAPICodegenUtils.validateSingleResourceExtensions(((PathItem)entry.getValue()).getTrace(), (String)entry.getKey(), "trace", openAPIFilePath);
        });
    }

    private static void validateSingleResourceExtensions(Operation operation, String pathItem, String operationName, String openAPIFilePath) {
        if (operation == null || operation.getExtensions() == null) {
            return;
        }
        OpenAPICodegenUtils.validateInterceptors(operation.getExtensions(), pathItem, operationName, openAPIFilePath);
    }

    private static void validateInterceptors(Map<String, Object> extensions, String pathItem, String operationName, String openAPIFilePath) {
        if (extensions != null) {
            Optional<Object> requestInterceptor = Optional.ofNullable(extensions.get("x-wso2-request-interceptor"));
            requestInterceptor.ifPresent(value -> {
                if (!value.toString().contains("/")) {
                    OpenAPICodegenUtils.validateInterceptorAvailability(extensions.get("x-wso2-request-interceptor").toString(), true, openAPIFilePath, pathItem, operationName);
                }
            });
            Optional<Object> responseInterceptor = Optional.ofNullable(extensions.get("x-wso2-response-interceptor"));
            responseInterceptor.ifPresent(value -> {
                if (!value.toString().contains("/")) {
                    OpenAPICodegenUtils.validateInterceptorAvailability(extensions.get("x-wso2-response-interceptor").toString(), false, openAPIFilePath, pathItem, operationName);
                }
            });
        }
    }

    private static void setMgwAPISecurityAndScopes(ExtendedAPI api, OpenAPI openAPI) {
        ApplicationSecurity appSecurityfromDef;
        String[] securitySchemasAndScopes = OpenAPICodegenUtils.generateMgwSecuritySchemasAndScopes(openAPI.getSecurity());
        String securitySchemas = securitySchemasAndScopes[0];
        String scopes = securitySchemasAndScopes[1];
        api.setMgwApiSecurity(securitySchemas);
        api.setMgwApiScope(scopes);
        if (logger.isDebugEnabled()) {
            logger.debug("Getting Application security by the extension for API '" + openAPI.getInfo().getTitle() + "' version '" + openAPI.getInfo().getVersion() + "'");
        }
        api.setApplicationSecurity((appSecurityfromDef = OpenAPICodegenUtils.populateApplicationSecurity(api.getName(), api.getVersion(), openAPI.getExtensions(), api.getMutualSSL())) != null ? appSecurityfromDef : new ApplicationSecurity());
    }

    public static ApplicationSecurity populateApplicationSecurity(String apiName, String version, Map<String, Object> apiDefExtensions, String mutualSSL) {
        ApplicationSecurity appSecurity = null;
        if (apiDefExtensions != null && apiDefExtensions.containsKey("x-wso2-application-security")) {
            if (logger.isDebugEnabled()) {
                logger.debug("x-wso2-application-security extension found in the API '" + apiName + "' version '" + version + "'");
            }
            try {
                appSecurity = (ApplicationSecurity)new ObjectMapper().convertValue(apiDefExtensions.get("x-wso2-application-security"), ApplicationSecurity.class);
            }
            catch (Exception exception) {
                throw new CLIRuntimeException("The API '" + apiName + "' version '" + version + "' contains " + "x-wso2-application-security" + " extension but failed to match " + "security-types" + " to the required format.");
            }
            if (!OpenAPICodegenUtils.validateAppSecurityOptionality(appSecurity, mutualSSL)) {
                throw new CLIRuntimeException("Application security is given as optional but Mutual SSL is not mandatory for the API '" + apiName + "' version '" + version + "'");
            }
        }
        return appSecurity;
    }

    private static boolean validateAppSecurityOptionality(ApplicationSecurity appSecurity, String mutualSSL) {
        return appSecurity.isOptional() == null || appSecurity.isOptional() == false || "mandatory".equalsIgnoreCase(mutualSSL);
    }

    private static String[] generateMgwSecuritySchemasAndScopes(List<SecurityRequirement> securityRequirementList) {
        String securitySchemas = null;
        String scopes = null;
        ArrayList securitySchemaList = new ArrayList(2);
        ArrayList scopeList = new ArrayList();
        if (securityRequirementList != null) {
            securityRequirementList.forEach(value -> value.forEach((k, v) -> {
                if (oauthSecuritySchemaList.contains(k)) {
                    if (!securitySchemaList.contains(OpenAPIConstants.APISecurity.oauth2.name())) {
                        securitySchemaList.add(OpenAPIConstants.APISecurity.oauth2.name());
                    }
                    v.forEach(scope -> {
                        if (!scopeList.contains(scope)) {
                            scopeList.add(scope);
                        }
                    });
                } else if (basicSecuritySchemaList.contains(k) && !securitySchemaList.contains(OpenAPIConstants.APISecurity.basic.name())) {
                    securitySchemaList.add(OpenAPIConstants.APISecurity.basic.name());
                } else if (apiKeySecuritySchemaMap.containsKey(k) && !securitySchemaList.contains(OpenAPIConstants.APISecurity.apikey.name())) {
                    securitySchemaList.add(OpenAPIConstants.APISecurity.apikey.name());
                }
            }));
            StringBuilder secSchemaBuilder = new StringBuilder();
            StringBuilder scopeBuilder = new StringBuilder();
            for (String schema : securitySchemaList) {
                if (secSchemaBuilder.length() == 0) {
                    secSchemaBuilder.append(schema);
                    continue;
                }
                secSchemaBuilder.append(',' + schema);
            }
            for (String scope : scopeList) {
                scope = "\"" + scope + "\"";
                if (scopeBuilder.length() == 0) {
                    scopeBuilder.append(scope);
                    continue;
                }
                scopeBuilder.append(',' + scope);
            }
            securitySchemas = secSchemaBuilder.toString();
            scopes = scopeBuilder.toString();
        }
        return new String[]{securitySchemas, scopes};
    }

    public static List<String> getMgwResourceSecurity(Operation operation, ApplicationSecurity appSecurity) {
        String securitySchemas = OpenAPICodegenUtils.generateMgwSecuritySchemasAndScopes(operation.getSecurity())[0];
        return OpenAPICodegenUtils.getAuthProviders(securitySchemas, appSecurity);
    }

    public static String getMgwResourceScope(Operation operation) {
        return OpenAPICodegenUtils.generateMgwSecuritySchemasAndScopes(operation.getSecurity())[1];
    }

    public static List<APIKey> generateAPIKeysFromSecurity(List<SecurityRequirement> securityRequirementList, boolean isAPIKeyEnabled) {
        ArrayList<APIKey> apiKeys = new ArrayList<APIKey>();
        if (securityRequirementList != null) {
            securityRequirementList.forEach(value -> value.forEach((k, v) -> {
                if (apiKeySecuritySchemaMap.containsKey(k)) {
                    apiKeys.add((APIKey)apiKeySecuritySchemaMap.get(k));
                }
            }));
        }
        if (isAPIKeyEnabled && apiKeys.isEmpty()) {
            apiKeys.add(new APIKey(SecurityScheme.In.HEADER, "apikey"));
            apiKeys.add(new APIKey(SecurityScheme.In.QUERY, "apikey"));
        }
        return apiKeys;
    }

    private static void validateAPINameAndVersion(OpenAPI openAPI, String openAPIFilePath) {
        String apiNameVersion = openAPI.getInfo().getTitle() + ":" + openAPI.getInfo().getVersion();
        if (apiNameVersionMap.containsKey(apiNameVersion)) {
            throw new CLIRuntimeException("The API '" + openAPI.getInfo().getTitle() + "' version '" + openAPI.getInfo().getVersion() + "' is duplicated across multiple openAPI definitions. \n" + apiNameVersionMap.get(apiNameVersion) + "\n" + openAPIFilePath);
        }
        apiNameVersionMap.put(apiNameVersion, openAPIFilePath);
    }

    public static void validateOpenAPIDefinition(OpenAPI openAPI, String openAPIFilePath, String openAPIVersion) {
        OpenAPICodegenUtils.validateAPINameAndVersion(openAPI, openAPIFilePath);
        OpenAPICodegenUtils.validateBasePath(openAPI, openAPIFilePath, openAPIVersion);
        OpenAPICodegenUtils.validateEndpointAvailability(openAPI, openAPIFilePath, openAPIVersion);
        OpenAPICodegenUtils.validateInterceptors(openAPI.getExtensions(), null, null, openAPIFilePath);
        OpenAPICodegenUtils.validateResourceExtensionsForSinglePath(openAPI, openAPIFilePath);
        OpenAPICodegenUtils.setOauthSecuritySchemaList(openAPI);
        OpenAPICodegenUtils.setSecuritySchemaList(openAPI);
        OpenAPICodegenUtils.setOpenAPIDefinitionEndpointReferenceExtensions(openAPI.getExtensions());
    }

    public static void setOauthSecuritySchemaList(OpenAPI openAPI) {
        oauthSecuritySchemaList = new ArrayList<String>();
        if (openAPI.getComponents() == null || openAPI.getComponents().getSecuritySchemes() == null) {
            return;
        }
        openAPI.getComponents().getSecuritySchemes().forEach((key, val) -> {
            if (val.getType() == SecurityScheme.Type.OAUTH2 || val.getType() == SecurityScheme.Type.HTTP && val.getScheme().toLowerCase(Locale.getDefault()).equals("jwt")) {
                oauthSecuritySchemaList.add((String)key);
            }
        });
    }

    public static void setSecuritySchemaList(OpenAPI openAPI) {
        basicSecuritySchemaList = new ArrayList<String>();
        apiKeySecuritySchemaMap = new HashMap();
        if (openAPI.getComponents() == null || openAPI.getComponents().getSecuritySchemes() == null) {
            return;
        }
        openAPI.getComponents().getSecuritySchemes().forEach((key, val) -> {
            if (val.getType() == SecurityScheme.Type.HTTP && val.getScheme().toLowerCase(Locale.getDefault()).equals("basic")) {
                basicSecuritySchemaList.add((String)key);
            } else if (val.getType() == SecurityScheme.Type.APIKEY) {
                APIKey apiKey = new APIKey(val.getIn(), val.getName());
                apiKeySecuritySchemaMap.put(key, apiKey);
            }
        });
    }

    public static void setOpenAPIDefinitionEndpointReferenceExtensions(Map<String, Object> extensions) {
        if (extensions != null && extensions.get("x-wso2-endpoints") != null) {
            try {
                TypeReference<List<Map<Object, Object>>> typeRef1 = new TypeReference<List<Map<Object, Object>>>(){};
                endPointReferenceExtensions = (List)objectMapper.convertValue(extensions.get("x-wso2-endpoints"), (TypeReference)typeRef1);
            }
            catch (IllegalArgumentException e) {
                throw new CLIRuntimeException("Open API \"x-wso2-endpoints\" extension format is wrong : " + e.getMessage(), e);
            }
        }
    }

    private static void validateEndpointAvailability(OpenAPI openAPI, String openAPIFilePath, String openAPIVersion) {
        if (openAPI.getServers() != null && openAPI.getServers().get(0).getUrl() != null) {
            return;
        }
        if (openAPI.getExtensions().get("x-wso2-production-endpoints") != null || openAPI.getExtensions().get("x-wso2-sandbox-endpoints") != null) {
            return;
        }
        boolean epsUnavailableForAll = openAPI.getPaths().entrySet().stream().anyMatch(path -> OpenAPICodegenUtils.isResourceEpUnavailable(((PathItem)path.getValue()).getGet()) || OpenAPICodegenUtils.isResourceEpUnavailable(((PathItem)path.getValue()).getPost()) || OpenAPICodegenUtils.isResourceEpUnavailable(((PathItem)path.getValue()).getPut()) || OpenAPICodegenUtils.isResourceEpUnavailable(((PathItem)path.getValue()).getTrace()) || OpenAPICodegenUtils.isResourceEpUnavailable(((PathItem)path.getValue()).getHead()) || OpenAPICodegenUtils.isResourceEpUnavailable(((PathItem)path.getValue()).getDelete()) || OpenAPICodegenUtils.isResourceEpUnavailable(((PathItem)path.getValue()).getPatch()) || OpenAPICodegenUtils.isResourceEpUnavailable(((PathItem)path.getValue()).getOptions()));
        if (epsUnavailableForAll) {
            String message = openAPISpec2.equals(openAPIVersion) ? "Either open API default attributes 'host' and 'basePath' values or " : "Either open API default attribute 'servers' or ";
            throw new CLIRuntimeException(message + "wso2 specific extensions '" + "x-wso2-production-endpoints" + "' and '" + "x-wso2-sandbox-endpoints" + "' properties are not included under API Level in openAPI definition '" + openAPIFilePath + "'. Please include at least one of them under API Level or provide those properties for all the resources to overcome this issue.");
        }
    }

    private static boolean isResourceEpUnavailable(Operation operation) {
        if (operation != null && operation.getExtensions().get("x-wso2-production-endpoints") == null && operation.getExtensions().get("x-wso2-sandbox-endpoints") == null) {
            return true;
        }
        if (operation != null && operation.getServers() != null && operation.getServers().get(0) != null) {
            return operation.getServers().get(0).getUrl() != null;
        }
        return false;
    }

    public static List<String> getAuthProviders(String schemas, ApplicationSecurity appSecurity) {
        ArrayList<String> authProviders = new ArrayList<String>();
        if (appSecurity != null && !appSecurity.getSecurityTypes().isEmpty()) {
            for (String securityType : appSecurity.getSecurityTypes()) {
                if (!OpenAPIConstants.APPLICATION_LEVEL_SECURITY.containsKey(securityType)) continue;
                OpenAPICodegenUtils.getAuthProvidersForSecurityType(OpenAPIConstants.APPLICATION_LEVEL_SECURITY.get(securityType), authProviders);
            }
        }
        if (authProviders.isEmpty() && schemas != null) {
            String[] schemasArray;
            for (String securityType : schemasArray = schemas.trim().split("\\s*,\\s*")) {
                OpenAPICodegenUtils.getAuthProvidersForSecurityType(securityType, authProviders);
            }
        }
        return authProviders;
    }

    private static void getAuthProvidersForSecurityType(String securityType, List<String> authProviders) {
        if (securityType.equalsIgnoreCase(OpenAPIConstants.APISecurity.basic.name())) {
            if (!authProviders.contains(OpenAPIConstants.APISecurity.basic.name())) {
                authProviders.add(OpenAPIConstants.APISecurity.basic.name());
            }
        } else if (securityType.equalsIgnoreCase(OpenAPIConstants.APISecurity.apikey.name())) {
            if (!authProviders.contains(OpenAPIConstants.APISecurity.apikey.name())) {
                authProviders.add(OpenAPIConstants.APISecurity.apikey.name());
            }
        } else if (securityType.equalsIgnoreCase(OpenAPIConstants.APISecurity.oauth2.name()) && !authProviders.contains(OpenAPIConstants.APISecurity.oauth2.name())) {
            authProviders.add(OpenAPIConstants.APISecurity.oauth2.name());
            authProviders.add(OpenAPIConstants.APISecurity.jwt.name());
        }
    }

    public static void addDefaultAuthProviders(List<String> authProviders) {
        authProviders.add(OpenAPIConstants.APISecurity.oauth2.name());
        authProviders.add(OpenAPIConstants.APISecurity.jwt.name());
    }

    private static String resolveTemplateBasePath(Map<String, Object> extensions, String version) {
        String basePath = extensions.get("x-wso2-basePath").toString();
        return basePath.replace("{version}", version);
    }

    static {
        oauthSecuritySchemaList = new ArrayList<String>();
        basicSecuritySchemaList = new ArrayList<String>();
        apiKeySecuritySchemaMap = new HashMap();
    }
}

