/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;
import org.wso2.apimgt.gateway.cli.utils.ZipUtils;

public class ToolkitLibExtractionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolkitLibExtractionUtils.class);
    private static final PrintStream OUT = System.out;

    public static void extractPlatformAndRuntime() {
        try {
            String libPath = CmdUtils.getCLILibPath();
            String breLibPath = "bre" + File.separator + "lib";
            String platformExtractedPath = CmdUtils.getCLILibPath() + File.separator + "platform";
            ToolkitLibExtractionUtils.extractBallerinaDist(platformExtractedPath, libPath, breLibPath, true);
        }
        catch (IOException e) {
            String message = "Error while unzipping platform while project setup";
            LOGGER.error(message, (Throwable)e);
            throw new CLIInternalException(message);
        }
    }

    private static void extractBallerinaDist(String destination, String libPath, String breLibPath, Boolean isAddToClasspath) throws IOException {
        if (!Files.exists(Paths.get(destination, new String[0]), new LinkOption[0])) {
            OUT.println("Initializing Toolkit...");
            ZipUtils.unzip(destination + ".zip", destination, isAddToClasspath);
            CmdUtils.copyFolder(libPath + File.separator + "gateway" + File.separator + "platform", destination + File.separator + breLibPath);
        }
    }
}

