/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.tests.interceptor;

import org.wso2.micro.gateway.core.utils.CommonUtils;
import org.wso2.micro.gateway.interceptor.Caller;
import org.wso2.micro.gateway.interceptor.Interceptor;
import org.wso2.micro.gateway.interceptor.Request;
import org.wso2.micro.gateway.interceptor.Response;
import org.wso2.micro.gateway.interceptor.Utils;

public class OpenAPIReadInterceptor
implements Interceptor {
    public boolean interceptRequest(Caller caller, Request request) {
        String apiName = Utils.getInvocationContextAttributes().get("api_name").toString();
        String apiVersion = Utils.getInvocationContextAttributes().get("api_version").toString();
        String openAPIString = CommonUtils.getOpenAPI((String)apiName, (String)apiVersion);
        this.respondFromRequest(caller, openAPIString);
        return false;
    }

    public boolean interceptResponse(Caller caller, Response response) {
        return true;
    }

    private void respondFromRequest(Caller caller, String responseString) {
        Response response = new Response();
        response.setTextPayload(responseString);
        caller.respond(response);
    }
}

