/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.tests.interceptor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.micro.gateway.interceptor.Caller;
import org.wso2.micro.gateway.interceptor.Interceptor;
import org.wso2.micro.gateway.interceptor.InterceptorException;
import org.wso2.micro.gateway.interceptor.Request;
import org.wso2.micro.gateway.interceptor.Response;

public class TestInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger((String)"ballerina");
    private String responseString = "";

    public boolean interceptRequest(Caller caller, Request request) {
        this.responseString = "";
        String contentType = request.getHeader("content-type");
        this.appendResponseString(contentType);
        this.appendResponseString(this.getAllHeaders(request));
        this.appendResponseString(request.getRequestPath());
        this.appendResponseString(request.getRequestHttpMethod());
        this.appendResponseString(request.getRequestHttpVersion());
        if (request.getPathParams().size() > 0) {
            this.appendResponseString(request.getPathParams().toString());
        }
        if (request.getMatrixParams("/petstore/v1/pet").size() > 0) {
            this.appendResponseString(request.getMatrixParams("/petstore/v1/pet").toString());
        }
        this.appendResponseString(request.getQueryParams().toString());
        this.appendResponseString(request.getQueryParamValue("test"));
        if ("application/json".equals(contentType)) {
            try {
                if (request.hasHeader("X_JWT")) {
                    this.appendResponseString(request.getJsonArrayPayload().toString());
                } else {
                    this.appendResponseString(request.getJsonPayload().toString());
                }
            }
            catch (InterceptorException e) {
                log.error("Error while getting json payload ", (Throwable)e);
            }
        }
        if ("application/xml".equals(contentType) || "text/xml".equals(contentType)) {
            try {
                this.appendResponseString(request.getXmlPayload().toString());
            }
            catch (InterceptorException e) {
                log.error("Error while getting xml payload ", (Throwable)e);
            }
        }
        if ("application/x-www-form-urlencoded".equals(contentType)) {
            this.appendResponseString(this.getByteChannel(request));
        }
        this.respondFromRequest(caller);
        return false;
    }

    public boolean interceptResponse(Caller caller, Response response) {
        String contentType = response.getHeader("content-type");
        Response response1 = new Response();
        response1.setResponseCode(201L);
        response1.addHeader("test", "value1");
        response1.setHeader("content-type", contentType);
        JSONObject responseObject = new JSONObject();
        responseObject.put("name", (Object)"jon doe");
        responseObject.put("age", (Object)"22");
        responseObject.put("city", (Object)"chicago");
        response1.setJsonPayload(responseObject);
        caller.respond(response1);
        return false;
    }

    public String getAllHeaders(Request request) {
        String[] headers;
        String headerString = "";
        for (String heeader : headers = request.getHeaderNames()) {
            headerString = headerString + heeader + ":";
        }
        return headerString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getByteChannel(Request request) {
        try {
            ByteChannel byteChannel = request.getByteChannel();
            InputStream in = Channels.newInputStream(byteChannel);
            StringBuilder textBuilder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName(StandardCharsets.UTF_8.name())));){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    textBuilder.append((char)c);
                }
                String string = textBuilder.toString();
                return string;
            }
        }
        catch (IOException | InterceptorException e) {
            log.error("Error while reading the the byte channel", e);
            return "";
        }
    }

    public void respondFromRequest(Caller caller) {
        Response response = new Response();
        response.setTextPayload(this.responseString);
        caller.respond(response);
    }

    public void appendResponseString(String response) {
        this.responseString = this.responseString + ":" + response;
    }
}

