/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.tests.jwtgenerator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.wso2.micro.gateway.jwt.generator.AbstractMGWJWTGenerator;

public class TestJWTGenerator
extends AbstractMGWJWTGenerator {
    public TestJWTGenerator(String dialectURI, String signatureAlgorithm, String keyStorePath, String keyStorePassword, String certificateAlias, String privateKeyAlias, int jwtExpiryTime, String[] restrictedClaims, boolean cacheEnabled, int cacheExpiry, String tokenIssuer, String[] tokenAudience) {
        super(dialectURI, signatureAlgorithm, keyStorePath, keyStorePassword, certificateAlias, privateKeyAlias, jwtExpiryTime, restrictedClaims, cacheEnabled, cacheExpiry, tokenIssuer, tokenAudience);
    }

    public Map<String, Object> populateStandardClaims(Map<String, Object> jwtInfo) {
        long currentTime = System.currentTimeMillis();
        long expireIn = currentTime + this.getTTL();
        String dialect = this.getDialectURI();
        HashMap<String, Object> claims = new HashMap<String, Object>();
        HashMap customClaims = (HashMap)jwtInfo.get("customClaims");
        claims.put("iss", this.getTokenIssuer());
        if (this.getTokenAudience().length == 1) {
            claims.put("aud", this.getTokenAudience()[0]);
        } else if (this.getTokenAudience().length != 0) {
            claims.put("aud", this.arrayToJSONArray(this.getTokenAudience()));
        }
        claims.put("jti", UUID.randomUUID().toString());
        claims.put("iat", (int)(currentTime / 1000L));
        claims.put("exp", (int)(expireIn / 1000L));
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)jwtInfo.get("sub")))) {
            claims.put("sub", jwtInfo.get("sub"));
            claims.put(dialect + "/endUser", jwtInfo.get("sub"));
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)customClaims.get("scopes")))) {
            claims.put("scopes", customClaims.get("scopes"));
        }
        return claims;
    }

    public Map<String, Object> populateCustomClaims(Map<String, Object> jwtInfo, ArrayList<String> restrictedClaims) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        for (String key : jwtInfo.keySet()) {
            if (key.equals("customClaims")) {
                Map customClaims = (Map)jwtInfo.get(key);
                for (String subKey : customClaims.keySet()) {
                    if (restrictedClaims.contains(subKey)) continue;
                    claims.put(subKey, customClaims.get(subKey));
                }
                continue;
            }
            if (restrictedClaims.contains(key)) continue;
            claims.put(key, jwtInfo.get(key));
        }
        return claims;
    }
}

