/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.analytics.http.udf;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import java.io.IOException;
import java.net.InetAddress;
import org.wso2.analytics.http.udf.GeoLocationResolverInitializer;
import org.wso2.carbon.analytics.spark.core.udf.CarbonUDF;

public class GeoLocationResolverUDF
implements CarbonUDF {
    public String getCountry(String ipAddress) throws IOException {
        DatabaseReader databaseReader = GeoLocationResolverInitializer.getInstance().getDatabaseReader();
        if (databaseReader != null) {
            InetAddress inetAddress = InetAddress.getByName(ipAddress);
            try {
                String country = databaseReader.country(inetAddress).getCountry().getName();
                if (country != null) {
                    return country;
                }
            }
            catch (GeoIp2Exception e) {
                return null;
            }
        }
        return null;
    }
}

