/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.maxmind.geoip2.GeoIp2Provider;
import com.maxmind.geoip2.JsonInjector;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.AuthenticationException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.exception.HttpException;
import com.maxmind.geoip2.exception.InvalidRequestException;
import com.maxmind.geoip2.exception.OutOfQueriesException;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.InsightsResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebServiceClient
implements GeoIp2Provider {
    private final String host;
    private final List<String> locales;
    private final String licenseKey;
    private final int connectTimeout;
    private final int readTimeout;
    private final HttpTransport testTransport;
    private final int userId;
    private final ObjectMapper mapper;

    private WebServiceClient(Builder builder) {
        this.host = builder.host;
        this.locales = builder.locales;
        this.licenseKey = builder.licenseKey;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.testTransport = builder.testTransport;
        this.userId = builder.userId;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS, false);
    }

    public CountryResponse country() throws IOException, GeoIp2Exception {
        return this.country(null);
    }

    @Override
    public CountryResponse country(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.responseFor("country", ipAddress, CountryResponse.class);
    }

    public CityResponse city() throws IOException, GeoIp2Exception {
        return this.city(null);
    }

    @Override
    public CityResponse city(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.responseFor("city", ipAddress, CityResponse.class);
    }

    public InsightsResponse insights() throws IOException, GeoIp2Exception {
        return this.insights(null);
    }

    public InsightsResponse insights(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.responseFor("insights", ipAddress, InsightsResponse.class);
    }

    private <T> T responseFor(String path, InetAddress ipAddress, Class<T> cls) throws GeoIp2Exception, IOException {
        GenericUrl uri = this.createUri(path, ipAddress);
        HttpResponse response = this.getResponse(uri);
        Long contentLength = response.getHeaders().getContentLength();
        if (contentLength == null || contentLength.intValue() <= 0) {
            throw new HttpException("Received a 200 response for " + uri + " but there was no message body.", 200, uri.toURL());
        }
        String body = WebServiceClient.getSuccessBody(response, uri);
        String ip = ipAddress == null ? null : ipAddress.getHostAddress();
        JsonInjector inject = new JsonInjector(this.locales, ip);
        try {
            return (T)this.mapper.readerFor(cls).with((InjectableValues)inject).readValue(body);
        }
        catch (IOException e) {
            throw new GeoIp2Exception("Received a 200 response but not decode it as JSON: " + body, e);
        }
    }

    private HttpResponse getResponse(GenericUrl uri) throws GeoIp2Exception, IOException {
        HttpRequest request;
        NetHttpTransport transport = this.testTransport == null ? new NetHttpTransport() : this.testTransport;
        HttpRequestFactory requestFactory = transport.createRequestFactory();
        try {
            request = requestFactory.buildGetRequest(uri);
        }
        catch (IOException e) {
            throw new GeoIp2Exception("Error building request", e);
        }
        request.setConnectTimeout(this.connectTimeout);
        request.setReadTimeout(this.readTimeout);
        HttpHeaders headers = request.getHeaders();
        headers.setAccept("application/json");
        headers.setBasicAuthentication(String.valueOf(this.userId), this.licenseKey);
        headers.setUserAgent("GeoIP2 Java Client v" + this.getClass().getPackage().getImplementationVersion() + ";");
        try {
            return request.execute();
        }
        catch (HttpResponseException e) {
            int status = e.getStatusCode();
            if (status >= 400 && status < 500) {
                WebServiceClient.handle4xxStatus(e.getContent(), status, uri);
            } else if (status >= 500 && status < 600) {
                throw new HttpException("Received a server error (" + status + ") for " + uri, status, uri.toURL());
            }
            throw new HttpException("Received a very surprising HTTP status (" + status + ") for " + uri, status, uri.toURL());
        }
    }

    private static String getSuccessBody(HttpResponse response, GenericUrl uri) throws GeoIp2Exception {
        String body;
        try {
            body = response.parseAsString();
        }
        catch (IOException e) {
            throw new GeoIp2Exception("Received a 200 response but not decode message body: " + e.getMessage());
        }
        if (response.getContentType() == null || !response.getContentType().contains("json")) {
            throw new GeoIp2Exception("Received a 200 response for " + uri + " but it does not appear to be JSON:\n" + body);
        }
        return body;
    }

    private static void handle4xxStatus(String body, int status, GenericUrl uri) throws GeoIp2Exception, HttpException {
        if (body == null) {
            throw new HttpException("Received a " + status + " error for " + uri + " with no body", status, uri.toURL());
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map content = (Map)mapper.readValue(body, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            WebServiceClient.handleErrorWithJsonBody(content, body, status, uri);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HttpException("Received a " + status + " error for " + uri + " but it did not include the expected JSON body: " + body, status, uri.toURL());
        }
    }

    private static void handleErrorWithJsonBody(Map<String, String> content, String body, int status, GenericUrl uri) throws GeoIp2Exception, HttpException {
        String error = content.get("error");
        String code = content.get("code");
        if (error == null || code == null) {
            throw new HttpException("Response contains JSON but it does not specify code or error keys: " + body, status, uri.toURL());
        }
        if (code.equals("IP_ADDRESS_NOT_FOUND") || code.equals("IP_ADDRESS_RESERVED")) {
            throw new AddressNotFoundException(error);
        }
        if (code.equals("AUTHORIZATION_INVALID") || code.equals("LICENSE_KEY_REQUIRED") || code.equals("USER_ID_REQUIRED")) {
            throw new AuthenticationException(error);
        }
        if (code.equals("OUT_OF_QUERIES")) {
            throw new OutOfQueriesException(error);
        }
        throw new InvalidRequestException(error, code, uri.toURL());
    }

    private GenericUrl createUri(String path, InetAddress ipAddress) {
        return new GenericUrl("https://" + this.host + "/geoip/v2.1/" + path + "/" + (ipAddress == null ? "me" : ipAddress.getHostAddress()));
    }

    public static final class Builder {
        final int userId;
        final String licenseKey;
        String host = "geoip.maxmind.com";
        List<String> locales = Collections.singletonList("en");
        int connectTimeout = 3000;
        int readTimeout = 20000;
        HttpTransport testTransport;

        public Builder(int userId, String licenseKey) {
            this.userId = userId;
            this.licenseKey = licenseKey;
        }

        public Builder connectTimeout(int val) {
            this.connectTimeout = val;
            return this;
        }

        public Builder host(String val) {
            this.host = val;
            return this;
        }

        public Builder locales(List<String> val) {
            this.locales = val;
            return this;
        }

        public Builder readTimeout(int val) {
            this.readTimeout = val;
            return this;
        }

        Builder testTransport(HttpTransport val) {
            this.testTransport = val;
            return this;
        }

        public WebServiceClient build() {
            return new WebServiceClient(this);
        }
    }
}

