/*
 * Copyright (c) 2016, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.wso2.analytics.http.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.wso2.analytics.http.udf.GeoLocationResolverUDF;
import org.wso2.analytics.http.udf.UserAgentResolverUDF;
import org.wso2.carbon.analytics.spark.core.udf.CarbonUDF;

public class AnalyticsHTTPBundleActivator implements BundleActivator {

    private static final Log log = LogFactory.getLog(AnalyticsHTTPBundleActivator.class);

    @Override
    public void start(BundleContext bundleContext) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Starting analytics http Bundle");
        }

        try {
            bundleContext.registerService(CarbonUDF.class, new UserAgentResolverUDF(), null);
            bundleContext.registerService(CarbonUDF.class, new GeoLocationResolverUDF(), null);
        } catch (Throwable e) {
            log.error("Error in starting analytics http bundle: " + e.getMessage(), e);
        }
    }

    @Override
    public void stop(BundleContext bundleContext) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Stopping analytics http component");
        }
    }
}
