/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.analytics.http.udf;

import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.CarbonUtils;

public class GeoLocationResolverInitializer {
    private static final Log log = LogFactory.getLog(GeoLocationResolverInitializer.class);
    private static final String GEOLITE2_COUNTRY_DB_FILENAME = "GeoLite2-Country.mmdb";
    private static GeoLocationResolverInitializer geoLocationResolverInitializer = new GeoLocationResolverInitializer();
    private static DatabaseReader databaseReader;

    private GeoLocationResolverInitializer() {
        Path geolite2DBPath = Paths.get(CarbonUtils.getCarbonHome(), "repository", "resources", GEOLITE2_COUNTRY_DB_FILENAME);
        if (Files.exists(geolite2DBPath, new LinkOption[0])) {
            try {
                databaseReader = new DatabaseReader.Builder(geolite2DBPath.toFile()).withCache((NodeCache)new CHMCache()).build();
            }
            catch (IOException e) {
                log.warn((Object)"Couldn't read repository/resources/GeoLite2-Country.mmdb");
            }
        } else {
            log.warn((Object)"Couldn't find GeoLite2-Country.mmdb file in repository/resources/");
        }
    }

    public static GeoLocationResolverInitializer getInstance() {
        return geoLocationResolverInitializer;
    }

    public DatabaseReader getDatabaseReader() {
        return databaseReader;
    }
}

