/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.analytics.is.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.analytics.is.internal.ServiceReferenceHolder;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileUtil;

public class TemplateManagerInitializer {
    public static final String SPARK_SCRIPT_REGISTRY_PATH = "/repository/components/org.wso2.carbon.analytics.spark";
    public static final String TEMPLATE_CONFIGS_REGISTRY_PATH = "/repository/components/org.wso2.carbon.event.template.manager.core/template-config/ISAnalytics";
    private static final Log log = LogFactory.getLog(TemplateManagerInitializer.class);

    public static void addTemplateConfigs() {
        String templateConfigDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "template-manager" + File.separator + "templateconfigs";
        TemplateManagerInitializer.addInitialConfigs(templateConfigDir, ".xml", TEMPLATE_CONFIGS_REGISTRY_PATH);
    }

    public static void addSparkConfigs() {
        String sparkConfigDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "template-manager" + File.separator + "sparktemplates";
        TemplateManagerInitializer.addInitialConfigs(sparkConfigDir, ".xml", SPARK_SCRIPT_REGISTRY_PATH);
    }

    private static void addInitialConfigs(String srcConfigDir, final String srcFileExtension, String registryDestCollectionPath) {
        File file = new File(srcConfigDir);
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(srcFileExtension);
            }
        };
        String[] initialConfigPaths = file.list(filenameFilter);
        if (initialConfigPaths == null || initialConfigPaths.length == 0) {
            log.info((Object)"No configurations Found.");
            return;
        }
        RegistryService registryService = ServiceReferenceHolder.getRegistryService();
        UserRegistry configRegistry = null;
        try {
            configRegistry = registryService.getConfigSystemRegistry();
            if (!configRegistry.resourceExists(registryDestCollectionPath)) {
                configRegistry.put(registryDestCollectionPath, (Resource)configRegistry.newCollection());
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Failed to get registry", (Throwable)e);
            return;
        }
        for (String configPath : initialConfigPaths) {
            String msg;
            String resourcePath = registryDestCollectionPath + "/" + configPath;
            try {
                if (configRegistry.resourceExists(resourcePath)) {
                    return;
                }
                String configContent = FileUtil.readFileToString((String)(srcConfigDir + File.separator + configPath));
                Resource resource = configRegistry.newResource();
                resource.setContent((Object)configContent.getBytes(Charset.defaultCharset()));
                configRegistry.put(resourcePath, resource);
            }
            catch (IOException e) {
                msg = "Failed to read rxt files";
                log.error((Object)msg, (Throwable)e);
            }
            catch (RegistryException e) {
                msg = "Failed to add rxt to registry ";
                log.error((Object)msg, (Throwable)e);
            }
        }
    }
}

