/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.analytics.is.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.analytics.is.internal.ServiceReferenceHolder;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsPersistenceException;
import org.wso2.carbon.analytics.spark.core.internal.AnalyticsPersistenceManager;
import org.wso2.carbon.analytics.spark.core.util.AnalyticsScript;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileUtil;

public class TemplateManagerInitializer {
    public static final String TEMPLATE_CONFIGS_REGISTRY_PATH = "/repository/components/org.wso2.carbon.event.template.manager.core/template-config/ISAnalytics";
    public static final String OVERWRITE_TEMPLATE_MANAGER_VAR = "overwriteTemplateManager";
    private static final Log log = LogFactory.getLog(TemplateManagerInitializer.class);

    public static void addTemplateConfigs() {
        String templateConfigDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "template-manager" + File.separator + "templateconfigs";
        TemplateManagerInitializer.addInitialConfigs(templateConfigDir, ".xml", TEMPLATE_CONFIGS_REGISTRY_PATH);
    }

    public static void addSparkConfigs() {
        String sparkConfigDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "template-manager" + File.separator + "sparktemplates";
        String[] initialConfigPaths = TemplateManagerInitializer.getFileNames(sparkConfigDir, ".xml");
        if ((initialConfigPaths == null || initialConfigPaths.length == 0) && log.isDebugEnabled()) {
            log.debug((Object)"No Spark Templates Found.");
        }
        String overwrite = System.getProperty(OVERWRITE_TEMPLATE_MANAGER_VAR);
        for (String path : initialConfigPaths) {
            TemplateManagerInitializer.deploy(sparkConfigDir + File.separator + path, "", overwrite == null ? null : overwrite.trim());
        }
    }

    private static void addInitialConfigs(String srcConfigDir, String srcFileExtension, String registryDestCollectionPath) {
        UserRegistry configRegistry;
        String[] initialConfigPaths = TemplateManagerInitializer.getFileNames(srcConfigDir, srcFileExtension);
        if ((initialConfigPaths == null || initialConfigPaths.length == 0) && log.isDebugEnabled()) {
            log.debug((Object)"No configurations Found.");
        }
        RegistryService registryService = ServiceReferenceHolder.getRegistryService();
        try {
            configRegistry = registryService.getConfigSystemRegistry();
            if (!configRegistry.resourceExists(registryDestCollectionPath)) {
                configRegistry.put(registryDestCollectionPath, (Resource)configRegistry.newCollection());
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Failed to get registry.", (Throwable)e);
            return;
        }
        for (String configPath : initialConfigPaths) {
            String msg;
            String resourcePath = registryDestCollectionPath + "/" + configPath;
            try {
                if (configRegistry.resourceExists(resourcePath)) {
                    String overwrite = System.getProperty(OVERWRITE_TEMPLATE_MANAGER_VAR);
                    if ("true".equalsIgnoreCase(overwrite.trim())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"TemplateManager will overwrite since it is selected!");
                        }
                    } else {
                        return;
                    }
                }
                String configContent = FileUtil.readFileToString((String)(srcConfigDir + File.separator + configPath));
                Resource resource = configRegistry.newResource();
                resource.setContent((Object)configContent.getBytes(Charset.defaultCharset()));
                configRegistry.put(resourcePath, resource);
            }
            catch (IOException e) {
                msg = "Failed to read template file: " + configPath;
                log.error((Object)msg, (Throwable)e);
            }
            catch (RegistryException e) {
                msg = String.format("Failed to add template [ %s ] to registry.", configPath);
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    private static String[] getFileNames(String srcConfigDir, final String srcFileExtension) {
        File file = new File(srcConfigDir);
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(srcFileExtension);
            }
        };
        return file.list(filenameFilter);
    }

    private static void deploy(String scriptFilePath, String carbonAppName, String shouldOverwrite) {
        File deploymentFileData = new File(scriptFilePath);
        try {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deploying default templated spark script: " + deploymentFileData.getName() + " for tenant : " + tenantId));
            }
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AnalyticsScript.class});
            Unmarshaller un = context.createUnmarshaller();
            AnalyticsScript script = (AnalyticsScript)un.unmarshal(deploymentFileData);
            script.setName(TemplateManagerInitializer.getScriptName(deploymentFileData.getName()));
            if (Boolean.parseBoolean(shouldOverwrite)) {
                AnalyticsPersistenceManager.getInstance().putScript(tenantId, script.getName(), script.getScriptContent(), script.getCronExpression(), carbonAppName, false);
            } else {
                try {
                    AnalyticsPersistenceManager.getInstance().saveScript(tenantId, script.getName(), script.getScriptContent(), script.getCronExpression(), carbonAppName, false);
                }
                catch (AnalyticsPersistenceException ignore) {}
            }
        }
        catch (JAXBException e) {
            String errorMsg = "Error while reading the analytics script : " + deploymentFileData.getAbsolutePath();
            log.error((Object)errorMsg, (Throwable)e);
        }
        catch (AnalyticsPersistenceException e) {
            String errorMsg = "Error while storing the script : " + deploymentFileData.getAbsolutePath();
            log.error((Object)errorMsg);
        }
    }

    private static String getScriptName(String filePath) throws AnalyticsPersistenceException {
        String fileName = new File(filePath).getName();
        if (fileName.endsWith("xml")) {
            return fileName.substring(0, fileName.length() - ("xml".length() + ".".length()));
        }
        return fileName;
    }
}

