/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.analytics.is.siddhi.extension;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class JsonFlatMapEventDuplicatorStreamProcessor
extends StreamProcessor {
    private VariableExpressionExecutor expressionExecutor;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.executionPlanContext = executionPlanContext;
        if (attributeExpressionExecutors.length != 1) throw new ExecutionPlanValidationException("Json Flat Map Event Duplicator stream Processor should only have one parameter (<string> jsonString) but found " + attributeExpressionExecutors.length + " input attributes");
        if (!(attributeExpressionExecutors[0] instanceof VariableExpressionExecutor)) throw new ExecutionPlanValidationException("Event duplicate stream Processor 1st parameter needs to be dynamic variable but found a constant attribute " + attributeExpressionExecutors[0].getClass().getCanonicalName());
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Json Flat Map Event Duplicator stream Processor 1st attribute should be String, but found " + attributeExpressionExecutors[0].getReturnType());
        }
        this.expressionExecutor = (VariableExpressionExecutor)attributeExpressionExecutors[0];
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        attributeList.add(new Attribute("key", Attribute.Type.STRING));
        attributeList.add(new Attribute("value", Attribute.Type.STRING));
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        ComplexEventChunk newStreamEventChunk = new ComplexEventChunk(false);
        JsonFlatMapEventDuplicatorStreamProcessor jsonFlatMapEventDuplicatorStreamProcessor = this;
        // MONITORENTER : jsonFlatMapEventDuplicatorStreamProcessor
        block2: while (true) {
            if (!streamEventChunk.hasNext()) {
                // MONITOREXIT : jsonFlatMapEventDuplicatorStreamProcessor
                if (newStreamEventChunk.getFirst() == null) return;
                nextProcessor.process(newStreamEventChunk);
                return;
            }
            StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
            String jsonString = (String)this.expressionExecutor.execute((ComplexEvent)streamEvent);
            if (StringUtils.isNotBlank((String)jsonString)) {
                Map map = (Map)new Gson().fromJson(jsonString, new TypeToken<Map<String, String>>(){}.getType());
                Iterator iterator = map.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    Map.Entry entry = iterator.next();
                    StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                    complexEventPopulater.populateComplexEvent((ComplexEvent)clonedEvent, new Object[]{entry.getKey(), entry.getValue()});
                    newStreamEventChunk.add((ComplexEvent)clonedEvent);
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)"Ignored creating events from empty JSON string");
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

