/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.analytics.is.siddhi.extension;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class EventDuplicateStreamProcessor
extends StreamProcessor {
    private VariableExpressionExecutor expressionExecutor;
    private String delimiter = ",";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.executionPlanContext = executionPlanContext;
        if (attributeExpressionExecutors.length == 1) {
            if (!(attributeExpressionExecutors[0] instanceof VariableExpressionExecutor)) throw new ExecutionPlanValidationException("Event duplicate stream Processor 1st parameter needs to be dynamic variable but found a constant attribute " + attributeExpressionExecutors[0].getClass().getCanonicalName());
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) throw new ExecutionPlanValidationException(" Event Duplicate stream Processor 1st parameter attribute should be String, but found " + attributeExpressionExecutors[0].getReturnType());
            this.expressionExecutor = (VariableExpressionExecutor)attributeExpressionExecutors[0];
        } else {
            if (attributeExpressionExecutors.length != 2) throw new ExecutionPlanValidationException("Event Duplicate stream Processor should only have one/two parameter (<string> rolesCommaSeparated (and <string> delimiter), but found " + attributeExpressionExecutors.length + " input attributes");
            if (!(attributeExpressionExecutors[0] instanceof VariableExpressionExecutor)) throw new ExecutionPlanValidationException("Event duplicate stream Processor 1st parameter needs to be dynamic variable but found a constant attribute " + attributeExpressionExecutors[0].getClass().getCanonicalName());
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException(" Event Duplicate stream Processor 1st parameter attribute should be String, but found " + attributeExpressionExecutors[0].getReturnType());
            }
            this.expressionExecutor = (VariableExpressionExecutor)attributeExpressionExecutors[0];
            if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) throw new ExecutionPlanValidationException("Event duplicate stream Processor 2nd parameter needs to be constant attribute but found a dynamic attribute " + attributeExpressionExecutors[1].getClass().getCanonicalName());
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) throw new ExecutionPlanValidationException("Event duplicate stream Processor 2nd parameter attribute should be string, but found " + attributeExpressionExecutors[1].getReturnType());
            this.delimiter = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue();
        }
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        attributeList.add(new Attribute("role", Attribute.Type.STRING));
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        ComplexEventChunk newStreamEventChunk = new ComplexEventChunk(false);
        EventDuplicateStreamProcessor eventDuplicateStreamProcessor = this;
        synchronized (eventDuplicateStreamProcessor) {
            while (streamEventChunk.hasNext()) {
                String[] roles;
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                String rolesCommaSeparated = (String)this.expressionExecutor.execute((ComplexEvent)streamEvent);
                for (String role : roles = rolesCommaSeparated.split(this.delimiter)) {
                    StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                    complexEventPopulater.populateComplexEvent((ComplexEvent)clonedEvent, new Object[]{role});
                    newStreamEventChunk.add((ComplexEvent)clonedEvent);
                }
            }
        }
        if (newStreamEventChunk.getFirst() != null) {
            nextProcessor.process(newStreamEventChunk);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

