/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.country;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="country", namespace="find", description="Returns the country of the given user location.", parameters={@Parameter(name="input.string", description="The input string to derive the country.", type={DataType.STRING})}, returnAttributes={@ReturnAttribute(description="Outputs the country of the location provided.", type={DataType.STRING})}, examples={@Example(description="This outputs the country of the provided location. In this scenario, the output is 'India' .", syntax="country(\"New Delhi, India\")")})
public class CountryFunction
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(CountryFunction.class);
    private Attribute.Type returnType = Attribute.Type.STRING;
    private List<String> countryList = new ArrayList<String>();

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to find:country() function. Required 1. Found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for find:country() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[0].getReturnType());
        }
        InputStream inputStream = CountryFunction.class.getResourceAsStream("/Countries.csv");
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                this.countryList.add(line);
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("File is not found : " + e.getMessage()));
        }
        catch (IOException e) {
            log.error((Object)("Error occurred while reading file : " + e.getMessage()));
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        if (data == null) {
            throw new SiddhiAppRuntimeException("Invalid input given to find:length() function. The argument cannot be null");
        }
        for (String country : this.countryList) {
            String[] location = data.toString().split("[ ,-]");
            String[] countryValues = country.split(",");
            for (int i = 0; i < location.length; ++i) {
                for (int j = 0; j < countryValues.length; ++j) {
                    if (!location[i].trim().equalsIgnoreCase(countryValues[j])) continue;
                    return countryValues[0];
                }
            }
        }
        return "undefined";
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }
}

