/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.deploy;

import akka.serialization.Serialization;
import akka.serialization.Serializer;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.deploy.master.PersistenceEngine;
import org.wso2.carbon.analytics.dataservice.commons.AnalyticsDataResponse;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsDataService;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsServiceHolder;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsIterator;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.reflect.ClassTag;

public class AnalyticsPersistenceEngine
extends PersistenceEngine {
    private static final Log log = LogFactory.getLog(AnalyticsPersistenceEngine.class);
    private Serialization serialization;
    private AnalyticsDataService ads;
    private static final String SPARK_META_TABLE = "__spark_meta_table";
    private static final String OBJ_COLUMN = "obj_col";
    private int SPARK_TENANT = -5000;

    public AnalyticsPersistenceEngine(Serialization serialization) {
        this.serialization = serialization;
        this.ads = AnalyticsServiceHolder.getAnalyticsDataService();
    }

    public void persist(String name, Object obj) {
        Serializer serializer = this.serialization.findSerializerFor(obj);
        byte[] serialized = serializer.toBinary(obj);
        try {
            if (!this.ads.tableExists(this.SPARK_TENANT, SPARK_META_TABLE)) {
                this.ads.createTable(this.SPARK_TENANT, SPARK_META_TABLE);
            }
            HashMap<String, byte[]> values = new HashMap<String, byte[]>(1);
            values.put(OBJ_COLUMN, serialized);
            Record record = new Record(name, this.SPARK_TENANT, SPARK_META_TABLE, values);
            ArrayList<Record> records = new ArrayList<Record>(1);
            records.add(record);
            this.ads.put(records);
        }
        catch (AnalyticsException e) {
            String msg = "Error in writing data to spark meta table: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public void unpersist(String name) {
        try {
            ArrayList<String> recordIds = new ArrayList<String>(1);
            recordIds.add(name);
            this.ads.delete(this.SPARK_TENANT, SPARK_META_TABLE, recordIds);
        }
        catch (AnalyticsException e) {
            String msg = "Error in deleting data from spark meta table: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public <T> Seq<T> read(String prefix, ClassTag<T> evidence$1) {
        Class clazz = evidence$1.runtimeClass();
        Serializer serializer = this.serialization.findSerializerFor((Object)clazz);
        ArrayList<Object> objects = new ArrayList<Object>();
        try {
            if (this.ads.tableExists(this.SPARK_TENANT, SPARK_META_TABLE)) {
                AnalyticsDataResponse results = this.ads.get(this.SPARK_TENANT, SPARK_META_TABLE, 1, null, Long.MIN_VALUE, Long.MAX_VALUE, 0, -1);
                for (AnalyticsDataResponse.Entry entry : results.getEntries()) {
                    AnalyticsIterator iterator = this.ads.readRecords(entry.getRecordStoreName(), entry.getRecordGroup());
                    while (iterator.hasNext()) {
                        Record record = (Record)iterator.next();
                        if (!record.getId().startsWith(prefix)) continue;
                        objects.add(serializer.fromBinary((byte[])record.getValue(OBJ_COLUMN), clazz));
                    }
                }
            }
        }
        catch (AnalyticsException e) {
            String msg = "Error in reading data from spark meta table: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        return JavaConversions.asScalaBuffer(objects).toSeq();
    }
}

