/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.spark.api.java.JavaSparkContext;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsDataService;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsServiceHolder;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.spark.core.AnalyticsProcessorService;
import org.wso2.carbon.analytics.spark.core.internal.SparkAnalyticsExecutor;
import org.wso2.carbon.analytics.spark.core.sources.AnalyticsIncrementalMetaStore;
import org.wso2.carbon.analytics.spark.core.udf.CarbonUDF;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ServiceHolder {
    private static TaskService taskService;
    private static AnalyticsDataService analyticsDataService;
    private static AnalyticsProcessorService analyticsProcessorService;
    private static RegistryService registryService;
    private static TenantRegistryLoader tenantRegistryLoader;
    private static SparkAnalyticsExecutor analyticskExecutor;
    private static Map<String, CarbonUDF> carbonUDFs;
    private static boolean analyticsExecutionEnabled;
    private static boolean analyticsEngineEnabled;
    private static boolean analyticsSparkContextEnabled;
    private static boolean analyticsStatsEnabled;
    private static AnalyticsIncrementalMetaStore incrementalMetaStore;
    private static JavaSparkContext javaSparkContext;

    private ServiceHolder() {
    }

    public static void setTaskService(TaskService taskService) {
        ServiceHolder.taskService = taskService;
    }

    public static TaskService getTaskService() {
        return taskService;
    }

    public static TaskManager getTaskManager() throws TaskException {
        return taskService.getTaskManager("ANALYTICS_SPARK");
    }

    public static AnalyticsDataService getAnalyticsDataService() {
        if (analyticsDataService == null) {
            analyticsDataService = AnalyticsServiceHolder.getAnalyticsDataService();
        }
        return analyticsDataService;
    }

    public static void setAnalyticsDataService(AnalyticsDataService analyticsDataService) {
        ServiceHolder.analyticsDataService = analyticsDataService;
    }

    public static AnalyticsProcessorService getAnalyticsProcessorService() {
        return analyticsProcessorService;
    }

    public static void setAnalyticsProcessorService(AnalyticsProcessorService analyticsProcessorService) {
        ServiceHolder.analyticsProcessorService = analyticsProcessorService;
    }

    public static void setRegistryService(RegistryService registryService) {
        ServiceHolder.registryService = registryService;
    }

    public static void setTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        ServiceHolder.tenantRegistryLoader = tenantRegistryLoader;
    }

    public static UserRegistry getTenantConfigRegistry(int tenantId) throws RegistryException {
        if (tenantId == -1234) {
            return registryService.getConfigSystemRegistry();
        }
        tenantRegistryLoader.loadTenantRegistry(tenantId);
        return registryService.getConfigSystemRegistry(tenantId);
    }

    public static SparkAnalyticsExecutor getAnalyticskExecutor() {
        return analyticskExecutor;
    }

    public static void setAnalyticskExecutor(SparkAnalyticsExecutor analyticskExecutor) {
        ServiceHolder.analyticskExecutor = analyticskExecutor;
    }

    public static boolean isAnalyticsExecutionEnabled() {
        return analyticsExecutionEnabled;
    }

    public static void setAnalyticsExecutionEnabled(boolean analyticsExecutionEnabled) {
        ServiceHolder.analyticsExecutionEnabled = analyticsExecutionEnabled;
    }

    public static boolean isAnalyticsEngineEnabled() {
        return analyticsEngineEnabled;
    }

    public static void setAnalyticsEngineEnabled(boolean analyticsEngineEnabled) {
        ServiceHolder.analyticsEngineEnabled = analyticsEngineEnabled;
    }

    public static void setAnalyticsSparkContextEnabled(boolean analyticsSparkContextEnabled) {
        ServiceHolder.analyticsSparkContextEnabled = analyticsSparkContextEnabled;
    }

    public static boolean isAnalyticsSparkContextEnabled() {
        return analyticsSparkContextEnabled;
    }

    public static boolean isAnalyticsStatsEnabled() {
        return analyticsStatsEnabled;
    }

    public static void setAnalyticsStatsEnabled(boolean analyticsStatsEnabled) {
        ServiceHolder.analyticsStatsEnabled = analyticsStatsEnabled;
    }

    public static void addCarbonUDFs(CarbonUDF carbonUDF) {
        carbonUDFs.put(carbonUDF.getClass().getName(), carbonUDF);
    }

    public static void removeCarbonUDFs() {
        carbonUDFs = null;
    }

    public static Map<String, CarbonUDF> getCarbonUDFs() {
        return carbonUDFs;
    }

    public static AnalyticsIncrementalMetaStore getIncrementalMetaStore() {
        if (incrementalMetaStore == null) {
            try {
                incrementalMetaStore = new AnalyticsIncrementalMetaStore();
            }
            catch (AnalyticsException e) {
                throw new RuntimeException("Error in creating analytics incremental metastore: " + e.getMessage(), e);
            }
        }
        return incrementalMetaStore;
    }

    public static JavaSparkContext getJavaSparkContext() {
        return javaSparkContext;
    }

    public static void setJavaSparkContext(JavaSparkContext javaSparkContext) {
        ServiceHolder.javaSparkContext = javaSparkContext;
    }

    static {
        carbonUDFs = new HashMap<String, CarbonUDF>();
        analyticsExecutionEnabled = true;
        analyticsEngineEnabled = true;
        analyticsSparkContextEnabled = true;
        analyticsStatsEnabled = false;
    }
}

