/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsExecutionException;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsPersistenceException;
import org.wso2.carbon.analytics.spark.core.internal.ServiceHolder;
import org.wso2.carbon.analytics.spark.core.internal.jmx.AnalyticsScriptLastExecutionStartTimeHolder;
import org.wso2.carbon.ntask.core.Task;

public class AnalyticsTask
implements Task {
    private static final Log log = LogFactory.getLog(AnalyticsTask.class);
    private int tenantId;
    private String scriptName;

    public void setProperties(Map<String, String> properties) {
        this.tenantId = Integer.parseInt(properties.get("TENANT_ID"));
        this.scriptName = properties.get("SCRIPT_NAME");
    }

    public void init() {
    }

    public void execute() {
        block6: {
            if (ServiceHolder.isAnalyticsExecutionEnabled()) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Executing the schedule task for: " + this.scriptName + " for tenant id: " + this.tenantId));
                    }
                    if (ServiceHolder.getAnalyticsProcessorService() != null) {
                        ServiceHolder.getAnalyticsProcessorService().executeScript(this.tenantId, this.scriptName);
                        String id = AnalyticsScriptLastExecutionStartTimeHolder.generateId(this.tenantId, this.scriptName);
                        AnalyticsScriptLastExecutionStartTimeHolder.add(id, System.currentTimeMillis());
                        break block6;
                    }
                    log.warn((Object)"Analytics Processor inactive now, and hence ignoring the triggered execution");
                }
                catch (AnalyticsExecutionException | AnalyticsPersistenceException e) {
                    log.error((Object)("Error while executing the scheduled task for the script: " + this.scriptName), (Throwable)e);
                }
            } else {
                log.warn((Object)"Analytics is disabled in this node, therefore ignoring the triggered execution.");
            }
        }
    }
}

