/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core;

import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.datasource.core.util.GenericUtils;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsPersistenceException;
import org.wso2.carbon.analytics.spark.core.exception.SparkScriptDeploymentException;
import org.wso2.carbon.analytics.spark.core.internal.AnalyticsPersistenceManager;
import org.wso2.carbon.analytics.spark.core.internal.ServiceHolder;
import org.wso2.carbon.analytics.spark.core.util.AnalyticsScript;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class SparkScriptCAppDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(SparkScriptCAppDeployer.class);
    private static final String TYPE = "analytics/spark";

    public void deployArtifacts(CarbonApplication carbonApplication, AxisConfiguration axisConfiguration) throws DeploymentException {
        if (!ServiceHolder.isAnalyticsExecutionEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Spark Script deployment is omitted because Analytics Execution is disabled");
            }
            return;
        }
        List artifacts = carbonApplication.getAppConfig().getApplicationArtifact().getDependencies();
        for (Artifact.Dependency dep : artifacts) {
            Artifact artifact = dep.getArtifact();
            if (artifact == null || !TYPE.equals(artifact.getType())) continue;
            List files = artifact.getFiles();
            if (files.size() == 1) {
                String fileName = ((CappFile)files.get(0)).getName();
                fileName = GenericUtils.checkAndReturnPath((String)fileName);
                String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
                try {
                    this.deploy(artifactPath, carbonApplication.getAppName());
                    artifact.setDeploymentStatus("Deployed");
                    continue;
                }
                catch (DeploymentException e) {
                    artifact.setDeploymentStatus("Failed");
                    throw e;
                }
            }
            if (files.size() == 0) continue;
            log.warn((Object)("Spark script must have a single XML file to be deployed. But " + files.size() + " files found"));
        }
    }

    private void deploy(String scriptFilePath, String carbonAppName) throws SparkScriptDeploymentException {
        File deploymentFileData = new File(scriptFilePath);
        try {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            log.info((Object)("Deploying spark script: " + deploymentFileData.getName() + " for tenant : " + tenantId));
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AnalyticsScript.class});
            Unmarshaller un = context.createUnmarshaller();
            AnalyticsScript script = (AnalyticsScript)un.unmarshal(deploymentFileData);
            script.setName(this.getScriptName(deploymentFileData.getName()));
            AnalyticsPersistenceManager.getInstance().putScript(tenantId, script.getName(), script.getScriptContent(), script.getCronExpression(), carbonAppName, false);
        }
        catch (JAXBException e) {
            String errorMsg = "Error while reading the analytics script : " + deploymentFileData.getAbsolutePath();
            log.error((Object)errorMsg, (Throwable)e);
            throw new SparkScriptDeploymentException(errorMsg, e);
        }
        catch (AnalyticsPersistenceException e) {
            String errorMsg = "Error while storing the script : " + deploymentFileData.getAbsolutePath();
            log.error((Object)errorMsg);
            throw new SparkScriptDeploymentException(errorMsg, (Throwable)((Object)e));
        }
    }

    private String getScriptName(String filePath) throws AnalyticsPersistenceException {
        String fileName = new File(filePath).getName();
        if (fileName.endsWith("xml")) {
            return fileName.substring(0, fileName.length() - ("xml".length() + ".".length()));
        }
        return fileName;
    }

    public void undeployArtifacts(CarbonApplication carbonApplication, AxisConfiguration axisConfiguration) throws DeploymentException {
        List artifacts = carbonApplication.getAppConfig().getApplicationArtifact().getDependencies();
        for (Artifact.Dependency dep : artifacts) {
            Artifact artifact = dep.getArtifact();
            if (artifact == null || !TYPE.equals(artifact.getType())) continue;
            List files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)("Spark script application must have a single spark script file. But " + files.size() + " files found."));
                continue;
            }
            if (!"Deployed".equals(artifact.getDeploymentStatus())) continue;
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            fileName = GenericUtils.checkAndReturnPath((String)fileName);
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            try {
                this.undeploy(artifactPath);
                artifact.setDeploymentStatus("Pending");
            }
            catch (DeploymentException e) {
                artifact.setDeploymentStatus("Failed");
                log.error((Object)("Error occured while trying to undeploy : " + artifact.getName()));
            }
        }
    }

    private void undeploy(String scriptFileName) throws SparkScriptDeploymentException {
        try {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            log.info((Object)("Undeploying spark script : " + scriptFileName + " for tenant id : " + tenantId));
            AnalyticsPersistenceManager.getInstance().deleteScript(tenantId, this.getScriptName(scriptFileName));
        }
        catch (AnalyticsPersistenceException e) {
            String errorMsg = "Error while deleting the script : " + scriptFileName;
            log.error((Object)errorMsg, (Throwable)((Object)e));
            throw new SparkScriptDeploymentException(errorMsg, (Throwable)((Object)e));
        }
    }
}

