/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.sources;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsDataService;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsSchema;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsExecutionException;
import org.wso2.carbon.analytics.spark.core.internal.ServiceHolder;
import org.wso2.carbon.analytics.spark.core.sources.AnalyticsRelation;
import org.wso2.carbon.analytics.spark.core.util.AnalyticsCommonUtils;
import scala.collection.JavaConversions;
import scala.collection.immutable.Map;

public class AnalyticsRelationProvider
implements RelationProvider,
SchemaRelationProvider {
    private static final Log log = LogFactory.getLog(AnalyticsRelationProvider.class);
    private int tenantId;
    private String tableName;
    private String schemaString;
    private String streamName;
    private String primaryKeys;
    private String recordStore;
    private boolean mergeFlag;
    private boolean globalTenantAccess;
    private StructType schemaStruct;
    private String incParams;

    public AnalyticsRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        this.setParameters(parameters);
        this.doTableActions();
        return this.getAnalyticsRelation(this.tenantId, this.recordStore, this.tableName, sqlContext, this.schemaStruct, this.incParams, this.globalTenantAccess, this.schemaString, this.primaryKeys, this.mergeFlag);
    }

    private void doTableActions() {
        try {
            this.createTableIfNotExist();
        }
        catch (AnalyticsExecutionException e) {
            String msg = "Error while creating the table : " + this.tableName + " : " + e.getMessage();
            log.error((Object)msg, (Throwable)((Object)e));
            throw new RuntimeException(msg, (Throwable)((Object)e));
        }
        try {
            this.setSchemaIfProvided();
        }
        catch (AnalyticsExecutionException e) {
            String msg = "Error while merging the schema for the table : " + this.tableName + " : " + e.getMessage();
            log.error((Object)msg, (Throwable)((Object)e));
            throw new RuntimeException(msg, (Throwable)((Object)e));
        }
    }

    private void setParameters(Map<String, String> parameters) {
        HashMap<String, String> jMap = new HashMap<String, String>(JavaConversions.asJavaMap(parameters));
        this.tenantId = Integer.parseInt(this.extractAndRemoveValuesFromMap("tenantId", jMap, "-1234"));
        this.tableName = this.extractAndRemoveValuesFromMap("tableName", jMap, "");
        this.schemaString = this.extractAndRemoveValuesFromMap("schema", jMap, "");
        this.streamName = this.extractAndRemoveValuesFromMap("streamName", jMap, "");
        this.primaryKeys = this.extractAndRemoveValuesFromMap("primaryKeys", jMap, "");
        this.recordStore = this.extractAndRemoveValuesFromMap("recordStore", jMap, "PROCESSED_DATA_STORE");
        this.mergeFlag = Boolean.parseBoolean(this.extractAndRemoveValuesFromMap("mergeSchema", jMap, String.valueOf(true)));
        this.globalTenantAccess = Boolean.parseBoolean(this.extractAndRemoveValuesFromMap("globalTenantAccess", jMap, String.valueOf(false)));
        this.incParams = this.extractAndRemoveValuesFromMap("incrementalParams", jMap, "");
        this.checkParameters(jMap);
    }

    private void checkParameters(java.util.Map<String, String> jMap) {
        if (jMap.size() > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("Unknown options : ");
            for (String key : jMap.keySet()) {
                buf.append(key).append(" ");
            }
            throw new RuntimeException(buf.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createTableIfNotExist() throws AnalyticsExecutionException {
        int targetTenantId;
        if (this.tableName.isEmpty()) {
            this.tableName = AnalyticsCommonUtils.convertStreamNameToTableName(this.streamName);
        }
        if (this.tableName.isEmpty()) {
            throw new AnalyticsExecutionException("Empty tableName OR streamName");
        }
        if (this.globalTenantAccess) {
            if (this.tenantId != -1234) throw new RuntimeException("Global tenant write can only be done by the super tenant");
            targetTenantId = -2000;
        } else {
            targetTenantId = this.tenantId;
        }
        this.createTableIfNotExist(targetTenantId, this.tableName);
    }

    private void createTableIfNotExist(int targetTenantId, String targetTableName) throws AnalyticsExecutionException {
        try {
            AnalyticsCommonUtils.createTableIfNotExists(ServiceHolder.getAnalyticsDataService(), this.recordStore, targetTenantId, targetTableName);
        }
        catch (AnalyticsException e) {
            throw new AnalyticsExecutionException("Error while accessing table " + targetTableName + " : " + e.getMessage(), e);
        }
    }

    protected AnalyticsSchema createAnalyticsTableSchema(AnalyticsDataService ads, int targetTenantId, String targetTableName, String schemaString, String primaryKeys, boolean globalTenantAccess, boolean mergeFlag) throws AnalyticsException {
        return AnalyticsCommonUtils.createAnalyticsTableSchema(ads, targetTenantId, targetTableName, schemaString, primaryKeys, globalTenantAccess, mergeFlag, false);
    }

    protected StructType createSparkSchemaStruct(AnalyticsDataService ads, int targetTenantId, String targetTableName, String schemaString, String primaryKeys, boolean globalTenantAccess, boolean mergeFlag) throws AnalyticsException {
        return AnalyticsCommonUtils.createSparkSchemaStruct(ads, targetTenantId, targetTableName, schemaString, primaryKeys, globalTenantAccess, mergeFlag);
    }

    private void setSchemaIfProvided() throws AnalyticsExecutionException {
        int targetTenantId = this.globalTenantAccess ? -2000 : this.tenantId;
        try {
            AnalyticsSchema schema = this.createAnalyticsTableSchema(ServiceHolder.getAnalyticsDataService(), targetTenantId, this.tableName, this.schemaString, this.primaryKeys, this.globalTenantAccess, this.mergeFlag);
            if (schema != null) {
                ServiceHolder.getAnalyticsDataService().setTableSchema(targetTenantId, this.tableName, schema);
            }
            this.schemaStruct = this.createSparkSchemaStruct(ServiceHolder.getAnalyticsDataService(), targetTenantId, this.tableName, this.schemaString, this.primaryKeys, this.globalTenantAccess, this.mergeFlag);
        }
        catch (AnalyticsException e) {
            throw new AnalyticsExecutionException("Error in setting provided schema: " + e.getMessage(), e);
        }
    }

    private String extractAndRemoveValuesFromMap(String key, java.util.Map<String, String> map, String defaultVal) {
        String value = map.get(key.toLowerCase());
        if (value == null) {
            return defaultVal;
        }
        map.remove(key.toLowerCase());
        return value;
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        this.setParameters(parameters);
        this.doTableActions();
        try {
            AnalyticsSchema schemaFromDS = ServiceHolder.getAnalyticsDataService().getTableSchema(this.tenantId, this.tableName);
            if (!AnalyticsCommonUtils.validateSchemaColumns(schema, schemaFromDS).booleanValue()) {
                String msg = "Incompatible schemas for the table " + this.tableName;
                log.error((Object)msg);
                throw new RuntimeException(msg);
            }
        }
        catch (AnalyticsException e) {
            String msg = "Failed to load the schema for table " + this.tableName + ": " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        return this.getAnalyticsRelation(this.tenantId, this.tableName, this.recordStore, sqlContext, schema, this.incParams, this.globalTenantAccess, this.schemaString, this.primaryKeys, this.mergeFlag);
    }

    protected AnalyticsRelation getAnalyticsRelation(int tenantId, String recordStore, String tableName, SQLContext sqlContext, StructType schema, String incParams, boolean globalTenantAccess, String schemaString, String primaryKeys, boolean mergeFlag) {
        return new AnalyticsRelation(tenantId, recordStore, tableName, sqlContext, schema, incParams, globalTenantAccess, schemaString, primaryKeys, mergeFlag);
    }
}

