/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.NullType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsDataService;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsDataServiceUtils;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsSchema;
import org.wso2.carbon.analytics.datasource.commons.ColumnDefinition;
import org.wso2.carbon.analytics.datasource.commons.ColumnDefinitionExt;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsTableNotAvailableException;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsExecutionException;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsUDFException;

public class AnalyticsCommonUtils {
    private static final Log log = LogFactory.getLog(AnalyticsCommonUtils.class);

    public static DataType getDataType(Type returnType) throws AnalyticsUDFException {
        DataType udfReturnType = null;
        if (returnType == Integer.TYPE || returnType == Integer.class) {
            udfReturnType = DataTypes.IntegerType;
        } else if (returnType == Double.TYPE || returnType == Double.class) {
            udfReturnType = DataTypes.DoubleType;
        } else if (returnType == Float.TYPE || returnType == Float.class) {
            udfReturnType = DataTypes.FloatType;
        } else if (returnType == Long.TYPE || returnType == Long.class) {
            udfReturnType = DataTypes.LongType;
        } else if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            udfReturnType = DataTypes.BooleanType;
        } else if (returnType == String.class) {
            udfReturnType = DataTypes.StringType;
        } else if (returnType == Short.TYPE || returnType == Short.class) {
            udfReturnType = DataTypes.ShortType;
        } else if (returnType == NullType.class) {
            udfReturnType = DataTypes.NullType;
        } else if (returnType == Byte.TYPE || returnType == Byte.class) {
            udfReturnType = DataTypes.ByteType;
        } else if (returnType == byte[].class || returnType == Byte[].class) {
            udfReturnType = DataTypes.BinaryType;
        } else if (returnType == Date.class) {
            udfReturnType = DataTypes.DateType;
        } else if (returnType == Timestamp.class) {
            udfReturnType = DataTypes.TimestampType;
        } else if (returnType == BigDecimal.class) {
            udfReturnType = DataTypes.createDecimalType();
        } else if (returnType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            Type[] types = type.getActualTypeArguments();
            if (types != null && types.length > 0) {
                switch (types.length) {
                    case 1: {
                        udfReturnType = DataTypes.createArrayType((DataType)AnalyticsCommonUtils.getDataType(types[0]));
                        break;
                    }
                    case 2: {
                        udfReturnType = DataTypes.createMapType((DataType)AnalyticsCommonUtils.getDataType(types[0]), (DataType)AnalyticsCommonUtils.getDataType(types[1]));
                        break;
                    }
                    default: {
                        throw new AnalyticsUDFException("Cannot Map the return type either to ArrayType or MapType");
                    }
                }
            }
        } else {
            throw new AnalyticsUDFException("Cannot determine the return DataType: " + returnType.toString());
        }
        return udfReturnType;
    }

    public static DataType stringToDataType(String strType) {
        switch (strType.toLowerCase()) {
            case "integer": {
                return DataTypes.IntegerType;
            }
            case "int": {
                return DataTypes.IntegerType;
            }
            case "float": {
                return DataTypes.FloatType;
            }
            case "double": {
                return DataTypes.DoubleType;
            }
            case "long": {
                return DataTypes.LongType;
            }
            case "boolean": {
                return DataTypes.BooleanType;
            }
            case "string": {
                return DataTypes.StringType;
            }
            case "binary": {
                return DataTypes.BinaryType;
            }
            case "facet": {
                return DataTypes.StringType;
            }
        }
        log.error((Object)("Invalid DataType: " + strType));
        throw new RuntimeException("Invalid DataType: " + strType);
    }

    public static AnalyticsSchema.ColumnType stringToColumnType(String strType) {
        switch (strType.toLowerCase()) {
            case "integer": {
                return AnalyticsSchema.ColumnType.INTEGER;
            }
            case "int": {
                return AnalyticsSchema.ColumnType.INTEGER;
            }
            case "float": {
                return AnalyticsSchema.ColumnType.FLOAT;
            }
            case "double": {
                return AnalyticsSchema.ColumnType.DOUBLE;
            }
            case "long": {
                return AnalyticsSchema.ColumnType.LONG;
            }
            case "boolean": {
                return AnalyticsSchema.ColumnType.BOOLEAN;
            }
            case "string": {
                return AnalyticsSchema.ColumnType.STRING;
            }
            case "binary": {
                return AnalyticsSchema.ColumnType.BINARY;
            }
            case "facet": {
                return AnalyticsSchema.ColumnType.STRING;
            }
        }
        log.error((Object)("Invalid ColumnType: " + strType));
        throw new RuntimeException("Invalid ColumnType: " + strType);
    }

    public static Map<String, Object> convertRowAndSchemaToValuesMap(Row row, StructType schema) {
        String[] colNames = schema.fieldNames();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < row.length(); ++i) {
            result.put(colNames[i], row.get(i));
        }
        return result;
    }

    public static List<Record> dataFrameToRecordsList(int tenantId, String tableName, DataFrame dataFrame) {
        Row[] rows = dataFrame.collect();
        ArrayList<Record> records = new ArrayList<Record>();
        StructType schema = dataFrame.schema();
        for (Row row : rows) {
            records.add(new Record(tenantId, tableName, AnalyticsCommonUtils.convertRowAndSchemaToValuesMap(row, schema)));
        }
        return records;
    }

    public static Boolean validateSchemaColumns(StructType sparkSchema, AnalyticsSchema analyticsSchema) {
        Object[] rddCols = sparkSchema.fieldNames();
        Set temp = analyticsSchema.getColumns().keySet();
        Object[] tableCols = temp.toArray(new String[temp.size()]);
        return Arrays.equals(rddCols, tableCols);
    }

    public static String encodeTableNameWithTenantId(int tenantId, String tableName) {
        String delimiter = "_";
        String tenantStr = tenantId < 0 ? "X" + String.valueOf(-tenantId) : "T" + String.valueOf(tenantId);
        return tenantStr + delimiter + tableName;
    }

    public static String convertStreamNameToTableName(String stream) {
        return stream.replaceAll("\\.", "_");
    }

    public static boolean isNumericType(AnalyticsSchema.ColumnType colType) {
        return !colType.name().equalsIgnoreCase("string") && !colType.name().equalsIgnoreCase("binary") && !colType.name().equalsIgnoreCase("facet");
    }

    public static boolean isEmptyAnalyticsSchema(AnalyticsSchema analyticsSchema) {
        return analyticsSchema == null || analyticsSchema.getColumns() == null || analyticsSchema.getColumns().size() == 0;
    }

    public static boolean isEmptySchema(StructType schema) {
        return schema == null || schema.fieldNames() == null || schema.fieldNames().length == 0;
    }

    public static StructField[] extractFieldsFromColumns(Map<String, ColumnDefinition> columns) {
        StructField[] resFields = new StructField[columns.size()];
        int i = 0;
        for (Map.Entry<String, ColumnDefinition> entry : columns.entrySet()) {
            String type = entry.getValue().getType().name();
            resFields[i] = new StructField(entry.getKey(), AnalyticsCommonUtils.stringToDataType(type), true, Metadata.empty());
            ++i;
        }
        return resFields;
    }

    public static StructField[] extractFieldsFromString(String schemaString) {
        String[] strFields = schemaString.split(",");
        StructField[] resFields = new StructField[strFields.length];
        for (int i = 0; i < strFields.length; ++i) {
            StructField field;
            String[] strFieldTokens = strFields[i].trim().split(" ");
            String name = strFieldTokens[0].trim();
            String type = strFieldTokens[1].trim().toLowerCase();
            resFields[i] = field = new StructField(name, AnalyticsCommonUtils.stringToDataType(type), true, Metadata.empty());
        }
        return resFields;
    }

    public static AnalyticsSchema analyticsSchemaFromStructType(StructType schema) {
        ArrayList<ColumnDefinition> colDefs = new ArrayList<ColumnDefinition>();
        for (StructField field : schema) {
            String name = field.name();
            AnalyticsSchema.ColumnType type = AnalyticsCommonUtils.stringToColumnType(field.dataType().typeName());
            colDefs.add(new ColumnDefinition(name, type));
        }
        return new AnalyticsSchema(colDefs, Collections.emptyList());
    }

    public static StructType structTypeFromAnalyticsSchema(AnalyticsSchema analyticsSchema) {
        return new StructType(AnalyticsCommonUtils.extractFieldsFromColumns(analyticsSchema.getColumns()));
    }

    public static void createTableIfNotExists(AnalyticsDataService ads, String recordStore, int targetTenantId, String targetTableName) throws AnalyticsException {
        if (!ads.listRecordStoreNames().contains(recordStore)) {
            throw new AnalyticsExecutionException("Unknown data store name: " + recordStore);
        }
        ads.createTableIfNotExists(targetTenantId, recordStore, targetTableName);
    }

    public static boolean isSchemaProvided(String schemaString) {
        return !schemaString.isEmpty();
    }

    private static void logDebug(String msg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }

    private static List<String> createPrimaryKeyList(String primaryKeyStr) {
        return new ArrayList<String>(Arrays.asList(primaryKeyStr.trim().split("\\s*,\\s*")));
    }

    private static boolean isTimestampColumn(String[] tokens) throws AnalyticsExecutionException {
        if (tokens[0].equalsIgnoreCase("_timestamp")) {
            if (tokens.length > 3 || tokens.length < 2) {
                throw new AnalyticsExecutionException("Invalid options for _timestamp");
            }
            if (!tokens[1].equalsIgnoreCase("long")) {
                throw new AnalyticsExecutionException("_timestamp field type must be LONG");
            }
            return true;
        }
        return false;
    }

    private static boolean isTenantFieldColumn(String[] tokens) throws AnalyticsExecutionException {
        return tokens[0].equalsIgnoreCase("_tenantId");
    }

    private static List<ColumnDefinition> createColumnDefinitionsFromString(String colsStr, boolean globalTenantAccess, boolean sparkSchema) throws AnalyticsExecutionException {
        String[] strFields;
        ArrayList<ColumnDefinition> resList = new ArrayList<ColumnDefinition>();
        if (colsStr.trim().isEmpty()) {
            return resList;
        }
        for (String strField : strFields = colsStr.split("\\s*,\\s*")) {
            String[] tokens = strField.trim().split("\\s+");
            if (tokens.length >= 2) {
                if (!sparkSchema && AnalyticsCommonUtils.isTimestampColumn(tokens)) {
                    AnalyticsCommonUtils.logDebug("if this is a timestamp column, ignore processing that element in the analytics schema");
                    continue;
                }
                if (!sparkSchema && globalTenantAccess && AnalyticsCommonUtils.isTenantFieldColumn(tokens)) continue;
                AnalyticsSchema.ColumnType type = AnalyticsCommonUtils.stringToColumnType(tokens[1]);
                switch (tokens.length) {
                    case 2: {
                        resList.add(new ColumnDefinition(tokens[0], type));
                        break;
                    }
                    case 3: {
                        if (tokens[2].equalsIgnoreCase("-i")) {
                            if (tokens[1].toLowerCase().equalsIgnoreCase("facet")) {
                                resList.add((ColumnDefinition)new ColumnDefinitionExt(tokens[0], type, true, false, true));
                                break;
                            }
                            resList.add(new ColumnDefinition(tokens[0], type, true, false));
                            break;
                        }
                        if (tokens[2].equalsIgnoreCase("-sp")) {
                            if (AnalyticsCommonUtils.isNumericType(type)) {
                                resList.add(new ColumnDefinition(tokens[0], type, true, true));
                                break;
                            }
                            throw new AnalyticsExecutionException("Score-param assigned to a non-numeric ColumnType");
                        }
                        if (tokens[2].equalsIgnoreCase("-f")) {
                            resList.add((ColumnDefinition)new ColumnDefinitionExt(tokens[0], type, true, false, true));
                            break;
                        }
                        throw new AnalyticsExecutionException("Invalid option for ColumnType");
                    }
                    case 4: {
                        HashSet<String> indexOptions = new HashSet<String>(2);
                        indexOptions.addAll(Arrays.asList(tokens[2], tokens[3]));
                        if (indexOptions.contains("-f") && indexOptions.contains("-sp")) {
                            resList.add((ColumnDefinition)new ColumnDefinitionExt(tokens[0], type, true, true, true));
                            break;
                        }
                        if (indexOptions.contains("-f") && indexOptions.contains("-i")) {
                            resList.add((ColumnDefinition)new ColumnDefinitionExt(tokens[0], type, true, false, true));
                            break;
                        }
                        throw new AnalyticsExecutionException("Invalid option for ColumnType");
                    }
                    default: {
                        throw new AnalyticsExecutionException("Invalid ColumnType");
                    }
                }
                continue;
            }
            throw new AnalyticsExecutionException("Invalid ColumnType");
        }
        return resList;
    }

    public static StructType createSparkSchemaStruct(AnalyticsDataService ads, int targetTenantId, String targetTableName, String schemaString, String primaryKeys, boolean globalTenantAccess, boolean mergeFlag) throws AnalyticsException {
        AnalyticsSchema schema = AnalyticsCommonUtils.createAnalyticsTableSchema(ads, targetTenantId, targetTableName, schemaString, primaryKeys, globalTenantAccess, mergeFlag, true);
        return AnalyticsCommonUtils.structTypeFromAnalyticsSchema(schema);
    }

    public static AnalyticsSchema createAnalyticsTableSchema(AnalyticsDataService ads, int targetTenantId, String targetTableName, String schemaString, String primaryKeys, boolean globalTenantAccess, boolean mergeFlag, boolean sparkSchema) throws AnalyticsException {
        List<Object> pKeyList = !primaryKeys.isEmpty() ? AnalyticsCommonUtils.createPrimaryKeyList(primaryKeys) : Collections.emptyList();
        List<ColumnDefinition> schemaColList = AnalyticsCommonUtils.createColumnDefinitionsFromString(schemaString, globalTenantAccess, sparkSchema);
        AnalyticsSchema schema = new AnalyticsSchema(schemaColList, pKeyList);
        if (sparkSchema && !AnalyticsCommonUtils.isEmptyAnalyticsSchema(schema)) {
            return schema;
        }
        if (mergeFlag) {
            schema = AnalyticsCommonUtils.createMergedSchema(ads, targetTenantId, targetTableName, schema);
        }
        return schema;
    }

    private static AnalyticsSchema createMergedSchema(AnalyticsDataService ads, int targetTenantId, String targetTableName, AnalyticsSchema schema) throws AnalyticsException {
        AnalyticsSchema existingSchema;
        block3: {
            existingSchema = null;
            try {
                existingSchema = ads.getTableSchema(targetTenantId, targetTableName);
            }
            catch (AnalyticsTableNotAvailableException ignore) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Table not found when merging schema => " + targetTenantId + ":" + targetTableName));
            }
        }
        if (!AnalyticsCommonUtils.isEmptyAnalyticsSchema(existingSchema)) {
            return AnalyticsDataServiceUtils.createMergedSchema((AnalyticsSchema)existingSchema, (List)schema.getPrimaryKeys(), new ArrayList(schema.getColumns().values()), Collections.emptyList());
        }
        return schema;
    }
}

