/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import java.io.Serializable;
import java.util.Collection;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsServiceHolder;

public class SparkTableNamesHolder
implements Serializable {
    private static final long serialVersionUID = 7222154767575842994L;
    private MultiMap<Integer, String> sparkTableNames;
    private ListMultimap<Integer, String> inMemSparkTableNames;
    private boolean isClustered = false;

    public SparkTableNamesHolder() {
    }

    public SparkTableNamesHolder(boolean isClustered) {
        this.isClustered = isClustered;
        if (isClustered) {
            HazelcastInstance hz = AnalyticsServiceHolder.getHazelcastInstance();
            this.sparkTableNames = hz.getMultiMap("tenantIdTablesMap");
        } else {
            this.inMemSparkTableNames = ArrayListMultimap.create();
        }
    }

    public void addTableName(int tenantId, String tableName) {
        if (this.isClustered) {
            this.sparkTableNames.put((Object)tenantId, (Object)tableName);
        } else {
            this.inMemSparkTableNames.put((Object)tenantId, (Object)tableName);
        }
    }

    public Collection<String> getTableNames(int tenantId) {
        if (this.isClustered) {
            return this.sparkTableNames.get((Object)tenantId);
        }
        return this.inMemSparkTableNames.get((Object)tenantId);
    }
}

