/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.sources;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.Dependency;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.StructType;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsDataService;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsSchema;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsTableNotAvailableException;
import org.wso2.carbon.analytics.spark.core.internal.ServiceHolder;
import org.wso2.carbon.analytics.spark.core.rdd.AnalyticsRDD;
import org.wso2.carbon.analytics.spark.core.sources.AnalyticsWritingFunction;
import org.wso2.carbon.analytics.spark.core.util.AnalyticsCommonUtils;
import org.wso2.carbon.analytics.spark.core.util.AnalyticsConstants;
import org.wso2.carbon.analytics.spark.core.util.CarbonScalaUtils;
import org.wso2.carbon.analytics.spark.core.util.IncrementalUtils;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class AnalyticsRelation
extends BaseRelation
implements TableScan,
InsertableRelation,
Serializable {
    private static final long serialVersionUID = -7773419083178608517L;
    private static final Log log = LogFactory.getLog(AnalyticsRelation.class);
    private SQLContext sqlContext;
    private StructType schema;
    private int tenantId;
    private String tableName;
    private String recordStore;
    private boolean incEnable;
    private String incID;
    private int incBuffer;
    private boolean globalTenantAccess;
    private AnalyticsConstants.IncrementalWindowUnit windowUnit;
    private String schemaString;
    private String primaryKeys;
    private boolean mergeFlag;

    public AnalyticsRelation() {
    }

    public AnalyticsRelation(int tenantId, String recordStore, String tableName, SQLContext sqlContext, StructType schema, String incParams, boolean globalTenantAccess, String schemaString, String primaryKeys, boolean mergeFlag) {
        this.tenantId = tenantId;
        this.tableName = tableName;
        this.recordStore = recordStore;
        this.sqlContext = sqlContext;
        this.schema = schema;
        this.setIncParams(incParams);
        this.globalTenantAccess = globalTenantAccess;
        this.schemaString = schemaString;
        this.primaryKeys = primaryKeys;
        this.mergeFlag = mergeFlag;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setIncParams(String incParamStr) {
        if (incParamStr.isEmpty()) {
            this.logDebug("Incremental processing disabled");
            this.incEnable = false;
            return;
        }
        this.incEnable = true;
        this.logDebug("Incremental processing enabled. Setting incremental parameters " + incParamStr);
        String[] splits = incParamStr.split("\\s*,\\s*");
        if (splits.length == 1) {
            this.incID = splits[0];
            return;
        }
        if (splits.length == 2) {
            this.incID = splits[0];
            this.windowUnit = AnalyticsConstants.IncrementalWindowUnit.valueOf(splits[1].toUpperCase());
            this.incBuffer = 1;
            return;
        }
        if (splits.length == 3) {
            this.incID = splits[0];
            this.windowUnit = AnalyticsConstants.IncrementalWindowUnit.valueOf(splits[1].toUpperCase());
            this.incBuffer = Integer.parseInt(splits[2]);
            return;
        }
        String msg = "Error while setting incremental processing parameters : " + incParamStr;
        log.error((Object)msg);
        throw new RuntimeException(msg);
    }

    /*
     * Unable to fully structure code
     */
    public RDD<Row> buildScan() {
        if (AnalyticsCommonUtils.isEmptySchema(this.schema)) {
            msg = "Unable to scan through the table as the schema is unavailable for " + this.tableName;
            AnalyticsRelation.log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        endTime = 0x7FFFFFFFFFFFFFFFL;
        if (this.incEnable) {
            try {
                startTime = ServiceHolder.getIncrementalMetaStore().getLastProcessedTimestamp(this.tenantId, this.incID, true);
                if (startTime <= 0L) ** GOTO lbl18
                if (this.windowUnit != null) {
                    startTime = IncrementalUtils.getIncrementalStartTime(startTime, this.windowUnit, this.incBuffer);
                }
                ++startTime;
            }
            catch (AnalyticsException e) {
                throw new RuntimeException(e);
            }
        } else {
            startTime = -9223372036854775808L;
        }
lbl18:
        // 4 sources

        if (!this.globalTenantAccess) ** GOTO lbl23
        if (this.tenantId == -1234) {
            targetTenantId = -2000;
        } else {
            throw new RuntimeException("Global tenant read can only be done by the super tenant");
lbl23:
            // 1 sources

            targetTenantId = this.tenantId;
        }
        return this.getAnalyticsRDD(targetTenantId, this.tableName, new ArrayList<String>(Arrays.asList(this.schema.fieldNames())), this.sqlContext.sparkContext(), (Seq)Seq$.MODULE$.empty(), (ClassTag<Row>)ClassTag$.MODULE$.apply(Row.class), startTime, endTime, this.incEnable, this.incID);
    }

    private void logDebug(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)s);
        }
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public StructType schema() {
        if (AnalyticsCommonUtils.isEmptySchema(this.schema)) {
            log.warn((Object)("No schema is available for table " + this.tableName));
        }
        return this.schema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insert(DataFrame data, boolean overwrite) {
        int targetTenantId;
        AnalyticsDataService dataService = ServiceHolder.getAnalyticsDataService();
        if (this.globalTenantAccess) {
            if (this.tenantId != -1234) throw new RuntimeException("Global tenant write can only be done by the super tenant");
            targetTenantId = -2000;
        } else {
            targetTenantId = this.tenantId;
        }
        try {
            AnalyticsSchema tempSchema;
            try {
                tempSchema = dataService.getTableSchema(targetTenantId, this.tableName);
            }
            catch (AnalyticsTableNotAvailableException e) {
                tempSchema = null;
            }
            if (overwrite && !AnalyticsCommonUtils.isEmptyAnalyticsSchema(tempSchema)) {
                dataService.deleteTable(targetTenantId, this.tableName);
                if (!dataService.listRecordStoreNames().contains(this.recordStore)) {
                    throw new RuntimeException("Unknown record store name " + this.recordStore);
                }
                dataService.createTable(targetTenantId, this.recordStore, this.tableName);
                dataService.setTableSchema(targetTenantId, this.tableName, tempSchema);
            }
            this.writeDataFrameToDAL(data);
            return;
        }
        catch (AnalyticsException e) {
            String msg = "Error while inserting data into table " + this.tableName + " : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    private void writeDataFrameToDAL(DataFrame data) {
        for (int i = 0; i < data.rdd().partitions().length; ++i) {
            data.sqlContext().sparkContext().runJob(data.rdd(), (Function1)new AnalyticsWritingFunction(this.tenantId, this.tableName, data.schema(), this.globalTenantAccess, this.schemaString, this.primaryKeys, this.mergeFlag, this.recordStore), CarbonScalaUtils.getNumberSeq(i, i + 1), false, ClassTag$.MODULE$.Unit());
        }
    }

    protected AnalyticsRDD getAnalyticsRDD(int tenantId, String tableName, List<String> columns, SparkContext sparkContext, Seq<Dependency<?>> deps, ClassTag<Row> evidence, long startTime, long endTime, boolean incEnable, String incID) {
        return new AnalyticsRDD(tenantId, tableName, columns, sparkContext, deps, evidence, startTime, endTime, incEnable, incID);
    }
}

