/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.sources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.analytics.dataservice.commons.AnalyticsDataResponse;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsDataService;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsDataServiceUtils;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsSchema;
import org.wso2.carbon.analytics.datasource.commons.ColumnDefinition;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.spark.core.internal.ServiceHolder;

public class AnalyticsIncrementalMetaStore {
    private static final String INC_META_TABLE = "__analytics_incremental_meta_table";
    private static final String COLUMN_TENANT_ID = "TENANT_ID";
    private static final String COLUMN_TABLE_ID = "TABLE_ID";
    private static final String COLUMN_PRIMARY_VALUE = "PRIMARY_VAL";
    private static final String COLUMN_TEMP_VALUE = "TEMP_VAL";
    private AnalyticsDataService ads = ServiceHolder.getAnalyticsDataService();

    public AnalyticsIncrementalMetaStore() throws AnalyticsException {
        this.ads.createTable(-5000, INC_META_TABLE);
        ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
        columns.add(new ColumnDefinition(COLUMN_TENANT_ID, AnalyticsSchema.ColumnType.INTEGER));
        columns.add(new ColumnDefinition(COLUMN_TABLE_ID, AnalyticsSchema.ColumnType.STRING));
        columns.add(new ColumnDefinition(COLUMN_PRIMARY_VALUE, AnalyticsSchema.ColumnType.LONG));
        columns.add(new ColumnDefinition(COLUMN_TEMP_VALUE, AnalyticsSchema.ColumnType.LONG));
        AnalyticsSchema schema = new AnalyticsSchema(columns, new ArrayList<String>(Arrays.asList(COLUMN_TENANT_ID, COLUMN_TABLE_ID)));
        this.ads.setTableSchema(-5000, INC_META_TABLE, schema);
    }

    public void setLastProcessedTimestamp(int tenantId, String id, long ts, boolean primary) throws AnalyticsException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(COLUMN_TENANT_ID, tenantId);
        values.put(COLUMN_TABLE_ID, id);
        if (primary) {
            values.put(COLUMN_PRIMARY_VALUE, ts);
        } else {
            values.put(COLUMN_PRIMARY_VALUE, this.getLastProcessedTimestamp(tenantId, id, true));
            values.put(COLUMN_TEMP_VALUE, ts);
        }
        Record record = new Record(-5000, INC_META_TABLE, values);
        this.ads.put(new ArrayList<Record>(Arrays.asList(record)));
    }

    public long getLastProcessedTimestamp(int tenantId, String id, boolean primary) throws AnalyticsException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(COLUMN_TENANT_ID, tenantId);
        values.put(COLUMN_TABLE_ID, id);
        List result = AnalyticsDataServiceUtils.listRecords((AnalyticsDataService)this.ads, (AnalyticsDataResponse)this.ads.getWithKeyValues(-5000, INC_META_TABLE, 1, null, new ArrayList<Map>(Arrays.asList(values))));
        if (result.size() > 0) {
            Record record = (Record)result.get(0);
            Object obj = primary ? record.getValue(COLUMN_PRIMARY_VALUE) : record.getValue(COLUMN_TEMP_VALUE);
            if (obj != null) {
                return (Long)obj;
            }
            return Long.MIN_VALUE;
        }
        return Long.MIN_VALUE;
    }

    public void resetIncrementalTimestamps(int tenantId, String id) throws AnalyticsException {
        this.setLastProcessedTimestamp(tenantId, id, Long.MIN_VALUE, true);
        this.setLastProcessedTimestamp(tenantId, id, Long.MIN_VALUE, false);
    }
}

