/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.esbanalytics.decompress;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.event.stream.populater.ComplexEventPopulater;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.StreamProcessor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.wso2.carbon.analytics.spark.core.util.CompressedEventAnalyticsUtils;
import org.wso2.carbon.analytics.spark.core.util.PublishingPayload;
import org.wso2.extension.siddhi.execution.esbanalytics.decompress.util.CompressedEventUtils;

@Extension(name="decompress", namespace="esbAnalytics", description="This extension decompress any compressed analytics events coming from WSO2 Enterprise Integrator", parameters={@Parameter(name="meta.compressed", description="Compressed state of the message", type={DataType.BOOL}), @Parameter(name="meta.tenant.id", description="Tenant id", type={DataType.INT}), @Parameter(name="message.id", description="Message id", type={DataType.STRING}), @Parameter(name="flow.data", description="Compressed stream events chunk", type={DataType.STRING})}, returnAttributes={@ReturnAttribute(name="messageFlowId", description="Statistic tracing id for the message flow", type={DataType.STRING}), @ReturnAttribute(name="host", description="Name of the host", type={DataType.STRING}), @ReturnAttribute(name="hashCode", description="HashCode of the reporting component", type={DataType.STRING}), @ReturnAttribute(name="componentName", description="Name of the component", type={DataType.STRING}), @ReturnAttribute(name="componentType", description="Component type of the component", type={DataType.STRING}), @ReturnAttribute(name="componentIndex", description="Index of the component", type={DataType.INT}), @ReturnAttribute(name="componentId", description="Unique Id of the reporting component", type={DataType.STRING}), @ReturnAttribute(name="startTime", description="Start time of the event-", type={DataType.LONG}), @ReturnAttribute(name="endTime", description="EndTime of the Event", type={DataType.LONG}), @ReturnAttribute(name="duration", description="Event duration", type={DataType.LONG}), @ReturnAttribute(name="beforePayload", description="Payload before mediation by the component", type={DataType.STRING}), @ReturnAttribute(name="afterPayLoad", description="Payload after mediation by the component", type={DataType.STRING}), @ReturnAttribute(name="contextPropertyMap", description="Message context properties for the component", type={DataType.STRING}), @ReturnAttribute(name="transportPropertyMap", description="Transport properties for the component", type={DataType.STRING}), @ReturnAttribute(name="children", description="Children List for the component", type={DataType.STRING}), @ReturnAttribute(name="entryPoint", description="Entry point for the flow", type={DataType.STRING}), @ReturnAttribute(name="entryPointHashcode", description="Hashcode for the entry point", type={DataType.STRING}), @ReturnAttribute(name="faultCount", description="Number of faults", type={DataType.INT}), @ReturnAttribute(name="metaTenantId", description="Id value of the meta tenant", type={DataType.INT}), @ReturnAttribute(name="timestamp", description="Event timestamp", type={DataType.LONG})}, examples={@Example(syntax="define stream inputStream(meta_compressed bool, meta_tenantId int, messageId string, flowData string); @info( name = 'query') from inputStream#esbAnalytics:decompress(meta_compressed, meta_tenantId, messageId, flowData) insert all events into outputStream;", description="This query uses the incoming esb analytics message to produce decompressed esb analytics events.")})
public class DecompressStreamProcessorExtension
extends StreamProcessor<State> {
    private static final ThreadLocal<Kryo> kryoTL = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.register(HashMap.class, 111);
        kryo.register(ArrayList.class, 222);
        kryo.register(PublishingPayload.class, 333);
        return kryo;
    });
    private String siddhiAppName;
    private Map<String, String> fields = new LinkedHashMap<String, String>();
    private List<String> columns;
    private Map<String, VariableExpressionExecutor> compressedEventAttributes;
    private List<Attribute> attributeList = new ArrayList<Attribute>();

    private static Map<String, String> getOutputFields(String siddhiAppName) {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] lines;
            for (String line : lines = IOUtils.toString((InputStream)classLoader.getResourceAsStream("decompressedEventDefinition")).split("\n")) {
                String[] fieldDef;
                if (StringUtils.startsWithIgnoreCase((CharSequence)line, (CharSequence)"#") || !StringUtils.isNotEmpty((CharSequence)line) || (fieldDef = StringUtils.deleteWhitespace((String)line).split(":")).length != 2) continue;
                fields.put(fieldDef[0], fieldDef[1]);
            }
        }
        catch (IOException e) {
            throw new SiddhiAppCreationException("Unable to read decompressed event definitions in " + siddhiAppName + ": " + e.getMessage(), (Throwable)e);
        }
        return fields;
    }

    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater, State state) {
        ComplexEventChunk decompressedStreamEventChunk = new ComplexEventChunk(false);
        while (streamEventChunk.hasNext()) {
            StreamEvent compressedEvent = (StreamEvent)streamEventChunk.next();
            String eventString = (String)this.compressedEventAttributes.get("flowData").execute((ComplexEvent)compressedEvent);
            if (!eventString.isEmpty()) {
                Boolean isCompressed = (Boolean)this.compressedEventAttributes.get("meta_compressed").execute((ComplexEvent)compressedEvent);
                ByteArrayInputStream unzippedByteArray = isCompressed != false ? CompressedEventAnalyticsUtils.decompress(eventString) : new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)eventString));
                Input input = new Input(unzippedByteArray);
                Map aggregatedEvent = kryoTL.get().readObjectOrNull(input, HashMap.class);
                ArrayList eventsList = (ArrayList)aggregatedEvent.get("events");
                ArrayList payloadsList = (ArrayList)aggregatedEvent.get("payloads");
                String host = (String)aggregatedEvent.get("host");
                int metaTenantId = (Integer)this.compressedEventAttributes.get("meta_tenantId").execute((ComplexEvent)compressedEvent);
                for (int i = 0; i < eventsList.size(); ++i) {
                    StreamEvent decompressedEvent = streamEventCloner.copyStreamEvent(compressedEvent);
                    Object[] decompressedFields = CompressedEventUtils.getFieldValues(this.columns, (List)eventsList.get(i), payloadsList, i, compressedEvent.getTimestamp(), metaTenantId, host);
                    complexEventPopulater.populateComplexEvent((ComplexEvent)decompressedEvent, decompressedFields);
                    decompressedStreamEventChunk.add((ComplexEvent)decompressedEvent);
                }
                continue;
            }
            throw new SiddhiAppRuntimeException("Empty message flow data event in " + this.siddhiAppName);
        }
        nextProcessor.process(decompressedStreamEventChunk);
    }

    protected StateFactory<State> init(MetaStreamEvent metaStreamEvent, AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, StreamEventClonerHolder streamEventClonerHolder, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, SiddhiQueryContext siddhiQueryContext) {
        this.siddhiAppName = siddhiQueryContext.getSiddhiAppContext().getName();
        this.compressedEventAttributes = new HashMap<String, VariableExpressionExecutor>();
        block26: for (ExpressionExecutor expressionExecutor : attributeExpressionExecutors) {
            String variableName;
            if (!(expressionExecutor instanceof VariableExpressionExecutor)) continue;
            VariableExpressionExecutor variable = (VariableExpressionExecutor)expressionExecutor;
            switch (variableName = variable.getAttribute().getName()) {
                case "flowData": {
                    this.compressedEventAttributes.put("flowData", variable);
                    continue block26;
                }
                case "meta_compressed": {
                    this.compressedEventAttributes.put("meta_compressed", variable);
                    continue block26;
                }
                case "meta_tenantId": {
                    this.compressedEventAttributes.put("meta_tenantId", variable);
                    continue block26;
                }
            }
        }
        if (this.compressedEventAttributes.get("flowData") == null || this.compressedEventAttributes.get("meta_compressed") == null || this.compressedEventAttributes.get("meta_tenantId") == null) {
            throw new SiddhiAppCreationException("Cannot find required attributes in " + this.siddhiAppName + ". Please provide flowData, meta_compressed, meta_tenantId attributes in exact names");
        }
        this.fields = DecompressStreamProcessorExtension.getOutputFields(this.siddhiAppName);
        ArrayList<Attribute> outputAttributes = new ArrayList<Attribute>();
        for (Map.Entry<String, String> entry : this.fields.entrySet()) {
            String fieldName = entry.getKey();
            String fieldType = entry.getValue();
            Attribute.Type type = null;
            switch (fieldType.toLowerCase(Locale.ENGLISH)) {
                case "double": {
                    type = Attribute.Type.DOUBLE;
                    break;
                }
                case "float": {
                    type = Attribute.Type.FLOAT;
                    break;
                }
                case "integer": {
                    type = Attribute.Type.INT;
                    break;
                }
                case "long": {
                    type = Attribute.Type.LONG;
                    break;
                }
                case "boolean": {
                    type = Attribute.Type.BOOL;
                    break;
                }
                case "string": {
                    type = Attribute.Type.STRING;
                    break;
                }
            }
            outputAttributes.add(new Attribute(fieldName, type));
        }
        this.columns = new ArrayList<String>(this.fields.keySet());
        this.attributeList = outputAttributes;
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public List<Attribute> getReturnAttributes() {
        return this.attributeList;
    }

    public ProcessingMode getProcessingMode() {
        return ProcessingMode.SLIDE;
    }
}

