/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.jdbc;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.datasource.core.util.GenericUtils;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsExecutionException;
import org.wso2.carbon.analytics.spark.core.jdbc.SparkJDBCQueryConfiguration;

public class SparkJDBCUtils {
    public static final String SPARK_JDBC_CONFIG_FILE = "spark-jdbc-config.xml";

    public static SparkJDBCQueryConfiguration loadQueryConfiguration() throws AnalyticsException {
        try {
            File confFile = new File(GenericUtils.getAnalyticsConfDirectory() + File.separator + "analytics" + File.separator + "spark" + File.separator + SPARK_JDBC_CONFIG_FILE);
            if (!confFile.exists()) {
                throw new AnalyticsExecutionException("Spark JDBC query configuration file cannot be found at: " + confFile.getPath());
            }
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SparkJDBCQueryConfiguration.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            return (SparkJDBCQueryConfiguration)unmarshaller.unmarshal(confFile);
        }
        catch (JAXBException e) {
            throw new AnalyticsException("Error in processing Spark JDBC query configuration: " + e.getMessage(), (Throwable)e);
        }
    }
}

