/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.spark.core.AnalyticsProcessorService;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsExecutionException;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsPersistenceException;
import org.wso2.carbon.analytics.spark.core.internal.AnalyticsPersistenceManager;
import org.wso2.carbon.analytics.spark.core.internal.ServiceHolder;
import org.wso2.carbon.analytics.spark.core.util.AnalyticsQueryResult;
import org.wso2.carbon.analytics.spark.core.util.AnalyticsScript;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskManager;

public class CarbonAnalyticsProcessorService
implements AnalyticsProcessorService {
    private static final Log log = LogFactory.getLog(CarbonAnalyticsProcessorService.class);

    @Override
    public void saveScript(int tenantId, String scriptName, String scriptContent, String cronExpression) throws AnalyticsPersistenceException {
        try {
            AnalyticsPersistenceManager.getInstance().saveScript(tenantId, scriptName, scriptContent, cronExpression, null, true);
        }
        catch (AnalyticsPersistenceException e) {
            log.error((Object)("Error occurred when persisting the script. " + e.getMessage()), (Throwable)((Object)e));
            throw e;
        }
    }

    @Override
    public void deleteScript(int tenantId, String scriptName) throws AnalyticsPersistenceException {
        try {
            AnalyticsPersistenceManager.getInstance().deleteScript(tenantId, scriptName);
        }
        catch (AnalyticsPersistenceException e) {
            log.error((Object)("Error while deleting the script : " + scriptName), (Throwable)((Object)e));
            throw e;
        }
    }

    @Override
    public void updateScript(int tenantId, String scriptName, String scriptContent, String cronExpression) throws AnalyticsPersistenceException {
        try {
            AnalyticsPersistenceManager.getInstance().putScript(tenantId, scriptName, scriptContent, cronExpression, null, true);
        }
        catch (AnalyticsPersistenceException e) {
            log.error((Object)("Error while updating the script : " + scriptName), (Throwable)((Object)e));
            throw e;
        }
    }

    @Override
    public List<AnalyticsScript> getAllScripts(int tenantId) throws AnalyticsPersistenceException {
        return AnalyticsPersistenceManager.getInstance().getAllAnalyticsScripts(tenantId);
    }

    @Override
    public AnalyticsScript getScript(int tenantId, String name) throws AnalyticsPersistenceException {
        try {
            return AnalyticsPersistenceManager.getInstance().getAnalyticsScript(tenantId, name);
        }
        catch (AnalyticsPersistenceException ex) {
            log.error((Object)("Error while retrieving the script : " + name), (Throwable)((Object)ex));
            throw ex;
        }
    }

    @Override
    public AnalyticsQueryResult[] executeScript(int tenantId, String scriptName) throws AnalyticsExecutionException, AnalyticsPersistenceException {
        if (ServiceHolder.isAnalyticsExecutionEnabled()) {
            try {
                AnalyticsScript script = AnalyticsPersistenceManager.getInstance().getAnalyticsScript(tenantId, scriptName);
                String[] queries = this.getQueries(script.getScriptContent());
                if (queries == null) {
                    throw new AnalyticsExecutionException("No complete queries provided in the script. " + script.getScriptContent());
                }
                AnalyticsQueryResult[] results = new AnalyticsQueryResult[queries.length];
                int queryIndex = 0;
                for (String query : queries) {
                    results[queryIndex] = this.executeQuery(tenantId, query);
                    ++queryIndex;
                }
                return results;
            }
            catch (AnalyticsPersistenceException e) {
                log.error((Object)("Error while retrieving the script : " + scriptName), (Throwable)((Object)e));
                throw e;
            }
        }
        String errorMsg = "Analytics query execution is disabled in this node. Therefore cannot executed the script  - " + scriptName;
        log.error((Object)errorMsg);
        throw new AnalyticsExecutionException(errorMsg);
    }

    @Override
    public String[] getQueries(String scriptContent) {
        if (scriptContent != null && !scriptContent.trim().isEmpty()) {
            scriptContent = scriptContent.replaceAll("\\n|\\r", "");
            String[] queries = scriptContent.split(";(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            ArrayList<String> processedQueries = new ArrayList<String>();
            for (String query : queries) {
                if (query == null || query.trim().isEmpty()) continue;
                processedQueries.add(query);
            }
            return processedQueries.toArray(new String[processedQueries.size()]);
        }
        return null;
    }

    @Override
    public AnalyticsQueryResult executeQuery(int tenantId, String query) throws AnalyticsExecutionException {
        if (ServiceHolder.isAnalyticsExecutionEnabled()) {
            if (query != null && !query.trim().isEmpty()) {
                try {
                    return ServiceHolder.getAnalyticskExecutor().executeQuery(tenantId, query);
                }
                catch (AnalyticsExecutionException e) {
                    log.error((Object)("Error while executing query : " + query), (Throwable)((Object)e));
                    throw e;
                }
            }
            log.error((Object)("No queries provided to execute at tenant id :" + tenantId));
            throw new AnalyticsExecutionException("No queries provided to execute.");
        }
        String errorMsg = "Spark query execution is disabled in this node. Therefore cannot executed the query submitted - " + query;
        log.error((Object)errorMsg);
        throw new AnalyticsExecutionException(errorMsg);
    }

    @Override
    public boolean isAnalyticsExecutionEnabled() {
        return ServiceHolder.isAnalyticsExecutionEnabled();
    }

    @Override
    public boolean isAnalyticsTaskExecuting(String scriptName) throws AnalyticsExecutionException {
        if (null != scriptName && !scriptName.trim().isEmpty()) {
            try {
                TaskManager.TaskState state = ServiceHolder.getTaskManager().getTaskState(scriptName);
                return null != state && state == TaskManager.TaskState.BLOCKED;
            }
            catch (TaskException e) {
                if (e.getCode().equals((Object)TaskException.Code.NO_TASK_EXISTS)) {
                    return false;
                }
                log.error((Object)("Error while retrieving the status of the task:" + scriptName), (Throwable)e);
                throw new AnalyticsExecutionException("Error while retrieving the status of the task:" + scriptName, e);
            }
        }
        return false;
    }
}

