/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.udf.adaptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.api.java.UDF1;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsUDFException;

public class UDF0Adaptor
implements UDF1 {
    private static final long serialVersionUID = -7272061842221026235L;
    private static Log log = LogFactory.getLog(UDF0Adaptor.class);
    private Class<Object> udfClass;
    private String udfMethodName;
    private Class[] parameterTypes;

    public UDF0Adaptor(Class<Object> udfClass, String udfMethodName, Class[] parameterTypes) throws AnalyticsUDFException {
        try {
            this.udfClass = udfClass;
            this.udfMethodName = udfMethodName;
            this.parameterTypes = parameterTypes;
        }
        catch (Exception e) {
            throw new AnalyticsUDFException("Error while initializing UDF: " + e.getMessage(), e);
        }
    }

    public Object call(Object o) throws Exception {
        Method udfMethod = this.udfClass.getDeclaredMethod(this.udfMethodName, this.parameterTypes);
        try {
            if (Modifier.isStatic(udfMethod.getModifiers())) {
                return udfMethod.invoke(null, new Object[0]);
            }
            Object udfInstance = this.udfClass.newInstance();
            return udfMethod.invoke(udfInstance, new Object[0]);
        }
        catch (InvocationTargetException e) {
            log.error((Object)("Error while invoking method: " + this.udfMethodName + ", " + e.getMessage()), e.getCause());
            throw new Exception("Error while invoking method: " + this.udfMethodName + ", " + e.getMessage(), e.getCause());
        }
    }
}

