/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.spark.core.util.PublishingPayload;

public class CompressedEventAnalyticsUtils {
    private static final Log log = LogFactory.getLog(CompressedEventAnalyticsUtils.class);

    public static Object[] getFieldValues(List<String> columns, List<Object> event, List<PublishingPayload> payloadsList, int eventIndex, long timestamp, int _tenantId, int metaTenantId, String host) {
        Object[] fieldsVals = new Object[columns.size()];
        int eventFieldIndex = 0;
        if (event != null) {
            for (int i = 0; i < columns.size(); ++i) {
                if (columns.get(i).equals("_timestamp")) {
                    fieldsVals[i] = timestamp;
                    continue;
                }
                if (columns.get(i).equals("_tenantId")) {
                    fieldsVals[i] = _tenantId;
                    continue;
                }
                if (columns.get(i).equals("meta_tenantId")) {
                    fieldsVals[i] = metaTenantId;
                    continue;
                }
                if (columns.get(i).equals("host")) {
                    fieldsVals[i] = host;
                    continue;
                }
                fieldsVals[i] = event.get(eventFieldIndex);
                ++eventFieldIndex;
            }
        }
        if (payloadsList != null) {
            for (int j = 0; j < payloadsList.size(); ++j) {
                PublishingPayload publishingPalyload = payloadsList.get(j);
                String payload = publishingPalyload.getPayload();
                List<Integer> mappingAttributes = publishingPalyload.getEvents().get(eventIndex);
                if (mappingAttributes == null) continue;
                for (int k = 0; k < mappingAttributes.size(); ++k) {
                    fieldsVals[mappingAttributes.get((int)k).intValue()] = payload;
                }
            }
        }
        return fieldsVals;
    }

    public static ByteArrayInputStream decompress(String str) {
        ByteArrayInputStream byteInputStream = null;
        GZIPInputStream gzipInputStream = null;
        try {
            byteInputStream = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)str));
            gzipInputStream = new GZIPInputStream(byteInputStream);
            byte[] unzippedBytes = IOUtils.toByteArray((InputStream)gzipInputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(unzippedBytes);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new RuntimeException("Error occured while decompressing events string: " + e.getMessage(), e);
        }
        finally {
            try {
                if (byteInputStream != null) {
                    byteInputStream.close();
                }
                if (gzipInputStream != null) {
                    gzipInputStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error occured while closing streams: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

