/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.udf.adaptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.api.java.UDF13;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsUDFException;

public class UDF13Adaptor
implements UDF13 {
    private static final long serialVersionUID = 6482574263745592619L;
    private static Log log = LogFactory.getLog(UDF13Adaptor.class);
    private Class<Object> udfClass;
    private String udfMethodName;
    private Class[] parameterTypes;

    public UDF13Adaptor(Class<Object> udfClass, String udfMethodName, Class[] parameterTypes) throws AnalyticsUDFException {
        try {
            this.udfClass = udfClass;
            this.udfMethodName = udfMethodName;
            this.parameterTypes = parameterTypes;
        }
        catch (Exception e) {
            throw new AnalyticsUDFException("Error while initializing UDF: " + e.getMessage(), e);
        }
    }

    public Object call(Object o, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10, Object o11, Object o12, Object o13) throws Exception {
        Method udfMethod = this.udfClass.getDeclaredMethod(this.udfMethodName, this.parameterTypes);
        try {
            if (Modifier.isStatic(udfMethod.getModifiers())) {
                return udfMethod.invoke(null, o, o2, o3, o4, o5, o6, o7, o8, o9, o10, o11, o12, o13);
            }
            Object udfInstance = this.udfClass.newInstance();
            return udfMethod.invoke(udfInstance, o, o2, o3, o4, o5, o6, o7, o8, o9, o10, o11, o12, o13);
        }
        catch (InvocationTargetException e) {
            log.error((Object)("Error while invoking method: " + this.udfMethodName + ", " + e.getMessage()), e.getCause());
            throw new Exception("Error while invoking method: " + this.udfMethodName + ", " + e.getMessage(), e.getCause());
        }
    }
}

