/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.internal;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.datasource.core.util.GenericUtils;
import org.wso2.carbon.analytics.spark.core.AnalyticsTask;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsPersistenceException;
import org.wso2.carbon.analytics.spark.core.internal.ServiceHolder;
import org.wso2.carbon.analytics.spark.core.util.AnalyticsScript;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AnalyticsPersistenceManager {
    private static final Log log = LogFactory.getLog(AnalyticsPersistenceManager.class);
    private static AnalyticsPersistenceManager instance = new AnalyticsPersistenceManager();

    private AnalyticsPersistenceManager() {
    }

    public static AnalyticsPersistenceManager getInstance() {
        return instance;
    }

    private void createScriptsCollectionIfNotExists(UserRegistry registry) throws RegistryException {
        if (!registry.resourceExists("repository/components//org.wso2.carbon.analytics.spark")) {
            Collection collection = registry.newCollection();
            registry.put("repository/components//org.wso2.carbon.analytics.spark", (Resource)collection);
        }
    }

    public void saveScript(int tenantId, String scriptName, String scriptContent, String cron, String carbonAppName, boolean editable) throws AnalyticsPersistenceException {
        block6: {
            try {
                UserRegistry userRegistry = ServiceHolder.getTenantConfigRegistry(tenantId);
                this.createScriptsCollectionIfNotExists(userRegistry);
                String scriptLocation = this.getScriptLocation(scriptName);
                if (!userRegistry.resourceExists(scriptLocation)) {
                    AnalyticsScript script = this.processAndGetAnalyticsScript(scriptName, scriptContent, cron, carbonAppName, editable, null);
                    Resource resource = userRegistry.newResource();
                    resource.setContent((Object)this.getConfiguration(script));
                    resource.setMediaType("application/xml");
                    userRegistry.put(scriptLocation, resource);
                    try {
                        this.scheduleTask(tenantId, script);
                        break block6;
                    }
                    catch (AnalyticsPersistenceException ex) {
                        this.deleteScript(tenantId, scriptName);
                        throw ex;
                    }
                }
                throw new AnalyticsPersistenceException("Already a script exists with same name : " + scriptName + " for tenantId :" + tenantId);
            }
            catch (RegistryException e) {
                throw new AnalyticsPersistenceException("Error while loading the registry for tenant : " + tenantId, e);
            }
            catch (JAXBException e) {
                throw new AnalyticsPersistenceException("Error while saving the script : " + scriptName + "for tenantId : " + tenantId, e);
            }
        }
    }

    private AnalyticsScript processAndGetAnalyticsScript(String scriptName, String scriptContent, String cron, String carbonAppName, boolean editable, AnalyticsScript script) {
        if (script == null) {
            script = new AnalyticsScript(scriptName);
        }
        if (scriptContent != null && !scriptContent.trim().isEmpty()) {
            script.setScriptContent(scriptContent);
        }
        if (cron == null || cron.trim().isEmpty()) {
            script.setCronExpression(null);
        } else if (!cron.equals("DEFAULT")) {
            script.setCronExpression(cron);
        }
        script.setEditable(editable);
        script.setCarbonApplicationFileName(carbonAppName);
        return script;
    }

    private String getConfiguration(AnalyticsScript script) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AnalyticsScript.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)script, (Writer)stringWriter);
        return stringWriter.toString();
    }

    private void scheduleTask(int tenantId, AnalyticsScript script) throws AnalyticsPersistenceException {
        if (script.getCronExpression() != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("TENANT_ID", String.valueOf(tenantId));
            properties.put("SCRIPT_NAME", script.getName());
            TaskInfo.TriggerInfo triggerInfo = new TaskInfo.TriggerInfo(script.getCronExpression());
            triggerInfo.setDisallowConcurrentExecution(true);
            TaskInfo taskInfo = new TaskInfo(script.getName(), AnalyticsTask.class.getCanonicalName(), properties, triggerInfo);
            try {
                ServiceHolder.getTaskManager().registerTask(taskInfo);
                ServiceHolder.getTaskManager().rescheduleTask(taskInfo.getName());
            }
            catch (Exception e) {
                throw new AnalyticsPersistenceException("Error while trying to schedule task for script : " + script.getName() + " for tenant: " + tenantId + " with cron expression :" + script.getCronExpression() + " ." + e.getMessage(), e);
            }
        }
        try {
            ServiceHolder.getTaskManager().deleteTask(script.getName());
        }
        catch (TaskException e) {
            throw new AnalyticsPersistenceException("Error while trying un schedule the task :" + script.getName() + " for tenant : " + tenantId, e);
        }
    }

    private String getScriptLocation(String scriptName) throws AnalyticsPersistenceException {
        scriptName = GenericUtils.checkAndReturnPath((String)scriptName);
        return "repository/components//org.wso2.carbon.analytics.spark/" + scriptName + "." + "xml";
    }

    public void deleteScript(int tenantId, String scriptName) throws AnalyticsPersistenceException {
        try {
            UserRegistry userRegistry = ServiceHolder.getTenantConfigRegistry(tenantId);
            String scriptLocation = this.getScriptLocation(scriptName);
            if (userRegistry.resourceExists(scriptLocation)) {
                userRegistry.delete(scriptLocation);
                this.scheduleTask(tenantId, new AnalyticsScript(scriptName));
            } else {
                log.info((Object)("Cannot delete non existing script : " + scriptName + " for tenantId : " + tenantId + ". " + "It might have been deleted already."));
            }
        }
        catch (RegistryException e) {
            throw new AnalyticsPersistenceException("Error while loading the registry for tenant : " + tenantId, e);
        }
    }

    private AnalyticsScript getAnalyticsScript(String config) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AnalyticsScript.class});
        Unmarshaller un = context.createUnmarshaller();
        AnalyticsScript analyticsScript = (AnalyticsScript)un.unmarshal((Reader)new StringReader(config));
        if (!analyticsScript.isEditable()) {
            if (analyticsScript.getCarbonApplicationFileName() != null && !analyticsScript.getCarbonApplicationFileName().trim().isEmpty()) {
                String carbonAppLocation = MultitenantUtils.getAxis2RepositoryPath((int)PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId()) + File.separator + "carbonapps" + File.separator + analyticsScript.getCarbonApplicationFileName() + ".car";
                if (!new File(carbonAppLocation).exists()) {
                    analyticsScript.setEditable(true);
                }
            } else {
                analyticsScript.setEditable(true);
            }
        }
        return analyticsScript;
    }

    public void putScript(int tenantId, String scriptName, String scriptContent, String cron, String carbonAppName, boolean editable) throws AnalyticsPersistenceException {
        try {
            UserRegistry userRegistry = ServiceHolder.getTenantConfigRegistry(tenantId);
            String scriptLocation = this.getScriptLocation(scriptName);
            if (userRegistry.resourceExists(scriptLocation)) {
                Resource resource = userRegistry.get(scriptLocation);
                AnalyticsScript script = this.processAndGetAnalyticsScript(scriptName, scriptContent, cron, carbonAppName, editable, this.getAnalyticsScript(RegistryUtils.decodeBytes((byte[])((byte[])userRegistry.get(scriptLocation).getContent()))));
                resource.setContent((Object)this.getConfiguration(script));
                resource.setMediaType("application/xml");
                userRegistry.put(scriptLocation, resource);
                this.scheduleTask(tenantId, script);
            } else {
                this.saveScript(tenantId, scriptName, scriptContent, cron, carbonAppName, editable);
            }
        }
        catch (RegistryException e) {
            throw new AnalyticsPersistenceException("Error while loading the registry for tenant :" + tenantId, e);
        }
        catch (JAXBException e) {
            throw new AnalyticsPersistenceException("Error while converting the configuration for script : " + scriptName, e);
        }
    }

    public AnalyticsScript getAnalyticsScript(int tenantId, String scriptName) throws AnalyticsPersistenceException {
        try {
            UserRegistry registry = ServiceHolder.getTenantConfigRegistry(tenantId);
            String scriptLocation = this.getScriptLocation(scriptName);
            if (registry.resourceExists(scriptLocation)) {
                return this.getAnalyticsScript(RegistryUtils.decodeBytes((byte[])((byte[])registry.get(scriptLocation).getContent())));
            }
            throw new AnalyticsPersistenceException("No script exists with name : " + scriptName + " for tenantId : " + tenantId);
        }
        catch (RegistryException e) {
            throw new AnalyticsPersistenceException("Error while loading the registry for tenant : " + tenantId, e);
        }
        catch (JAXBException e) {
            throw new AnalyticsPersistenceException("Error while loading the configuration for script : " + scriptName, e);
        }
    }

    public List<AnalyticsScript> getAllAnalyticsScripts(int tenantId) throws AnalyticsPersistenceException {
        try {
            UserRegistry registry = ServiceHolder.getTenantConfigRegistry(tenantId);
            this.createScriptsCollectionIfNotExists(registry);
            Collection scriptsCollection = (Collection)registry.get("repository/components//org.wso2.carbon.analytics.spark");
            String[] scripts = scriptsCollection.getChildren();
            if (scripts != null) {
                ArrayList<AnalyticsScript> analyticsScripts = new ArrayList<AnalyticsScript>();
                for (String script : scripts) {
                    Object content = registry.get(script).getContent();
                    if (content instanceof byte[]) {
                        String configContent = RegistryUtils.decodeBytes((byte[])((byte[])content));
                        analyticsScripts.add(this.getAnalyticsScript(configContent));
                        continue;
                    }
                    log.error((Object)("Failed to load the configuration at: " + script + " for tenant: " + tenantId + ". Resource not in valid format. Required byte[] but found " + script.getClass().getCanonicalName()));
                }
                return analyticsScripts;
            }
            return null;
        }
        catch (RegistryException e) {
            throw new AnalyticsPersistenceException("Error while loading the registry for tenant : " + tenantId, e);
        }
        catch (JAXBException e) {
            throw new AnalyticsPersistenceException("Error while loading the configuration for scripts for tenant: " + tenantId, e);
        }
    }
}

